<?php

//ini_set('display_errors', 0);

//Inserta en fichero del día correspondiente la operación realizada
function Insertar_Sentencia($contenido, $tipo_operacion)
{

    require_once dirname(__DIR__) . '/config.php';

    //Ruta del fichero del presente dia.
    $ruta_fichero = crea_fichero_hoy($tipo_operacion);

    //Sentencia a escribir en el fichero
    $contenido = '[' . date('Y-m-d H:i:s') . '] - ' . $contenido;

    //Si en el fichero se puede escribir:
    if (!$fichero = fopen($ruta_fichero, 'a')) {
        exit;
    }
    if (fwrite($fichero, $contenido . "\r\n") === false) {
        exit;
    }
    fclose($fichero); //Cerramos el fichero.

    //Permisos
    chmod($ruta_fichero, 0777);

}

//Comprueba si existe el directorio del año y mes actual
//Crea directorio por año y mes
//Crea fichero por día (dentro del año y mes al que corresponda)
function crea_fichero_hoy($tipo_operacion)
{

    //Sacamos la fecha de hoy.
    $ano       = date('Y'); //Presente anio.
    $mes       = date('m'); //Presente mes.
    $dia       = date('d'); //Presente dia.
    $fecha_hoy = $dia . '-' . $mes . '-' . $ano;

    //Compruebo si está la carpeta del año
    $dir_ano = is_dir(DIRLOG . $tipo_operacion . "/" . $ano);
    if ($dir_ano != true) {

        //Si no está creo carpeta de año y primer mes
        mkdir(DIRLOG . $tipo_operacion . "/" . $ano, 0777);
        mkdir(DIRLOG . $tipo_operacion . "/" . $ano . "/" . $mes, 0777);

    } else {
        //Compruebo si está la carpeta del mes
        $dir_mes = is_dir(DIRLOG . $tipo_operacion . "/" . $ano . "/" . $mes);

        if ($dir_mes != true) {
            mkdir(DIRLOG . $tipo_operacion . "/" . $ano . "/" . $mes, 0777);
        }

    }

    //Ruta del archivo

    $ruta_fichero = DIRLOG . $tipo_operacion . "/" . $ano . "/" . $mes . "/" . $fecha_hoy . ".txt";
    return $ruta_fichero;

}
