
# Loyalty Event

Provides information about a loyalty event.
For more information, see [Search for Balance-Changing Loyalty Events](../../https://developer.squareup.com/docs/loyalty-api/loyalty-events).

## Structure

`LoyaltyEvent`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `id` | `string` | Required | The Square-assigned ID of the loyalty event.<br>**Constraints**: *Minimum Length*: `1` | getId(): string | setId(string id): void |
| `type` | [`string (LoyaltyEventType)`](../../doc/models/loyalty-event-type.md) | Required | The type of the loyalty event. | getType(): string | setType(string type): void |
| `createdAt` | `string` | Required | The timestamp when the event was created, in RFC 3339 format.<br>**Constraints**: *Minimum Length*: `1` | getCreatedAt(): string | setCreatedAt(string createdAt): void |
| `accumulatePoints` | [`?LoyaltyEventAccumulatePoints`](../../doc/models/loyalty-event-accumulate-points.md) | Optional | Provides metadata when the event `type` is `ACCUMULATE_POINTS`. | getAccumulatePoints(): ?LoyaltyEventAccumulatePoints | setAccumulatePoints(?LoyaltyEventAccumulatePoints accumulatePoints): void |
| `createReward` | [`?LoyaltyEventCreateReward`](../../doc/models/loyalty-event-create-reward.md) | Optional | Provides metadata when the event `type` is `CREATE_REWARD`. | getCreateReward(): ?LoyaltyEventCreateReward | setCreateReward(?LoyaltyEventCreateReward createReward): void |
| `redeemReward` | [`?LoyaltyEventRedeemReward`](../../doc/models/loyalty-event-redeem-reward.md) | Optional | Provides metadata when the event `type` is `REDEEM_REWARD`. | getRedeemReward(): ?LoyaltyEventRedeemReward | setRedeemReward(?LoyaltyEventRedeemReward redeemReward): void |
| `deleteReward` | [`?LoyaltyEventDeleteReward`](../../doc/models/loyalty-event-delete-reward.md) | Optional | Provides metadata when the event `type` is `DELETE_REWARD`. | getDeleteReward(): ?LoyaltyEventDeleteReward | setDeleteReward(?LoyaltyEventDeleteReward deleteReward): void |
| `adjustPoints` | [`?LoyaltyEventAdjustPoints`](../../doc/models/loyalty-event-adjust-points.md) | Optional | Provides metadata when the event `type` is `ADJUST_POINTS`. | getAdjustPoints(): ?LoyaltyEventAdjustPoints | setAdjustPoints(?LoyaltyEventAdjustPoints adjustPoints): void |
| `loyaltyAccountId` | `string` | Required | The ID of the [loyalty account](../../doc/models/loyalty-account.md) in which the event occurred.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `36` | getLoyaltyAccountId(): string | setLoyaltyAccountId(string loyaltyAccountId): void |
| `locationId` | `?string` | Optional | The ID of the [location](../../doc/models/location.md) where the event occurred. | getLocationId(): ?string | setLocationId(?string locationId): void |
| `source` | [`string (LoyaltyEventSource)`](../../doc/models/loyalty-event-source.md) | Required | Defines whether the event was generated by the Square Point of Sale. | getSource(): string | setSource(string source): void |
| `expirePoints` | [`?LoyaltyEventExpirePoints`](../../doc/models/loyalty-event-expire-points.md) | Optional | Provides metadata when the event `type` is `EXPIRE_POINTS`. | getExpirePoints(): ?LoyaltyEventExpirePoints | setExpirePoints(?LoyaltyEventExpirePoints expirePoints): void |
| `otherEvent` | [`?LoyaltyEventOther`](../../doc/models/loyalty-event-other.md) | Optional | Provides metadata when the event `type` is `OTHER`. | getOtherEvent(): ?LoyaltyEventOther | setOtherEvent(?LoyaltyEventOther otherEvent): void |

## Example (as JSON)

```json
{
  "id": "id0",
  "type": "EXPIRE_POINTS",
  "created_at": "created_at2",
  "accumulate_points": {
    "loyalty_program_id": "loyalty_program_id8",
    "points": 118,
    "order_id": "order_id8"
  },
  "create_reward": {
    "loyalty_program_id": "loyalty_program_id2",
    "reward_id": "reward_id6",
    "points": 90
  },
  "redeem_reward": {
    "loyalty_program_id": "loyalty_program_id8",
    "reward_id": "reward_id2",
    "order_id": "order_id8"
  },
  "delete_reward": {
    "loyalty_program_id": "loyalty_program_id4",
    "reward_id": "reward_id8",
    "points": 104
  },
  "adjust_points": {
    "loyalty_program_id": "loyalty_program_id2",
    "points": 96,
    "reason": "reason2"
  },
  "loyalty_account_id": "loyalty_account_id0",
  "source": "SQUARE"
}
```

