<?php

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/email_compra.txt');
error_reporting(E_ALL);

// OBTENGO INFORMACIÓN DE LA COMPRA
$sql_localizador = "SELECT l.*, c.Num_operacion, c.Referencia
                    FROM localizadores l JOIN CecaTpv c ON l.localizador = c.localizador
                    AND l.localizador = '" . $localizador . "'";

$result_localizador = $conexion->query($sql_localizador);
if ($result_localizador->rowCount() > 0) {
    $row_localizador = $result_localizador->fetch(PDO::FETCH_ASSOC);
}
// No tiene pago TPV
else {
    $sql_localizador = "SELECT *
                        FROM localizadores
                        WHERE localizador = '" . $localizador . "'";

    $result_localizador = $conexion->query($sql_localizador);
    $row_localizador    = $result_localizador->fetch(PDO::FETCH_ASSOC);
}

// Total
$total = sprintf('%0.2f', $row_localizador['total']);
$total = $total . ' €';

// SERVICIO Y ACTIVIDAD
// Traducción datos servicio
$product_lang = $language->getStringsProduct($row_localizador['servicio_id']);

$sql_servicio = "SELECT s.nombre as nombreS, a.nombre as nombreA, s.instalacion_id, i.nombre as nombreI, s.condiciones_servicio
                 FROM servicios s JOIN instalaciones i ON s.instalacion_id = i.id
                 JOIN actividades a ON s.actividad_id = a.id AND s.id = " . $row_localizador['servicio_id'];

$result_servicio = $conexion->query($sql_servicio);
if ($result_servicio->rowCount() > 0) {
    $row_servicio = $result_servicio->fetch(PDO::FETCH_ASSOC);
}

// Comprobamos si tiene un cupón de descuento asignado
$sql_localizador_completo    = "SELECT * FROM localizadores WHERE localizador = '" . $localizador . "'";
$result_localizador_completo = $conexion->query($sql_localizador_completo);
$row_localizador_completo    = $result_localizador_completo->fetch(PDO::FETCH_ASSOC);

$cupon_correo = "";
if ($row_localizador_completo['bono'] != '') {
    $sql_cupon_correo    = "SELECT * FROM bonos WHERE codigo = '" . $row_localizador_completo['bono'] . "' ";
    $result_cupon_correo = $conexion->query($sql_cupon_correo);

    if ($result_cupon_correo->rowCount() > 0) {
        $cupon_correo = $result_cupon_correo->fetch(PDO::FETCH_ASSOC);
    }
}

// Obtenemos el total reembolsado en la anulación
$sql_total_reembolso    = "SELECT (SUM(Ds_Amount) / 100) as total_reembolsado FROM Redsys WHERE Ds_TransactionType = 3 AND localizador = '" . $localizador . "'";
$result_total_reembolso = $conexion->query($sql_total_reembolso);

$total_reembolsado = 0;

if ($result_total_reembolso->rowCount() > 0) {

    $row_total_reembolso = $result_total_reembolso->fetch(PDO::FETCH_ASSOC);
    $total_reembolsado   = $row_total_reembolso['total_reembolsado'];

}

// Total reembolsado
$total_reembolsado_format = sprintf('%0.2f', $total_reembolsado);
$total_reembolsado_format = $total_reembolsado_format . ' €';

// TEXTOS PARA EL PDF
$section_message = 'email_cancelar_compra';
$servicio_texto  = $row_localizador['servicio_id'];
require_once DIRMODULOSCOMP . 'otros/messages_email_pdf.php';

// ENVÍO DE CORREO LOS DATOS DE LA RESERVA
//require_once DIRLIBCOMP . 'mail/class.phpmailer.php';

//$mail = new PHPMailer();

require_once DIRLIBCOMP . 'mail/PHPMailer.php';
require_once DIRLIBCOMP . 'mail/SMTP.php';
require_once DIRLIBCOMP . 'mail/Exception.php';

$mail = new PHPMailer\PHPMailer\PHPMailer(true);

$correo = obtenerDatosCorreo();

// -----------SMTP--------------
// Con PluginDir le indicamos a la clase phpmailer donde se
// encuentra la clase smtp que como he comentado al principio de
// este ejemplo va a estar en el subdirectorio includes
$mail->CharSet  = "UTF-8";
$mail->Encoding = 'base64';
// Con la propiedad Mailer le indicamos que vamos a usar un servidor smtp
$mail->Mailer = "smtp";
// Le indicamos el content-type HTML
$mail->isHTML(true);
$mail->SMTPSecure = 'tls';
// Asignamos a Host el nombre de nuestro servidor smtp
$mail->Host = MAILHOST;
// Le indicamos que el servidor smtp requiere autenticación
$mail->SMTPAuth = MAILSMTPAUTH;
// Le decimos cual es nuestro nombre de usuario y password
$mail->Username = $correo['user'] ?? MAILUSER;
$mail->Password = $correo['pass'] ?? MAILPASS;
// Asignamos a Host el nombre de nuestro servidor smtp
$mail->Port = MAILPORT;
$mail->From = $correo['mail'] ?? MAILFROM;
//$mail->AddCustomHeader('Reply-to:informacion.bodegas@pruebajig.es');

$mail->FromName = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($instalacion, "UTF-8", mb_detect_encoding($instalacion))) . "=?=";
//para que coja la 'ñ';
$mail->Subject = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($language->getString('Compra Anulada') . ' - ' . $instalacion, "UTF-8", mb_detect_encoding($language->getString('Compra Anulada') . ' - ' . $instalacion))) . "=?=";

$protocol   = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

// Paso de datos a la plantilla
$compra = array(
    'localizador'               => !empty($localizador) ?: '',
    'nombre'                    => !empty($row_localizador['nombre']) ?: '',
    'apellidos'                 => !empty($row_localizador['apellido']) ?: '',
    'telefono'                  => !empty($row_localizador['telefono']) ?: '',
    'email'                     => !empty($row_localizador['email']) ? $row_localizador['email'] : '',
    'actividad'                 => !empty($row_servicio['nombreA']) ? $row_servicio['nombreA'] : '',
    'servicio'                  => !empty($product_lang['nombre']) ? $product_lang['nombre'] : '',
    'instalacion'               => !empty($row_servicio['nombreI']) ? $row_servicio['nombreI'] : '',
    'total'                     => !empty($total) ? $total : '',
    'fecha_compra'              => !empty($row_localizador['fecha_compra']) ? cambiaf_a_normal($row_localizador['fecha_compra']) : '',
    'numOperacion'              => !empty($row_localizador['Num_operacion']) ? $row_localizador['Num_operacion'] : '',
    'referencia'                => !empty($row_localizador['Referencia']) ? $row_localizador['Referencia'] : '',
    'message_generico_emailPdf' => !empty($language->getString($message_generico_emailPdf)) ? $language->getString($message_generico_emailPdf) : '',
    'message_servicio_emailPdf' => !empty($language->getString($message_servicio_emailPdf)) ? $language->getString($message_generico_emailPdf) : '',
    'domainLink'                => !empty($domainLink) ? $domainLink : '',
    'cupon'                     => !empty($cupon_correo) ? $cupon_correo : '',
    'total_reembolsado'         => !empty($total_reembolsado) && $total_reembolsado > 0 ? $total_reembolsado_format : '',
    'condiciones_servicio'      => !empty($row_servicio['condiciones_servicio']) ? $row_servicio['condiciones_servicio'] : '',
    'instalacion_descripcion'   => !empty($instalacion_desc) ? $instalacion_desc : '',
    'instalacion_mapa'          => !empty($instalacion_mapa) ? $instalacion_mapa : '',
    'instalacion_prepago'       => !empty($instalacion_enlace) ? $instalacion_enlace : '',
);

ob_start();
require DIRLIBCOMP . 'mail/plantillas_correo/' . $_SESSION["lang"] . '/correo_anulacioncompra.php'; //Plantilla de correo

$body = ob_get_contents();
ob_end_clean();

$mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
$mail->Body    = $body;

// Envío de correo a debug 
$emails_debug = (array)json_decode($_ENV['MAIL_TO_NOTIFY_DEBUG'],true);
//Envío de correo
if (is_array($emails_debug) === true) {
    foreach ($emails_debug as $email_ua => $email_data) {        
        $destinatarios[] = array(
            'nombre' => $email_data['nombre'],
            'email'  => $email_data['email']);
    }
}

if (ENVIRONMENT == 'production') {

    //Bodega y eshop
    $emails_notify = (array)json_decode($_ENV['MAIL_TO_NOTIFY'],true);

    if (is_array($emails_notify) === true) {
        foreach ($emails_notify as $email_ua => $email_data) {        
            $destinatarios[] = array(
                'nombre' => $email_data['nombre'],
                'email'  => $email_data['email']);
        }
    }

    // Cliente
    if ($row_localizador['email'] != '') {
        $email_ua        = $row_localizador['email'];
        $destinatarios[] = array(
            'nombre' => $row_localizador['nombre'],
            'email'  => $email_ua);
    }
}

if (is_array($destinatarios) === true) {
    foreach ($destinatarios as $destino) {

        $mail->AddAddress($destino['email'], $destino['nombre']);
        if ($mail->Send()) {
            //return true;

        } else {
            //return false;
        }
        $mail->ClearAddresses();
    }
}
