<?php

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/email_reserva.txt');
error_reporting(E_ALL);

// OBTENGO INFORMACIÓN DE LA RESERVA
$sql_localizador = "SELECT l.*, s.pases, s.creditos, tp.pago, i.idioma
                    FROM localizadores l
                    JOIN servicios s ON l.servicio_id = s.id
                    JOIN tipos_pagos as tp ON l.tipo_pago = tp.id
                    JOIN idiomas as i on i.id = l.idioma
                    WHERE l.localizador = '" . $localizador . "'";

$result_localizador = $conexion->query($sql_localizador);
if ($result_localizador->rowCount() > 0) {
    $row_localizador = $result_localizador->fetch(PDO::FETCH_ASSOC);

    $total = sprintf('%0.2f', $row_localizador['total']);
    $total = $total . ' €';

    $fecha_compra  = $row_localizador['fecha_compra'];
    $idpedido      = $row_localizador['id_pedido'];
    $idioma_visita = $row_localizador['idioma'];
    $tipo_pago     = $row_localizador['pago'];

    // Compruebo si es servicio de créditos y bono
    if (($row_localizador['creditos']) && ($row_localizador['pases'] > 1)) {
        $creditos           = 1;
        $creditos_totales   = $row_localizador['pases_totales'];
        $creditos_restantes = $row_localizador['servicio_pases'];
    } else {
        $creditos = 0;
    }
}

// TEXTOS PARA EL PDF
$section_message = 'email_anular_reserva';
$servicio_texto  = $servicio_id;
require_once DIRMODULOSCOMP . 'otros/messages_email_pdf.php';

// INFORMACIÓN DE LA RESERVA A ANULAR
$sql_reserva_anular = "SELECT r.unidades, r.sala_horario_id, s.pases, ss.servicio_id, s.s_instalacion, s.pistas
                       FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
                       JOIN servicios s ON ss.servicio_id = s.id
                       AND localizador = '" . $localizador . "'
                       AND ss.servicio_id = " . $servicio_id . "
                       AND r.id = " . $reserva_anular;

$result_reservas_anular = $conexion->query($sql_reserva_anular);

if ($result_reservas_anular->rowCount() > 0) {
    $row_anular = $result_reservas_anular->fetch(PDO::FETCH_ASSOC);

    // Oculto plazas para las instalaciones
    if ($row_anular['s_instalacion'] == 0) {
        // Saco el numero de plazas de esa reserva
        $sql_tarifas_localizador = "SELECT lt.plazas_adulto
                                    FROM localizador_tarifas lt
                                    JOIN localizadores l ON l.localizador = lt.localizador
                                    WHERE l.localizador = '" . $localizador . "'";

        $result_tarifas_localizador = $conexion->query($sql_tarifas_localizador);

        $plazas_totales_localizador = 0;
        if ($result_tarifas_localizador->rowCount() > 0) {
            foreach ($result_tarifas_localizador as $row_tarifa_localizador) {
                $plazas_totales_localizador += $row_tarifa_localizador['plazas_adulto'];
            }
        }

        $unidades = $plazas_totales_localizador;
    } else {
        $unidades = '';
    }

    $horario = $row_anular['sala_horario_id'];
    $pistas  = $row_anular['pistas'];
}

// SERVICIO Y ACTIVIDAD
// Traducción datos servicio
$lang_product = $language->getStringsProduct($servicio_id);

$sql_servicio = "SELECT s.nombre as nombreS, s.sala_id, a.nombre as nombreA, i.nombre as nombreI, i.descripcion as instalacion_descripcion, i.google_maps as instalacion_mapa, i.enlace_prepago, s.horas_valle, s.pistas
                 FROM servicios s JOIN instalaciones i ON s.instalacion_id = i.id
                 JOIN actividades a ON s.actividad_id = a.id AND s.id = " . $servicio_id;

$result_servicio = $conexion->query($sql_servicio);
if ($result_servicio->rowCount() > 0) {
    $row_servicio = $result_servicio->fetch(PDO::FETCH_ASSOC);

    $servicio             = $lang_product['nombre'];
    $condiciones_servicio = $lang_product['condiciones_servicio'];
    $instalacion          = $row_servicio['nombreI'];
}

// DATOS RESERVA ANULADA
$sql_reserva = "SELECT sh.*, i.nombre as nombreI
                FROM sala_horarios sh JOIN salas sa ON sh.sala_id = sa.id
                JOIN instalaciones i ON sa.instalacion_id = i.id
                AND sh.id = " . $horario;

$result_reserva = $conexion->query($sql_reserva);
if ($result_reserva->rowCount() > 0) {
    $row_reserva = $result_reserva->fetch(PDO::FETCH_ASSOC);

    $hora_inicio = strtotime($row_reserva['hora_inicio']);
    $hora_inicio = date("H:i", $hora_inicio);
    $hora_fin    = strtotime($row_reserva['hora_fin']);
    $hora_fin    = date("H:i", $hora_fin);
    $horario     = $hora_inicio;

    $fecha = cambiaf_a_normal($row_reserva['fecha']);
}

// Dominio en el que estamos
$protocol   = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

$tarifas_nombre  = array();
$precios         = array();
$unidades_tarifa = array();

// Muestro información de las tarifas seleccionadas
$sql_tarifa_carrito = "SELECT lt.*, ug.nombre, t.precio, t.pago_grupo, t.usuarios_grupo_id
                       FROM localizador_tarifas lt JOIN tarifas t ON lt.tarifa_id = t.id
                       JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
                       AND lt.localizador = '" . $localizador . "'";

$result_tarifa_carrito = $conexion->query($sql_tarifa_carrito);

if ($result_tarifa_carrito->rowCount() > 0) {
    while ($row_tarifa = $result_tarifa_carrito->fetch(PDO::FETCH_ASSOC)) {

        $nombre_tarifa    = $row_tarifa['nombre'];
        $tarifas_nombre[] = $language->getString($nombre_tarifa, true);

        // Precio con dos decimales
        // Compruebo si precio es por grupo o por persona
        if ($row_tarifa['pago_grupo'] == 0) {
            $precio = $row_tarifa['precio'] * $row_tarifa['plazas_adulto'];
        } else {
            $precio = $row_tarifa['precio'];
        }

        $precio            = sprintf('%0.2f', $precio);
        $precios[]         = (float) $precio;
        $unidades_tarifa[] = $row_tarifa['plazas_adulto'];
    }

}

// Extras seleccionad
$sql_loc_extras = "SELECT le.*, e.nombre
                   FROM localizador_extras_servicio le JOIN extras_servicios e ON le.extra_id = e.id
                   INNER JOIN localizadores l on le.localizador_extra = l.localizador and l.estado='pagado' 
                   WHERE le.localizador = ?";

$result_loc_extras = $conexion->prepare($sql_loc_extras);
$result_loc_extras->execute(array($localizador));

$extras_seleccionados = array();
while ($row_loc_extra = $result_loc_extras->fetch()) {

    $nombre_extra = $language->getString($row_loc_extra['nombre'], true);

    $extras_seleccionados[] = array(
        'nombre'   => $language->getString($nombre_extra, true),
        'cantidad' => $row_loc_extra['unidades'],
        'precio'   => $row_loc_extra['total'],
    );
}

// Comprobamos si tiene un cupón de descuento asignado
$sql_localizador_completo    = "SELECT * FROM localizadores WHERE localizador = '" . $localizador . "'";
$result_localizador_completo = $conexion->query($sql_localizador_completo);
$row_localizador_completo    = $result_localizador_completo->fetch(PDO::FETCH_ASSOC);

$cupon_correo = "";
if ($row_localizador_completo['bono'] != '') {
    $sql_cupon_correo    = "SELECT * FROM bonos WHERE codigo = '" . $row_localizador_completo['bono'] . "' ";
    $result_cupon_correo = $conexion->query($sql_cupon_correo);

    if ($result_cupon_correo->rowCount() > 0) {
        $cupon_correo = $result_cupon_correo->fetch(PDO::FETCH_ASSOC);
    }
}

// Obtenemos el total reembolsado en la anulación
$sql_total_reembolso    = "SELECT (SUM(Ds_Amount) / 100) as total_reembolsado FROM Redsys WHERE Ds_TransactionType = 3 AND localizador = '" . $localizador . "'";
$result_total_reembolso = $conexion->query($sql_total_reembolso);

$total_reembolsado = 0;

if ($result_total_reembolso->rowCount() > 0) {

    $row_total_reembolso = $result_total_reembolso->fetch(PDO::FETCH_ASSOC);
    $total_reembolsado   = $row_total_reembolso['total_reembolsado'];

}

// Total reembolsado
$total_reembolsado_format = sprintf('%0.2f', $total_reembolsado);
$total_reembolsado_format = $total_reembolsado_format . ' €';

// ENVÍO DE CORREO LOS DATOS DE LA RESERVA
//include DIRLIBCOMP . 'mail/class.phpmailer.php';

//$mail = new PHPMailer();

require_once DIRLIBCOMP . 'mail/PHPMailer.php';
require_once DIRLIBCOMP . 'mail/SMTP.php';
require_once DIRLIBCOMP . 'mail/Exception.php';

$mail = new PHPMailer\PHPMailer\PHPMailer(true);

$correo = obtenerDatosCorreo();

// -----------SMTP--------------
// Con PluginDir le indicamos a la clase phpmailer donde se
// encuentra la clase smtp que como he comentado al principio de
// este ejemplo va a estar en el subdirectorio includes
$mail->CharSet   = "UTF-8";
$mail->Encoding  = 'base64';
// $mail->PluginDir = "";
// Con la propiedad Mailer le indicamos que vamos a usar un servidor smtp
$mail->Mailer = "smtp";
// Le indicamos el content-type HTML
$mail->isHTML(true);
$mail->SMTPSecure = 'tls';
// Asignamos a Host el nombre de nuestro servidor smtp
$mail->Host = MAILHOST;
// Le indicamos que el servidor smtp requiere autenticación
$mail->SMTPAuth = MAILSMTPAUTH;
// Le decimos cual es nuestro nombre de usuario y password
$mail->Username = $correo['user'] ?? MAILUSER;
$mail->Password = $correo['pass'] ?? MAILPASS;
// Asignamos a Host el nombre de nuestro servidor smtp
$mail->Port = MAILPORT;
$mail->From = $correo['mail'] ?? MAILFROM;
//$mail->SetLanguage(strtolower(substr($language->getSessionLang(), 0, -3)), DIRLIBCOMP . 'mail/');
//$mail->AddCustomHeader('Reply-to:informacion.bodegas@pruebajig.es');
//$mail->SMTPDebug = 2;

$mail->FromName = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($instalacion, "UTF-8", mb_detect_encoding($instalacion))) . "=?=";
//para que coja la 'ñ';
$mail->Subject = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($language->getString('Reserva Anulada',true) . ' - ' . $instalacion, "UTF-8", mb_detect_encoding($language->getString('Reserva Anulada',true) . ' - ' . $instalacion))) . "=?=";

// Paso de datos a la plantilla
$reserva = array(
    'localizador'               => !empty($localizador) ? $localizador : '',
    'nombre'                    => !empty($row_localizador['nombre']) ? $row_localizador['nombre'] : '',
    'apellidos'                 => !empty($row_localizador['apellido']) ? $row_localizador['apellido'] : '',
    'telefono'                  => !empty($row_localizador['telefono']) ? $row_localizador['telefono'] : '',
    'email'                     => !empty($row_localizador['email']) ? $row_localizador['email'] : '',
    'actividad'                 => !empty($row_servicio['nombreA']) ? $row_servicio['nombreA'] : '',
    'servicio'                  => !empty($servicio) ? $servicio : '',
    'instalacion'               => !empty($row_reserva['nombreI']) ? $row_reserva['nombreI'] : '',
    'creditos'                  => !empty($creditos) ? $creditos : '',
    'creditos_totales'          => !empty($creditos_totales) ? $creditos_totales : '',
    'creditos_restantes'        => !empty($creditos_restantes) ?: '',
    'horario'                   => !empty($horario) ? $horario : '',
    'fecha_reserva'             => !empty($fecha) ? $fecha : '',
    'plazas'                    => !empty($unidades) ? $unidades : '',
    'message_generico_emailPdf' => !empty($language->getString($message_generico_emailPdf)) ?: '',
    'message_servicio_emailPdf' => !empty($language->getString($message_servicio_emailPdf)) ?: '',
    'domainLink'                => !empty($domainLink) ? $domainLink : '',
    'cupon'                     => !empty($cupon_correo) ? $cupon_correo : '',
    'total_reembolsado'         => !empty($total_reembolsado) && $total_reembolsado > 0 ? $total_reembolsado_format : '',
    'condiciones_servicio'      => !empty($condiciones_servicio) ? $condiciones_servicio : '',
    'id_pedido'                 => !empty($idpedido) ? $idpedido : '',
    'fecha_compra'              => !empty($fecha_compra) ? cambiaf_a_normal($fecha_compra) : '',
    'pago_seleccionado'         => !empty($tipo_pago) ? $tipo_pago : '',
    'idioma_visita'             => !empty($idioma_visita) ? $idioma_visita : '',
    'precios'                   => !empty($precios) ? $precios : array(),
    'unidades_tarifa'           => !empty($unidades_tarifa) ? $unidades_tarifa : array(),
    'tarifas_nombre'            => !empty($tarifas_nombre) ? $tarifas_nombre : array(),
    'total'                     => !empty($total) ? (float) $total : '',
    'extras_seleccionados'      => !empty($extras_seleccionados) ? $extras_seleccionados : array(),
    'instalacion_descripcion'   => !empty($row_servicio['instalacion_descripcion']) ? $row_servicio['instalacion_descripcion'] : '',
    'instalacion_mapa'          => !empty($row_servicio['instalacion_mapa']) ? $row_servicio['instalacion_mapa'] : '',
    'instalacion_prepago'       => !empty($row_servicio['enlace_prepago']) ? $row_servicio['enlace_prepago'] : '',

);

$compra = $reserva;

ob_start();
require DIRLIBCOMP . 'mail/plantillas_correo/' . $_SESSION["visitas_lang"] . '/correo_anulacionreserva.php'; //Plantilla de correo

$body = ob_get_contents();
ob_end_clean();

$mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
$mail->Body    = $body;

// Envío de correo a debug 
$emails_debug = (array)json_decode($_ENV['MAIL_TO_NOTIFY_DEBUG'],true);
//Envío de correo
if (is_array($emails_debug) === true) {
    foreach ($emails_debug as $email_ua => $email_data) {        
        $destinatarios[] = array(
            'nombre' => $email_data['nombre'],
            'email'  => $email_data['email']);
    }
}

if (ENVIRONMENT == 'production') {

    //Bodega y eshop
    $emails_notify = (array)json_decode($_ENV['MAIL_TO_NOTIFY'],true);

    if (is_array($emails_notify) === true) {
        foreach ($emails_notify as $email_ua => $email_data) {        
            $destinatarios[] = array(
                'nombre' => $email_data['nombre'],
                'email'  => $email_data['email']);
        }
    }
    // Cliente
    if ($row_localizador['email'] != '') {
        $email_ua        = $row_localizador['email'];
        $destinatarios[] = array(
            'nombre' => $row_localizador['nombre'],
            'email'  => $email_ua);
    }
}

if (is_array($destinatarios) === true) {
    foreach ($destinatarios as $destino) {

        $mail->AddAddress($destino['email'], $destino['nombre']);
        if ($mail->Send()) {
            //return true;

        } else {
            //return false;
        }
        $mail->ClearAddresses();
    }
}
