<?php
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/email_compra.txt');
error_reporting(E_ALL);
if (!isset($_POST['confirmar_anulacion_reserva'])) {

} else {

    // Busco información de la reserva a anular en "reservas"
    $sql_reservas = "SELECT r.unidades, r.sala_horario_id, s.pases, ss.servicio_id, s.horario_completo, s.id as idS
                     FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
                     JOIN servicios s ON ss.servicio_id = s.id
                     AND localizador = '" . $localizador . "'
                     AND ss.servicio_id = " . $servicio_id . "
                     AND r.id = " . $reserva_anular;

    $result_reservas = $conexion->query($sql_reservas);

    if ($result_reservas->rowCount() > 0) {
        $row_reservas = $result_reservas->fetch(PDO::FETCH_ASSOC);

        $horario_sala = $row_reservas['sala_horario_id'];
        $servicio_id  = $row_reservas['servicio_id'];

        // Unidades que añado al horario relacionado con la reserva
        // anulada
        $unidades = $row_reservas['unidades'];

        // Compruebo pases del servicio comprado
        $sql_servicio_localizador = "SELECT s.pases
                                     FROM localizadores l JOIN servicios s ON l.servicio_id = s.id
                                     AND l.localizador = '" . $localizador . "'";

        $result_servicio_localizador = $conexion->query($sql_servicio_localizador);

        if ($result_servicio_localizador->rowCount() > 0) {
            $row_servicio_localizador = $result_servicio_localizador->fetch();

            // Si el servicio es de un pase sólo añado 1 pase a la reserva, sino
            // las unidades reservadas
            if ($row_servicio_localizador['pases'] > 1) {
                $pases = $row_reservas['unidades'];
            } else {
                $pases = $row_servicio_localizador['pases'];
            }
        }
    }

    // CRÉDITOS O PASES
    // Compruebo si el servicio reservado es de descuento de CRÉDITOS
    // y no de pases, en caso que el servicio comprado sea un bono
    // Modifico localizador añadiendo unidades o créditos de la reserva
    $modulo = 'anular';
    require_once DIRMODULOSCOMP . 'compra/cambios_bd/descuenta_creditos_oplazas.php';

    // Envío de correo de anulación
    require_once DIRMODULOSCOMP . 'anular/correo_anulacionreserva.php';    
    
    // Modifico horario añadiendo unidades de la reserva
    // Si el servicio es de reserva de horario completo, devuelvo el máximo
    // de plazas de la sala
    if ($row_reservas['horario_completo'] == 1) {

        $sql_sala = "SELECT plazas
                     FROM servicios s JOIN salas sa ON s.sala_id = sa.id
                     AND s.id = " . $row_reservas['idS'];

        $result_sala = $conexion->query($sql_sala);

        if ($result_sala->rowCount() > 0) {
            $row_sala = $result_sala->fetch();

            $unidades = $row_sala['plazas'];
        }
    }

    $sql_update_horario = "UPDATE sala_horarios sh
                           JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                           SET sh.plazas_libres = plazas_libres + " . $unidades . "
                           WHERE sh.id = " . $horario_sala . "
                           AND ss.servicio_id =" . $servicio_id;

    $result_update_horario = $conexion->query($sql_update_horario);

    // Actualizo reserva con el campo cancelada a 1
    $sql_update_horario = "UPDATE reservas SET cancelada = 1
                           WHERE sala_horario_id = " . $horario_sala . "
                           AND id = " . $reserva_anular . "
                           AND localizador = '" . $localizador . "'";

    $result_update_horario = $conexion->query($sql_update_horario);

    /*** REGISTRO LOGS  ****/
    $sentencia = "LOCALIZADOR - " . $localizador . " - Se han añadido " . $unidades . " plazas al horario " . $horario_sala . " para el servicio " . $servicio_id;
    Insertar_Sentencia($sentencia, 'anulacion');
    $sentencia = "LOCALIZADOR - " . $localizador . " - Se ha cancelado la reserva " . $reserva_anular . " con horario " . $horario_sala . " para el localizador";
    Insertar_Sentencia($sentencia, 'anulacion');

    // Modifico estado del localizador para ponerlo en estado de compra anulada
    $sql_update_localizador    = "UPDATE localizadores SET anulacion = ?, fecha_anulacion = ? WHERE localizador = ?";
    $result_update_localizador = $conexion->prepare($sql_update_localizador);
    $exito_l                   = $result_update_localizador->execute(array(1, date('Y-m-d'), $localizador));

    /*** REGISTRO LOGS  ****/
    $sentencia = "LOCALIZADOR - " . $localizador . " - Se ha anulado la compra con fecha " . date('Y-m-d');
    Insertar_Sentencia($sentencia, 'anulacion');
}
