<?php
session_start();

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/Redsys_ipn_error_log.txt');
error_reporting(E_ALL);

logRedsys("Nueva Recepcion RedSYS\n");
logRedsys("DATOS => " . var_export($_REQUEST, true) . "\n");

require_once dirname(__DIR__) . '/../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRLIBCOMP . 'registro_logs.php';
require_once DIRLIBCOMP . 'clases/lang.php';
require_once DIRLIBCOMP . 'clases/messages.php';
require DIRLIBCOMP . 'apiRedsys.php';
require_once 'devolver_stock.php';

$conexion  = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);
$conexion2 = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);
$language  = new lang();
$message   = new messages();

$errores = array(
    'ErrActu'  => "Error en actualización tablas Redsys, Reservas y/o Localizadores par localizador existente.\n",
    'NoLoRe'   => "Localizador o Reserva no figuran en sus tablas ni en tablas de borrado. Posible duplicidad en Redsys.\n",
    'ErrRec'   => "Error en el proceso de recuperación de borrados.\n",
    'ErrComp'  => "El servicio referido al localizador ha sido completado, no es posible su recuperación",
    'ErrSign'  => "La firma del banco es errónea.\n",
    'ErrAuth'  => "Pago denegado.\n",
    'Correcto' => "Proceso completado correctamente.\n",
    'NoHisto'  => "Localizador o Reserva no figuran en sus tablas ni en tablas de borrado, ni en el histórico de pedidos. Posible duplicidad en Redsys.\n",
);

$conexion->beginTransaction();

$redsysObject = create_redsys($_REQUEST);

logRedsys("DATOS => " . var_export($redsysObject, true) . "\n");

if ($redsysObject['datos']['estado'] == 'firmaKO') {
    // SI LA FIRMA DE REDSYS ES INCORRECTA SE PRODUCE ERROR
    $result['estado']  = false;
    $result['literal'] = 'ErrSign';
    logRedsys("ERROR: " . $errores[$result['literal']]);
    redsys_update($redsysObject, $conexion);
    devolver_stock('20' . $redsysObject['datos']['pedido'], $conexion2);
} elseif ($redsysObject['datos']['estado'] == 'denegado') {
    // SI EL PAGO ES DENEGADO SE PRODUCE ERROR
    $result['estado']  = false;
    $result['literal'] = 'ErrAuth';
    logRedsys("ERROR: " . $errores[$result['literal']]);
    redsys_update($redsysObject, $conexion);
    devolver_stock('20' . $redsysObject['datos']['pedido'], $conexion2);
} else {
    $localizadores_alta = verificarLocalizador('localizadores', $redsysObject, $conexion);

    if ($localizadores_alta['extra'] == 1) {
        $result['extra']             = $localizadores_alta['extra'];
        $result['localizador_extra'] = $localizadores_alta['localizador_extra'];
    }

    if (!$localizadores_alta['incidencia']) {
        if ($localizadores_alta['filas'] == 1) {
            $sentencia        = "LOCALIZADOR - " . $localizadores_alta['localizador'] . " - " . $redsysObject['datos']['datos_comercio'] . " - 000 a" .  date("Y-m-d H:i:s");
            Insertar_Sentencia($sentencia, 'compra');
            // SI EL LOCALIZADOR EXISTE Y ES UNICO SE INTENTA ACTUALIZAR REDYSS LOCALIZADORES Y RESERVAS
            $result['estado']  = (redsys_update($redsysObject, $conexion) && loc_res_update($localizadores_alta['localizador'], $conexion));
            $result['literal'] = (!$result['estado']) ? 'ErrActu' : 'Correcto';
            logRedsys("Resultado de la recepción: " . $errores[$result['literal']]);

            $sentencia        = "LOCALIZADOR - " . $localizadores_alta['localizador'] . " - " . $redsysObject['datos']['datos_comercio'] . " - 000 b" .  date("Y-m-d H:i:s");
            Insertar_Sentencia($sentencia, 'compra');
        } else {
            // SI EL LOCALIZADOR NO EXISTE O NO ES UNICO SE TRATA DE RECUPERAR
            logRedsys("Se ha recibido una confirmación de compra de un localizador no existente o duplicado\n");
            $localizadores_borrados = verificarLocalizador('localizadores_borrados', $redsysObject, $conexion);

            if ($localizadores_borrados['extra'] == 1) {
                $result['extra']             = $localizadores_borrados['extra'];
                $result['localizador_extra'] = $localizadores_borrados['localizador_extra'];
            }

            if ($localizadores_borrados['filas'] == 0) {
                // SI EL LOCALIZADOR NO EXISTE EN BORRADOS SE COMPRUEBA EL HISTÓRICO DE PEDIDOS POR SI HA PAGADO OTRO IDPEDIDO
                $esta_historico = comprueba_histórico($redsysObject['datos']['datos_comercio'], $conexion);
                if ($esta_historico['filas'] != 0) {
                    $sentencia        = "LOCALIZADOR - " . $esta_historico['localizador'] . " - " . $redsysObject['datos']['datos_comercio'] . " - 001 ";
                    Insertar_Sentencia($sentencia, 'compra');
                    if (calcularPlazasNoBorrados($esta_historico['localizador'], $conexion)) {
                        // Modificamos el id pedido de redsys y del localizador
                        $actualizar = actualizar_id_pedido($esta_historico['localizador'], $redsysObject['datos']['pedido'], $conexion);

                        if ($actualizar) {
                            $sentencia        = "LOCALIZADOR - " . $esta_historico['localizador'] . " - " . $redsysObject['datos']['datos_comercio'] . " - 002 a" .  date("Y-m-d H:i:s");
                            Insertar_Sentencia($sentencia, 'compra');
                            $result['estado'] = redsys_update($redsysObject, $conexion) && loc_res_update($esta_historico['localizador'], $conexion);
                            $sentencia        = "LOCALIZADOR - " . $esta_historico['localizador'] . " - " . $redsysObject['datos']['datos_comercio'] . " - 002 b" .  date("Y-m-d H:i:s");
                            Insertar_Sentencia($sentencia, 'compra');
                        } else {
                            $sentencia        = "LOCALIZADOR - " . $esta_historico['localizador'] . " - " . $redsysObject['datos']['datos_comercio'] . " - 003 ";
                            Insertar_Sentencia($sentencia, 'compra');
                            $result['estado']  = false;
                            $result['literal'] = "ErrComp";
                            logRedsys("ERROR: " . $errores[$result['literal']]);
                            devolver_stock('20' . $redsysObject['datos']['pedido'], $conexion);
                        }
                    } else {
                        $sentencia        = "LOCALIZADOR - " . $esta_historico['localizador'] . " - " . $redsysObject['datos']['datos_comercio'] . " - 004 ";
                        Insertar_Sentencia($sentencia, 'compra');
                        // SI NO ES POSIBLE REINSERTAR POR OVERBOKING SE PRODUCE ERROR
                        $result['estado']  = false;
                        $result['literal'] = "ErrComp";
                        logRedsys("ERROR: " . $errores[$result['literal']]);
                        devolver_stock('20' . $redsysObject['datos']['pedido'], $conexion);
                    }
                } else {
                    $sentencia        = "LOCALIZADOR - " . $redsysObject['datos']['datos_comercio'] . " - 005 ";
                    Insertar_Sentencia($sentencia, 'compra');
                    $result['estado']  = false;
                    $result['literal'] = 'NoHisto';
                    logRedsys("ERROR: " . $errores[$result['literal']]);
                    devolver_stock('20' . $redsysObject['datos']['pedido'], $conexion);
                }
            } else {
                // SI EL LOCALIZADOR EXISTE EN BORRADOS SE TRATA DE INCLUIR EN EL PLANNING
                logRedsys("El localizador figura en el registro de borrados. Iniciamos recuperación.\n");
                if (calcularPlazas($localizadores_borrados['localizador'], $conexion)) {
                    $sentencia        = "LOCALIZADOR - " . $localizadores_borrados['localizador'] . " - " . $redsysObject['datos']['datos_comercio'] . " - 006 ";
                    Insertar_Sentencia($sentencia, 'compra');
                    // SI SE PUEDE REINSERTAR SE RECUPERAN DE LOS BORRADOS
                    $data_recuperados = recuperarBorrados($localizadores_borrados['localizador'], $redsysObject, $conexion);
                    $result['estado']  = $data_recuperados[0];
                    $result['extra']   = $data_recuperados[1]['extra'];

                    if ($data_recuperados[1]['extra'] == 1) {
                        $result['extra']             = $data_recuperados[1]['extra'];
                        $result['localizador_extra'] = $data_recuperados[1]['localizador_extra'];
                    }

                    $result['literal'] = ($result['estado'] == false) ? "ErrRec" : "Correcto";
                    logRedsys("Resultado de la recepción: " . $errores[$result['literal']]);
                } else {
                    $sentencia        = "LOCALIZADOR - " . $localizadores_borrados['localizador'] . " - " . $redsysObject['datos']['datos_comercio'] . " - 007 ";
                    Insertar_Sentencia($sentencia, 'compra');
                    // SI NO ES POSIBLE REINSERTAR POR OVERBOKING SE PRODUCE ERROR
                    $result['estado']  = false;
                    $result['literal'] = "ErrComp";
                    logRedsys("ERROR: " . $errores[$result['literal']]);
                    devolver_stock('20' . $redsysObject['datos']['pedido'], $conexion);
                }
            }
        }
    } else {
        $result['estado'] = false;
        $sentencia        = "LOCALIZADOR - " . $localizador . " error con lo pagado en Redsys: " . $localizadores_alta['total_redsys'] . " con respecto a lo anotado en la tabla localizadores: " . $localizadores_alta['total_localizador'];
        Insertar_Sentencia($sentencia, 'compra');
    }

    if ($result['estado'] == true) {

        // SI EL RESULTADO ES CORRECTO SE HACE COMMIT Y SE INFORMA EL MAIL
        $conexion->commit();
        $datos_comercio = $redsysObject['datos']['datos_comercio'];
        Insertar_Sentencia('intentamos mandar el correo ', 'compra');

        if ($result['extra'] == 1) {
            require_once DIRMODULOSCOMP . 'compra/procesar_email_compra_extra.php';
        } else {
            require_once DIRMODULOSCOMP . 'compra/procesar_email_compra.php';
        }

        $sentencia = "LOCALIZADOR - " . $localizador . " - La reserva para el localizador ha cambiado de estado: finalizada";
        Insertar_Sentencia($sentencia, 'compra');
        $sentencia = "LOCALIZADOR - " . $localizador . " - Cambio de estado: pagado";
        Insertar_Sentencia($sentencia, 'compra');
    } else {
        // SI EL RESULTADO ES INCORRECTO SE HACE ROLLBACK
        $conexion->rollback();
        // ¿POSIBLE NUEVA FUNCIONALIDAD PARA ENVIAR MAIL DE ERROR?
        // require_once DIRMODULOSCOMP . 'compra/procesar_email_error_compra.php';
        $sentencia = "LOCALIZADOR - " . $localizador . " ERROR EN EL PROCESO: " . $errores[$result['literal']];
        Insertar_Sentencia($sentencia, 'compra');
    }
}

// GENERA NUESTRO OBJETO REDSYS CON TODOS LOS DATOS CON LA REQUEST
function create_redsys($request)
{

    $miObj2            = new RedsysAPI;
    $salida            = array();
    $salida['firmaOK'] = ($miObj2->createMerchantSignatureNotif(RedsysKey, $request["Ds_MerchantParameters"]) === $request["Ds_Signature"]);
    //$salida['firmaOK']                    = ($miObj2->createMerchantSignatureNotif('ATZu9ax6KKc0DuC2n+BLsQ9b50l+YZtB', $request["Ds_MerchantParameters"]) === $request["Ds_Signature"]);
    $salida['datos']                      = array();
    $salida['datos']['signatureRecibida'] = $request["Ds_Signature"];
    $salida['datos']['total']             = $miObj2->getParameter('Ds_Amount');
    $salida['datos']['pedido']            = $miObj2->getParameter('Ds_Order');
    $salida['datos']['codigo']            = $miObj2->getParameter('Ds_MerchantCode');
    $salida['datos']['moneda']            = $miObj2->getParameter('Ds_Currency');
    $salida['datos']['respuesta']         = $miObj2->getParameter('Ds_Response');
    $salida['datos']['terminal']          = $miObj2->getParameter('Ds_Terminal');
    $salida['datos']['pago_seguro']       = $miObj2->getParameter('Ds_SecurePayment');
    $salida['datos']['tipo_trans']        = $miObj2->getParameter('Ds_TransactionType');
    $salida['datos']['pais_tit']          = $miObj2->getParameter('Ds_Card_Country');
    $salida['datos']['cod_autorizacion']  = $miObj2->getParameter('Ds_AuthorisationCode');
    $salida['datos']['idioma_tit']        = $miObj2->getParameter('Ds_ConsumerLanguage');
    $salida['datos']['fecha_trans']       = urldecode($miObj2->getParameter('Ds_Date'));
    $salida['datos']['hora_trans']        = urldecode($miObj2->getParameter('Ds_Hour'));
    $salida['datos']['datos_comercio']    = $miObj2->getParameter('Ds_MerchantData');
    $salida['datos']['datos_comercio']    = ($salida['datos']['datos_comercio'] == '' || $salida['datos']['datos_comercio'] == null) ? '20' . $salida['datos']['pedido'] : $salida['datos']['datos_comercio'];
    $salida['datos']['estado']            = $salida['firmaOK'] ? ((intval($salida['datos']['respuesta']) >= 0 && intval($salida['datos']['respuesta'] <= 99)) ? 'pagado' : 'denegado') : 'firmaKO';
    $salida['datos']['m_identifier']      = $miObj2->getParameter('Ds_Merchant_Identifier');
    logRedsys("DATOS DESENCRIPTADOS => " . var_export($salida, true) . "\n\n");
    return $salida;
}

// Actualiza Redsys con un objeto facilitado en la conexión indicada.
function redsys_update($redsys, $conexion)
{
    $sql_tpv = "UPDATE Redsys
                SET
                    Ds_Currency          = ?,
                    Ds_MerchantCode      = ?,
                    Ds_Terminal          = ?,
                    Ds_Signature         = ?,
                    Ds_Response          = ?,
                    Ds_SecurePayment     = ?,
                    Ds_TransactionType   = ?,
                    Ds_Card_Country      = ?,
                    Ds_AuthorisationCode = ?,
                    Ds_ConsumerLanguage  = ?,
                    Ds_Date              = ?,
                    Ds_Hour              = ?,
                    estado               = ?,
                    Ds_Merchant_Identifier = ?
                WHERE Ds_MerchantData = ?";
    $result_tpv = $conexion->prepare($sql_tpv);
    $exec_tpv   = $result_tpv->execute(array(
        $redsys['datos']['moneda'],
        $redsys['datos']['codigo'],
        $redsys['datos']['terminal'],
        $redsys['datos']['signatureRecibida'],
        $redsys['datos']['respuesta'],
        $redsys['datos']['pago_seguro'],
        $redsys['datos']['tipo_trans'],
        $redsys['datos']['pais_tit'],
        $redsys['datos']['cod_autorizacion'],
        $redsys['datos']['idioma_tit'],
        $redsys['datos']['fecha_trans'],
        $redsys['datos']['hora_trans'],
        $redsys['datos']['estado'],
        $redsys['datos']['m_identifier'],
        $redsys['datos']['datos_comercio'],
    ));
    $sentencia = "MERCHANTDATA - " . $redsys['datos']['datos_comercio'] . " - Actualizacion tabla tpv:" . var_export($exec_tpv, true);
    Insertar_Sentencia($sentencia, 'compra');
    return $exec_tpv;
}

// Actualiza el estado de localizadoresa pagado y reservas a finalizada en la conexión indicada.
function loc_res_update($localizador, $conexion)
{
    $update_loc = " UPDATE localizadores
                    SET estado = 'pagado'
                    WHERE localizador = ?";
    $result_localizador = $conexion->prepare($update_loc);
    $exec_loc           = $result_localizador->execute(array($localizador));
    $sentencia          = "LOCALIZADOR - " . $localizador . " - Actualizacion tabla localizadores:" . var_export($exec_loc, true);
    $update_res         = " UPDATE reservas
                            SET estado = 'finalizada'
                            WHERE localizador = ?";
    $result_reserva = $conexion->prepare($update_res);
    $exec_res       = $result_reserva->execute(array($localizador));
    $sentencia      = "LOCALIZADOR - " . $localizador . " - Actualizacion tabla reservas:" . var_export($exec_res, true);
    Insertar_Sentencia($sentencia, 'compra');

    $update_ext = " UPDATE localizador_extras_servicio
    SET estado = 'pagado'
    WHERE localizador_extra = ?";
    $result_ext = $conexion->prepare($update_ext);
    $exec_res       = $result_ext->execute(array($localizador));
    $sentencia      = "LOCALIZADOR - " . $localizador . " - Actualizacion tabla extras:" . var_export($exec_res, true);
    Insertar_Sentencia($sentencia, 'compra');
    return $exec_loc && $exec_res;
}

// Recibe el nombre de una tabla, el filtro de búsqueda y los datos de conexión a BBDD
// Devuelve un array con el número de filas de la query correspondiente al join de Redsys y la tabla remitida filtrando por MerchantData
// y en caso de existir resultados el primer localizador.
function verificarLocalizador($tabla, $redsysResponse, $conexion)
{
    $sql_localizador = "SELECT localizador.localizador as loc, IF( localizador.total_adelantado_mesa IS NOT NULL, localizador.total_adelantado_mesa, localizador.total) AS total, localizador.extra as extra
                        FROM " . $tabla . " localizador JOIN Redsys tpv ON localizador.localizador = tpv.localizador
                        AND tpv.Ds_MerchantData = :pedido ";
    $result_localizador = $conexion->prepare($sql_localizador);
    $exec_localizador   = $result_localizador->execute(array(
        ':pedido' => $redsysResponse['datos']['datos_comercio']
    ));

    $result['filas']      = $result_localizador->rowCount();
    $result['incidencia'] = false;
    $result['extra']      = false;
    if ($result['filas'] > 0) {
        $row = $result_localizador->fetch(PDO::FETCH_ASSOC);

        // Las comparativas con campos de tipo float dan problemas
        $desviacion = 0.02;
        if (abs(($row['total'] * 100) - $redsysResponse['datos']['total']) < $desviacion || !is_null($redsysResponse['datos']['m_identifier'])) {
            $sentencia             = "LOCALIZADOR encontrado con estos parametros - Id_pedido:" . $redsysResponse['datos']['datos_comercio'] . " - Precio pasado: " . $redsysResponse['datos']['total'] . " Tabla: " . $tabla;
            $result['localizador'] = $result['filas'] > 0 ? $row['loc'] : '';

            if ($row['extra'] == 1) {
                $result['localizador_extra'] = substr($result['localizador'], 0, 6);
                $result['extra']             = true;

                $update_localizador = " UPDATE localizadores
                            SET tiene_extras = 1
                            WHERE localizador = ?";
                $result_localizador = $conexion->prepare($update_localizador);
                $exec_localizador   = $result_localizador->execute(array($result['localizador_extra']));
                $sentencia          = "LOCALIZADOR - " . $result['localizador_extra'] . " tiene extras 1:" . var_export($exec_localizador, true);
                Insertar_Sentencia($sentencia, 'compra');
            }
        } else {
            $sentencia                   = "Incidencia comprobacion precios - Id_pedido:" . $redsysResponse['datos']['datos_comercio'] . " - Precio pasado: " . $redsysResponse['datos']['total'] . " Tabla: " . $tabla . ". Precio bbdd: " . $row['total'] * 100;
            $result['localizador']       = '';
            $result['incidencia']        = true;
            $result['total_localizador'] = abs(($row['total'] * 100));
            $result['total_redsys']      = $redsysResponse['datos']['total'];
        }
        Insertar_Sentencia($sentencia, 'compra');
        return $result;
    } else {
        $sentencia = "LOCALIZADOR no encontrado con estos parametros - Id_pedido:" . $redsysResponse['datos']['datos_comercio'] . " - Precio pasado: " . $redsysResponse['datos']['total'] . " Tabla: " . $tabla;
        Insertar_Sentencia($sentencia, 'compra');

        $result['localizador'] = '';
        return $result;
    }
}

// Recibe un localizador y una conexión de BBDD
// Devuelve si el número de plazas de una reserva borrada asociada a ese localizador es menor o igual a las plazas libres de su horario asociado.
function calcularPlazas($localizador, $conexion)
{
    $sql_calculo = " SELECT  sala_horarios.plazas_libres - reservas_borradas.unidades as total, localizadores_borrados.tipo_pago as tipo_pago
                     FROM sala_horarios
                     JOIN reservas_borradas ON sala_horarios.id=reservas_borradas.sala_horario_id
                     JOIN localizadores_borrados ON localizadores_borrados.localizador=reservas_borradas.localizador
                     WHERE localizadores_borrados.localizador= ?";
    $result_calculo = $conexion->prepare($sql_calculo);
    $result_calculo->execute(array($localizador));
    $row = $result_calculo->fetch(PDO::FETCH_ASSOC);

    //Si es un prepago no comprobamos las plazas
    if ($row['tipo_pago'] == 38) {
        $sentencia        = "LOCALIZADOR - " . $localizador . " - calcularPlazas Ignorada comprobacion prepago ";
        Insertar_Sentencia($sentencia, 'compra');
        return true;
    } else {
        return $row['total'] >= 0;
    }
}

function calcularPlazasNoBorrados($localizador, $conexion)
{
    $sql_calculo = " SELECT  sala_horarios.plazas_libres - reservas.unidades as total, localizadores.tipo_pago as tipo_pago
                     FROM sala_horarios
                     JOIN reservas ON sala_horarios.id=reservas.sala_horario_id
                     JOIN localizadores ON localizadores.localizador=reservas.localizador
                     WHERE localizadores.localizador= ?";
    $result_calculo = $conexion->prepare($sql_calculo);
    $result_calculo->execute(array($localizador));
    $row = $result_calculo->fetch(PDO::FETCH_ASSOC);

    //Si es un prepago no comprobamos las plazas
    if ($row['tipo_pago'] == 38) {
        $sentencia        = "LOCALIZADOR - " . $localizador . " - calcularPlazasNoBorrados Ignorada comprobacion prepago ";
        Insertar_Sentencia($sentencia, 'compra');
        return true;
    } else {
        return $row['total'] >= 0;
    }
}

// Borra de las tablas localizadores_borrados y reservas_borradas (Se dispara trigger de BBDD que los inserta en localizadores y reservas respectivamente)
// Verifica que el localizador es único y actualiza las plazas.
function recuperarBorrados($localizador, $redsysObject, $conexion)
{
    $delete_reservas      = "DELETE FROM reservas_borradas WHERE localizador = ?";
    $result_delres        = $conexion->prepare($delete_reservas);
    $result               = $result_delres->execute(array($localizador));
    $delete_localizadores = "DELETE FROM localizadores_borrados WHERE localizador = ?";
    $result_delloc        = $conexion->prepare($delete_localizadores);
    $result               = $result && $result_delloc->execute(array($localizador));
    $update_plazas        = "   UPDATE reservas rv
                                JOIN sala_horarios sh on rv.sala_horario_id=sh.id
                                JOIN salas sl on sl.id=sh.sala_id
                                JOIN localizadores loc on loc.localizador=rv.localizador
                                JOIN servicios sv on loc.servicio_id=sv.id
                                SET sh.plazas_libres = sh.plazas_libres - (CASE WHEN sv.horario_completo = 1 THEN sl.plazas ELSE rv.unidades END)
                                WHERE rv.localizador=?";
    $result_update      = $conexion->prepare($update_plazas);
    $result             = $result_update->execute(array($localizador));
    $localizadores_alta = verificarLocalizador('localizadores', $redsysObject, $conexion);

    if ($result == true && $localizadores_alta['filas'] == 1) {
        $result = redsys_update($redsysObject, $conexion) && loc_res_update($localizador, $conexion);
    }
    return [$result, $localizadores_alta];
}

// Agrega al log de Redsys el literal facilitado, precedido de la hora actual
function logRedsys($texto)
{
    file_put_contents(dirname(__FILE__) . '/Redsys_ipn_post.txt', "[" . date("Y-m-d H:i:s") . "] " . $texto, FILE_APPEND);
}

// Comprueba si existe en el histórico de pedidos
function comprueba_histórico($id_pedido, $conexion)
{

    $sql_historico    = "SELECT * FROM localizador_pedidos WHERE id_pedido = ?";
    $result_historico = $conexion->prepare($sql_historico);
    $result_historico->execute(array($id_pedido));

    $result['filas'] = $result_historico->rowCount();
    if ($result['filas'] > 0) {
        // El Localizador pagado se encuentra en el histórico de pedidos con lo cual está bien pagado
        $sentencia = "LOCALIZADOR encontrado en el historico con estos parametros - Id_pedido:" . $id_pedido;
        Insertar_Sentencia($sentencia, 'compra');
        $row                   = $result_historico->fetch(PDO::FETCH_ASSOC);
        $result['localizador'] = $row['localizador'];
    } else {
        // El localizador pagado no se encuentra en el histórico de pedidos y no sabemos qué demonios ha sido de él
        $sentencia = "LOCALIZADOR no encontrado en el histórico con estos parametros - Id_pedido:" . $id_pedido;
        Insertar_Sentencia($sentencia, 'compra');
        $result['localizador'] = '';
    }

    return $result;
}

function actualizar_id_pedido($localizador, $id_pedido, $conexion)
{
    $update_localizador = " UPDATE localizadores
                            SET id_pedido = ?
                            WHERE localizador = ?";
    $result_localizador = $conexion->prepare($update_localizador);
    $exec_localizador   = $result_localizador->execute(array("20" . $id_pedido, $localizador));
    $sentencia          = "LOCALIZADOR - " . $localizador . " IDPEDIDO: - 20" . $id_pedido . "- Actualizacion tabla localizadores:" . var_export($exec_localizador, true);
    Insertar_Sentencia($sentencia, 'compra');

    $update_redsys = " UPDATE Redsys
                       SET Ds_Order = ?, Ds_MerchantData = ?
                       WHERE localizador = ?";
    $result_redsys = $conexion->prepare($update_redsys);
    $exec_redsys   = $result_redsys->execute(array($id_pedido, "20" . $id_pedido, $localizador));
    $sentencia     = "LOCALIZADOR - " . $localizador . " IDPEDIDO: - 20" . $id_pedido . " - Actualizacion tabla redsys:" . var_export($exec_redsys, true);
    Insertar_Sentencia($sentencia, 'compra');

    return $exec_localizador && $exec_redsys;
}
