<?php

/**
 *   Includes
 */
require_once dirname(__DIR__) . '/../../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRLIBCOMP . 'registro_logs.php';
require_once DIRLIBCOMP . 'KLogger.php';

/**
 *   Conectamos a la BD
 */
global $conexion;
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*******************************************************************
 * TRADUCCIONES
 *******************************************************************/
require_once DIRLIBCOMP . 'clases/lang.php';
$language = new lang();

$sesion_lang = $language->getUrlLang();
$lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

/**
 * Inicializamos el logger
 */
$logger = new KLogger(DIRLOG . "klogger/log.txt", KLogger::DEBUG);

/****************************************************************
Cargamos datos del entorno multilenguaje
 ****************************************************************/
require_once dirname(__DIR__) . '/../../config_language.php';

$protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

if ($_POST['idioma_navegador'] == 2) {
    $VOLVER    = $domainLink . '/en/visits';    
    $lang  = 'en_GB';
}else if ($_POST['idioma_navegador'] == 3) {
    $lang  = 'fr_FR';
    $VOLVER    = $domainLink . '/fr/visites'; 
} else {
    $lang  = 'es_ES';
    $VOLVER    = $domainLink . '/visitas';
}
define('LANGJS', $lang);

// save language preference for future page requests
$language->setSessionLang($lang);

$_SESSION["lang"] = $lang;

$lang .= '.utf8';
putenv("LANG=" . $lang);
// IMPORTANTE: ESTABLECER SOLO LC_MESSAGES ¡MESSAGES! Que si no se lía con los decimales
setlocale(LC_MESSAGES, $lang);

$directory = dirname(__FILE__) . '/Locale';

if (empty($_POST['compra_fin'])) {

    // Datos del regalado
    $SERVICIOTITULO = !empty($_POST['servicio_nombre']) ? $_POST['servicio_nombre'] : '';
    $SERVICIO       = $_POST['servicio'];
    $FECHA_VISITA   = date("Y-m-d");
    $LOCALIZADOR    = !empty($_POST['localizador']) ? $_POST['localizador'] : '';
    $ID_PEDIDO      = !empty($_POST['id_pedido']) ? $_POST['id_pedido'] : '';
    $NOMBRE         = $_POST['nombre'];
    $APELLIDOS      = $_POST['apellidos'];
    $EMAIL          = $_POST['email'];
    $TELEFONO       = $_POST['telefono'];
    $PAGONOMBRE     = $_POST['pago'];

    $NOMBREREGALADO    = $_POST['nombre_regalado'];
    $APELLIDOSREGALADO = $_POST['apellidos_regalado'];
    $EMAILREGALADO     = $_POST['email_regalado'];
    $TELEFONOREGALADO  = $_POST['telefono_regalado'];
    
    //Campos necesarios pago instalacion regalar
    $actividadSeleccionada  =  !empty($_POST['actividadSeleccionada']) ? $_POST['actividadSeleccionada'] : '';
    $instalacion            =  !empty($_POST['instalacion']) ? $_POST['instalacion'] : '';
    $servicio               =  !empty($_POST['servicio']) ? $_POST['servicio'] : '';
    $fecha                  =  !empty($_POST['fecha']) ? $_POST['fecha'] : '';
    $hora                   =  !empty($_POST['hora']) ? $_POST['hora'] : '';
    $plazas                 =  !empty($_POST['plazas']) ? $_POST['plazas'] : '';
    $nombre                 =  !empty($_POST['nombre']) ? $_POST['nombre'] : '';
    $apellidos              =  !empty($_POST['apellidos']) ? $_POST['apellidos'] : '';
    $telefono               =  !empty($_POST['telefono']) ? $_POST['telefono'] : '';
    $email                  =  !empty($_POST['email']) ? $_POST['email'] : '';
    $idioma                 =  !empty($_POST['idioma']) ? $_POST['idioma'] : '';
    $localizador            =  $LOCALIZADOR;
    $lista                  =  !empty($_POST['lista']) ? $_POST['lista'] : '';
    
    // PHP con los textos estáticos de la plantilla
    require_once DIRLANGUAGESTRINGS . 'compra/api/compra_api.php';
    require_once DIRLANGUAGESTRINGS . 'compra/api/confirmar_compra_api.php';

    // Cargamos el archivo de plantilla propio
    require_once DIRLANGUAGETEMPLATES . "compra/api/confirmar_regalo_api.ctp";

}
