<?php
// Iniciamos session
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/../error_log_confirmar.txt');
error_reporting(E_ALL);

/**
 *   Includes
 */
require_once dirname(__DIR__) . '/../../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIBCOMP . 'funciones.php';

/**
 *   Conectamos a la BD
 */
global $conexion;
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*******************************************************************
 * TRADUCCIONES
 *******************************************************************/
require_once DIRLIBCOMP . 'clases/lang.php';
$language = new lang();

/****************************************************************
Cargamos datos del entorno multilenguaje
 ****************************************************************/
require_once dirname(__DIR__) . '/../../config_language.php';

if (isset($_REQUEST['hash'])) {

    $hash_decryp = desencriptar($_REQUEST['hash']);

    list($param_loc, $requestpay) = explode("&", $hash_decryp);
    if (isset($param_loc)) {
        list($key_loc, $value_loc) = explode("=", $param_loc);
    }

    if (isset($requestpay)) {
        list($key_requestpay, $value_requestpay) = explode("=", $requestpay);
    }

    if ($value_requestpay == 1) {

        $localizador = $value_loc;

        $sql = "SELECT r.id, r.sala_horario_id, r.unidades,l.estado FROM reservas r JOIN localizadores l on r.localizador=l.localizador
                WHERE r.localizador = '" . $localizador . "'";

        $result = $conexion->query($sql);

        if ($result != null && $result->rowCount() > 0) {
            $reserva = $result->fetch();
        }

        if ($reserva['estado'] == 'pendiente_pago') {

            $plazasADevolver = $reserva['unidades'];

            // Modifico horario devolviendo plazas
            $sql_update = "UPDATE sala_horarios
                           SET plazas_libres = plazas_libres + $plazasADevolver
                           WHERE id = " . $reserva['sala_horario_id'];

            $conexion->query($sql_update);

            // Eliminar reservas
            $sql_delete_reserva     = "DELETE FROM reservas WHERE id =" . $reserva['id'] . " and estado='finalizada'";
            $sql_delete_localizador = "DELETE FROM localizadores WHERE localizador ='" . $localizador . "' AND estado not in ('pasarela', 'pagado', 'error')";
            $conexion->query($sql_delete_reserva);
            $conexion->query($sql_delete_localizador);

            // PHP con los textos estáticos de la plantilla
            require_once DIRLANGUAGESTRINGS . 'anular/pago_cancelado_api.php';

            $sesion_lang = $language->getSessionLang();
            $lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

            $translated_form_action_contacta = $language->getFormActionTranslation('reserva_web/formulario_visitas.tpl_contacto', true);
            $form_action_contacta            = isset($translated_form_action_contacta) ? $translated_form_action_contacta : 'contacto-enoturismo';
            $ENLACECONTACTA                  = URL_FRONT_PRINCIPAL . '/' . $form_action_contacta;

            $translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver', true);
            $form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : '/visitas';
            $IR_A_ENOTURISMO               = $domainLink . '/' . $form_action_volver;

            require_once DIRLANGUAGETEMPLATES . "anular/api/pago_cancelado.ctp";

        } else {

            $RAIZ        = DOMINIO;
            $sesion_lang = $language->getSessionLang();
            $lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

            // PHP con los textos estáticos de la plantilla
            require_once DIRLANGUAGESTRINGS . 'compra/api/confirmar_compra_api.php';

            $ESTADOCOMPRA           = 'ESTA RESERVA NO PUEDE CANCELARSE.';
            $tInfoTarifasCarrito    = 0;
            $tDatosReserva          = 0;
            $tOpcionesSeleccionadas = 0;
            $tTusDatos              = 0;
            $tCamposExtra           = 0;
            $tCorreo                = 0;

            $NOMBRESERVICIORESERVA = "";
            $TEXTPASO3             = "";
            $IMAGENTITULOSERVICIO  = ENALCEIMAGENSERVICIOS . 'foto_visita.jpg';

            $translated_form_action_contacta = $language->getFormActionTranslation('reserva_web/formulario_visitas.tpl_contacto', true);
            $form_action_contacta            = isset($translated_form_action_contacta) ? $translated_form_action_contacta : 'contacto-enoturismo';
            $ENLACECONTACTA                  = URL_FRONT_PRINCIPAL . '/' . $form_action_contacta;

            $translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver', true);
            $form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : '/visitas';
            $IR_A_ENOTURISMO               = $domainLink . '/' . $form_action_volver;

            require_once DIRLANGUAGETEMPLATES . "compra/api/estado_compra.ctp";
        }

    }

} else {

    // PHP con los textos estáticos de la plantilla
    require_once DIRLANGUAGESTRINGS . 'compra_finalizada/nok.php';

    // Compruebo si es móvil para cargar los css
    if (is_mobile()) {
        $RUTACSS = 'movil/compras_reservas.css';
    } else {
        $RUTACSS = 'compras_reservas.css';
    }

    $RAIZ        = DOMINIO;
    $sesion_lang = $language->getSessionLang();
    $lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

    $protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
    $domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

    $translated_form_action_contacta = $language->getFormActionTranslation('reserva_web/formulario_visitas.tpl_contacto', true);
    $form_action_contacta            = isset($translated_form_action_contacta) ? $translated_form_action_contacta : 'contacto-enoturismo';
    $ENLACECONTACTA                  = URL_FRONT_PRINCIPAL . '/' . $form_action_contacta;

    $translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver', true);
    $form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : 'visitas';
    $IR_A_ENOTURISMO               = $domainLink . '/' . $form_action_volver;

    require_once DIRLANGUAGETEMPLATES . "compra_finalizada/nok.ctp";
}

$RAIZ = DOMINIO;
unset($_SESSION['numero_operacion']);
