<?php
// Iniciamos session
/*ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/error_log_confirmar.txt');
error_reporting(E_ALL);*/

/**
 *   Includes
 */
require_once dirname(__DIR__) . '/../../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRLIBCOMP . 'registro_logs.php';
require_once DIRLIBCOMP . 'KLogger.php';
require_once DIRLIBCLASS . 'messages.php';
$message = new messages();
/**
 *   Conectamos a la BD
 */
global $conexion;
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*******************************************************************
 * TRADUCCIONES
 *******************************************************************/
$sesion_lang = $language->getUrlLang();
$lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');
define('LANGJS', $lang);

/**
 * Inicializamos el logger
 */
$logger = new KLogger(DIRLOG . "klogger/log.txt", KLogger::DEBUG);

/****************************************************************
Cargamos datos del entorno multilenguaje
 ****************************************************************/
require_once dirname(__DIR__) . '/../../config_language.php';


// PHP con los textos estáticos de la plantilla
require_once DIRLANGUAGESTRINGS . 'compra/api/pago_instalacion_fin_api.php';

// Asignamos la raiz del sitio
$RAIZ             = DOMINIO;
$DOMINIOPRINCIPAL = DOM;
$DOMINIOTOTAL     = DOMINIOPRINCIPAL;

$sesion_lang  = $language->getSessionLang();
$lang         = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

$hay_extras_horario     = 0;
$hay_extras_localizador = 0;

$idioma_visita_id = 1;

$localizador =  $_POST['localizador'];

// IDIOMA DE LA VISITA
$sql_idioma_visita = "SELECT i.idioma,i.iso_code, r.sala_horario_id, i.id
					  FROM reservas r 
                      JOIN idiomas i ON r.idioma_id = i.id                  
					  AND r.localizador = '" . $localizador . "'";

$result_idioma_visita = $conexion->query($sql_idioma_visita);

if ($result_idioma_visita->rowCount() > 0) {
    $row_idioma_visita = $result_idioma_visita->fetch();
  
    $_SESSION["lang"]   = $row_idioma_visita['iso_code'];
    $language->setSessionLang($row_idioma_visita['iso_code']);
    $idioma_visita = $language->getString($row_idioma_visita['idioma'], true);    
    $hora          = $row_idioma_visita['sala_horario_id'];
    $fecha         = $hora;
    $idioma_visita_id  = $row_idioma_visita['id'];
}

$translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver');
$form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : 'reserva-de-visitas-bodegas';

$VOLVER = $form_action_volver;

$translated_form_action_imprimir = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_imprimir');
$form_action_imprimir = isset($translated_form_action_imprimir) ? $translated_form_action_imprimir : 'imprimir_compra';

$ACTIONIMPRIMIR = $form_action_imprimir;

$RUTACSS = 'compras_reservas.css';

// Datos
$sql_info = "SELECT *
			 FROM localizadores
			 WHERE localizador = '" . $localizador . "'";

$result_info = $conexion->query($sql_info);

if ($result_info->rowCount() > 0) {
    $row_info = $result_info->fetch();

    $LOCALIZADOR = $row_info['localizador'];
    $NOMBRE      = $row_info['nombre'];
    $APELLIDOS   = $row_info['apellido'];
    $TELEFONO    = $row_info['telefono'];
    $pago_seleccionado = $row_info['tipo_pago'];

    if ($row_info['email'] != '') {
        $tCorreo = 1;
        $EMAIL = $row_info['email'];
    } else {
        $tCorreo = 0;
    }
    // PHP con los textos estáticos de la plantilla
    require_once DIRLANGUAGESTRINGS . 'compra_finalizada/ok.php';
    require_once DIRLANGUAGESTRINGS . 'modificar/modificar_api.php';
    require_once DIRLANGUAGESTRINGS . 'compra/api/confirmar_compra_api.php';

    // Compruebo si es móvil para cargar los css
    if (is_mobile()) {
        $RUTACSS = 'movil/compras_reservas.css';
    } else {
        $RUTACSS = 'compras_reservas.css';
    }

    if ($row_info['regalo']) {
        $tBloqueRegalo   = 1;
        $tBotonImprimir  = 0;
        $tBloqueNoRegalo = 0;
        $tPassbook       = 0;
    } else {
        $tBloqueRegalo   = 0;
        $tBotonImprimir  = 1;
        $tBloqueNoRegalo = 1;
        $tPassbook       = 1;
    }

   
    $TEXTSTRGOOGLEMAPS = $language->getString('Ver ubicación en google maps');


    $servicio_id = $row_info['servicio_id'];
    $SERVICIOID = $servicio_id;

    $total = sprintf('%0.2f', $row_info['total']);
    if($total != 0){
        $TOTALPRECIOCARRITO = $total . ' €';
    }else{
        $TOTALPRECIOCARRITO = '-';//$language->getString('Gratuito', true);
    }


    $unidades        = $row_info['unidades'];
    $plazas          = $row_info['unidades'];
    $plazas_adulto   = $row_info['plazas_adulto'];
    $plazas_infantil = $row_info['plazas_infantil'];

}

$ACTIVIDADID    = $actividad;
$INSTALACIONID  = $instalacion;
$FECHAID        = $fecha;
$HORAID         = $hora;


if ($row_info['bono'] != '') {
    $existe_bono = true;

    $sql_bono    = "select * from bonos where codigo = '" . $row_info['bono'] . "'";
    $result_bono = $conexion->query($sql_bono);

    if ($result_bono != null && $result_bono->rowCount() > 0) {
        $row_bono = $result_bono->fetch();
        $nombre_bono = $row_bono['codigo'];
        
    }

} else {
    $existe_bono = false;
}
                
if (isset($existe_bono) && $existe_bono) {
    if ($row_bono['porcentual']) {
        if ($row_bono['cantidad'] == 100){
            $total_sin_descuento = $total ;
        }else{
            $total_sin_descuento = $total / (1 - $row_bono['cantidad'] / 100);
        }
        $descuento_bono      = '- ' . $row_bono['cantidad'] . " %";
    } else {
        $descuento_bono = '- ' . $row_bono['cantidad'] . " €";
    }
    $tDescuentoCosteRealizado = 1;
    $DESCUENTOCOSTE          = $nombre_bono;
    $DESCUENTOCOSTEREALIZADO = $descuento_bono;
}

// Traducciones
$product_lang = $language->getStringsProduct($servicio_id);

// Servicio comprado
$sql_compra = "SELECT s.nombre as nombreS, s.pistas, s.tipo_pago, i.nombre as nombreI, i.descripcion as instalacion_descripcion, i.google_maps as instalacion_mapa, i.enlace_prepago, a.nombre as nombreA,a.id as idA, s.instalacion_id, s.miniatura
			   FROM servicios s JOIN instalaciones i ON s.instalacion_id = i.id
			   JOIN actividades a ON s.actividad_id = a.id
			   AND s.id = " . $servicio_id;

$result_compra = $conexion->query($sql_compra);

if ($result_compra->rowCount() > 0) {
    $row_compra = $result_compra->fetch();

    $NOMBRESERVICIOCOMPRA   = $product_lang['nombre'];
    $NOMBRESERVICIORESERVA  = $product_lang['nombre'];
    $NOMBREINSTALACION      = $row_compra['nombreI'];
    $IMAGENTITULOSERVICIO   = ENALCEIMAGENSERVICIOS . $row_compra['miniatura'];
    $TEXTGOOGLEMAPS         = $row_compra['instalacion_mapa'];

    $PLAZAS = $row_info['unidades'];

    // Servicio comprado
    //$servicio_id          = $servicio;
    $servicio             = $product_lang['nombre'];
    $condiciones_servicio = $product_lang['condiciones_servicio'];
    $condiciones_extra    = $product_lang['condiciones_extra'];
    $instalacion_id       = $row_compra['instalacion_id'];
}

// Archivos para el email
$archivos = $language->getArchivesProduct($servicio_id);

// Tarifas seleccionadas, si no es pago gratuito
// Tipo de pago seleccionado
$sql_pago = "SELECT *
			 FROM tipos_pagos
			 WHERE id = " . $pago_seleccionado;         

$result_pago = $conexion->query($sql_pago);

if ($result_pago->rowCount() > 0) {
    $row_pago = $result_pago->fetch();

    $pago_seleccionado = $language->getString($row_pago['pago'], true);
    $PAGOSELECCIONADO = $pago_seleccionado;
}

// Tarifas carrito
$tInfoTarifasCarrito = 1;

$sql_loc_taf = "SELECT lt.*, ug.nombre, t.precio, t.pago_grupo, t.usuarios_grupo_id
				FROM localizador_tarifas lt JOIN tarifas t ON lt.tarifa_id = t.id
				JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
				AND lt.localizador = '" . $row_info['localizador'] . "'";          

$result_loc_taf = $conexion->query($sql_loc_taf);

$k = 0;
while ($row_loc_taf = $result_loc_taf->fetch()) {

    $nombre_tarifa = $language->getString($row_loc_taf['nombre'], true);
    $tarifas       = $language->getString($row_loc_taf['nombre'], true);

    // Compruebo precio de la tarifa, por si luego hay descuento
    if ($row_loc_taf['pago_grupo'] == 0) {
        $total_tarifa = $row_loc_taf['precio'] * $lista[$k];
    } else {
        $total_tarifa = $row_loc_taf['precio'];
    }

    $NOMBRETARIFACARRITO = $language->getString($nombre_tarifa, true);
    $NUMEROADULTOS       = $lista[$k];
    
    if($total_tarifa != 0){
        $PRECIOTARIFACARRITO = sprintf('%0.2f', $total_tarifa) . ' €';
    }else{
        $PRECIOTARIFACARRITO = '-';//$language->getString('Gratuito', true);
    }
    $tTarifasLista = 1;
    
    $k++;
}
//No comprobamos que el localizdor este pagado
$sql_loc_extras = "SELECT sum(le.unidades) as unidades, sum(le.total) as total,
            e.id, e.nombre, e.condiciones_extra, u.nombre as nombre_tarifa, et.tipo_clave,
            el.nombre as nombre_extra , el.condiciones_extra as condiciones_extra_tra
            FROM localizador_extras_servicio le 
            JOIN extras_servicios e ON le.extra_id = e.id
            INNER JOIN localizadores l ON le.localizador_extra = l.localizador
            LEFT JOIN tarifas_extras t ON le.tarifa_id = t.id 
            LEFT JOIN usuarios_grupos u ON t.usuarios_grupo_id = u.id
            INNER JOIN extras_servicios_tipos et ON et.id = e.tipo_id
            LEFT JOIN extras_servicios_lang el ON el.extra_id = e.id AND el.idioma = ?
            WHERE le.localizador_extra = ?
            AND le.unidades > 0        
            GROUP BY le.tarifa_id, e.id, e.nombre, u.nombre, et.tipo_clave
            ORDER BY e.orden, le.tarifa_id
";

$result_loc_extras = $conexion->prepare($sql_loc_extras);
$result_loc_extras->execute(array( $idioma_visita_id , $row_info['localizador']));


$extras_seleccionados = array();
$extras_condiciones   = [];
while ($row_loc_extra = $result_loc_extras->fetch()) {
    
    $nombre_extra = $language->getString($row_loc_extra['nombre'], true);

    if($idioma_visita_id != 1 && isset($row_loc_extra['nombre_extra'])){
        $nombre_extra = $row_loc_extra['nombre_extra'];
    }
    if($idioma_visita_id != 1 && isset($row_loc_extra['condiciones_extra_tra'])){
        $condiciones_extra_item = $row_loc_extra['condiciones_extra_tra'];
    }else{
        $condiciones_extra_item = $row_loc_extra['condiciones_extra'];
    }
    $extras_condiciones[$row_loc_extra['id']] =  $condiciones_extra_item;

    $nombre_tarifa = $language->getString($row_loc_extra['nombre_tarifa'], true);

    if ($nombre_tarifa){
        $nombre_extra = $nombre_extra;
    }else{
        $nombre_extra = $nombre_extra . " | " . $nombre_tarifa ;
    }
        
    if($row_loc_extra['total'] == 0){
        $precio_extra_mostrar = $language->getString('Gratuito', true);
    }else{
        $precio_extra_mostrar = sprintf('%0.2f', $row_loc_extra['total']) . ' €';
    }
    $PRECIOEXTRA = $precio_extra_mostrar;
    $tExtras = 1;
    $hay_extras_localizador = 1;
    
    $extras_seleccionados[] = array(
        'abreviatura'   => '',
        'imagen'        => '',
        'nombre'        => $nombre_extra,
        'nombre_tarifa' => $language->getString($nombre_tarifa, true),
        'cantidad'      => $row_loc_extra['unidades'],
        'precio'        => number_format($row_loc_extra['total'],2) .' €',

    );
}

foreach ($extras_condiciones  as $key => $value) {
    $condiciones_extra = $condiciones_extra . ' ' . $value;
}

// DESCUENTOS O COSTES
$servicio       = $servicio_id;
$forma_pago     = $row_info['tipo_pago'];
$paso           = "mostrar";
// require_once DIRMODULOSCOMP . 'compra/descuentos_costes.php';
$servicio = $product_lang['nombre'];

// Compruebo si hay reserva
if ($hora != 0) {
    
    $tDatosReserva = 1;
      
    $sql_pistas = "SELECT ss.sala_horario_id, s.nombre as nombreS, i.nombre as nombreI,i.id as instalacionId, r.deporte_id, s.sala_id
                    FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
                    JOIN servicios s ON ss.servicio_id = s.id
                    JOIN instalaciones i ON s.instalacion_id = i.id				
                    AND r.localizador like '" . $row_info['localizador'] . "'
                    AND s.pistas = 0
                    AND s.id = " . $servicio_id;
   
  
                  
    $result_pistas = $conexion->query($sql_pistas);

    if ($result_pistas->rowCount() > 0) {
        $row_pista = $result_pistas->fetch();

        $textos_servicio = $language->getStringsProduct($servicio_id);

        $NOMBRESERVICIORESERVA = $textos_servicio['nombre'];

        // Servicio Reservado
   
        $servicio_reserva = $product_lang['nombre'];

        // Servicio Comprado
        $NOMBRESERVICIOCOMPRA = $product_lang['nombre'];
        $servicio = $product_lang['nombre'];

        $NOMBREINSTALACION = $row_pista['nombreI'];
        $INSTALACIONID     = $row_pista['instalacionId'];

        // Horario reservado
        $sql_horario = "SELECT fecha, hora_inicio, hora_fin
						FROM sala_horarios
						WHERE id = " . $row_pista['sala_horario_id'];

        $result_horario = $conexion->query($sql_horario);

        if ($result_horario->rowCount() > 0) {
            $row_fecha_hora = $result_horario->fetch(PDO::FETCH_ASSOC);

            $FECHARESERVA =  cambiaf_a_normal($row_fecha_hora['fecha']);

            $fecha_reserva = cambiaf_a_normal($row_fecha_hora['fecha']);

            $hora_inicio = strtotime($row_fecha_hora['hora_inicio']);
            $hora_inicio = date("H:i", $hora_inicio);
            $hora_fin    = strtotime($row_fecha_hora['hora_fin']);
            $hora_fin    = date("H:i", $hora_fin);
            $HORARESERVA = $hora_inicio;
       
            // Busco reserva realizada para obtener plazas y fecha de reserva
            // Reserva para servicios comprados que no son horas valle 
            $sql_reserva = "SELECT count(es.sala_horario_id) as cant_extras_horarios
            FROM extras_servicios_sala_horarios as es                
            INNER JOIN extras_servicios as e on es.extra_id = e.id and e.activo = 1 and e.publicado =1
            WHERE es.sala_horario_id = " . $row_pista['sala_horario_id'];

            $result_reserva = $conexion->query($sql_reserva);

            if ($result_reserva->rowCount() > 0) {
                $row_reserva = $result_reserva->fetch(PDO::FETCH_ASSOC);
                if ( $row_reserva['cant_extras_horarios'] > 0){
                    $hay_extras_horario = 1;

            
                    $hash_encryp = encriptar("l=" . $localizador . "&requestpay=1&fecha=". $fecha_reserva );          
                
                }
            
            }

        }
    }
}

// CAMPOS EXTRA
$sql_campos_extra = "SELECT c.*, lc.value
					 FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
					 AND c.type NOT LIKE 'checkbox'					 
					 AND lc.localizador = '" . $localizador . "'
                     AND c.id not in (100, 101, 102, 103)
					 UNION (
						SELECT c.*, lc.value
						FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
						AND (c.type like 'checkbox' AND c.nombre like '%comida%')
						AND lc.localizador = '" . $localizador . "'
						)";

////AND c.nombre NOT LIKE 'Observaciones'
                        
$result_campos_extra = $conexion->query($sql_campos_extra);


if ($result_campos_extra->rowCount() > 0) {

    $campos_extra = array();
    $newletter    = false;
    foreach ($result_campos_extra->fetchAll() as $row_campo) {
        $NOMBRECAMPOEXTRA = $language->getString($row_campo['nombre'], true);

        $valor = $row_campo['value'];

        if ($valor == 'on') {
            if (strpos($row['nombre'], 'newsletter') !== false) {
                $newsletter = true;
            }
            $valor = $language->getString('Sí');
        }
        $VALORCAMPOEXTRA = $valor;

        $campos_extra[] = '<span style="font-weight: 400; text-transform: uppercase;">' . $language->getString($row_campo['nombre'], true) .'</span><br />
                        <span style="font-size: 14px;color: #353535;font-weight: 400;letter-spacing: 0.03em;">' . $valor . '</span>';

        if ($row_campo['nombre'] == 'Hora') {
            $custom_hour_extra_field = $valor;
        }
     
        $tCamposExtra = 1;
    }
} else {
    $tCamposExtra = 0;
    
    $campos_extra = '';
}

// TEXTOS SECCIÓN (GENERALES Y DE SERVICIO)
$section_message = 'comprar_paso_3';
$servicio_texto  = $servicio_id;
//require_once DIRMODULOSCOMP . 'otros/show_messages.php';

// TEXTOS PARA EL EMAIL
$section_message = 'email_compra';
require_once DIRMODULOSCOMP . 'otros/messages_email_pdf.php';

// ENVÍO DE CORREO
$esTipoCompra              = true;
$esMasajes                 = false;
$horario_balneario         = '';
$fecha_compra              = date('d-m-Y');
$fecha_realizada_reserva   = date('d-m-Y');
$id_pedido                 = 0;
$actividad                 = $row_compra['nombreA'];
$ACTIVIDADID               = $row_compra['idA'];
$instalacion               = $row_compra['nombreI'];
$instalacion_desc          = $row_compra['instalacion_descripcion'];
$instalacion_mapa          = $row_compra['instalacion_mapa'];
$instalacion_enlace        = $row_compra['enlace_prepago'];
$pago_instalacion          = 1;
$pistas                    = $row_compra['pistas'];
$pago_parcial              = '';
$descuento_coste_realizado = '';
$tipo_aplicado             = '';

// Cambio estados localizador
// Actualizo localizador
$sql_update_localizadores    = "UPDATE localizadores SET estado = ?, web = ?, pago_instalacion = ? WHERE localizador = ?";
$result_update_localizadores = $conexion->prepare($sql_update_localizadores);
$exito_loc                   = $result_update_localizadores->execute(array('pagado', 0, 1, $localizador));

//Si hay extras actualizamos los extras
if ( $hay_extras_localizador == 1){
    // Actualizo localizador
    $sql_update_localizadores    = "UPDATE localizador_extras_servicio SET estado = ? WHERE localizador_extra = ?";
    $result_update_localizadores = $conexion->prepare($sql_update_localizadores);
    $exito_loc                   = $result_update_localizadores->execute(array('pagado', $localizador));

    /*** REGISTRO LOGS  ****/
    $sentencia = "LOCALIZADOR - " . $localizador . "Compra finalizada con extras: pago en instalación";
    Insertar_Sentencia($sentencia, 'compra');
}

/*** REGISTRO LOGS  ****/
$sentencia = "LOCALIZADOR - " . $localizador . "Compra finalizada: pago en instalación";
Insertar_Sentencia($sentencia, 'compra');

if ($hora != 0) {
    // Cambio estado reserva
    // Actualizo reserva con los datos personales y estado "confirmacion"
    $sql_update_reservas    = "UPDATE reservas SET estado = ? WHERE localizador = ? AND sala_horario_id = ?";
    $result_update_reservas = $conexion->prepare($sql_update_reservas);
    $exito_r                = $result_update_reservas->execute(array('finalizada', $localizador, $row_pista['sala_horario_id']));

    /*** REGISTRO LOGS  ****/
    $sentencia = "LOCALIZADOR - " . $localizador . " La reserva para el localizador ha cambiado de estado: (estado => finalizada, localizador => " . $localizador . ", 'horario' => " . $row_pista['sala_horario_id'] . ")";
    Insertar_Sentencia($sentencia, 'compra');
}else{
    /*** REGISTRO LOGS  ****/
    $sentencia = "LOCALIZADOR - " . $localizador . " La reserva para el localizador es un regalo " . $localizador . " Pago instalacion)";
    Insertar_Sentencia($sentencia, 'compra');
}

$hash_misextras    = encriptar("l=" . $localizador . "&requestpay=1&fecha=". $FECHARESERVA );          

if(  $idioma_visita_id  == 1){
    $url_misextras_raiz =  '/tusvisitas/?misextras';
}else if( $idioma_visita_id == 2 ){
    $url_misextras_raiz =  '/en/yourvisits/?misextras';
}elseif( $idioma_visita_id == 3){
    $url_misextras_raiz =  '/fr/tusvisitas/?misextras';
}else{
    $url_misextras_raiz =  '/tusvisitas/?misextras';
}


// require_once DIRMODULOSCOMP . 'compra/inscribirlista_mailchimp.php';
require_once DIRMODULOSCOMP . 'compra/recibircorreo_compra.php';

require_once DIRLANGUAGETEMPLATES . "compra/api/pago_instalacion_fin.ctp";