<?php
/**
 * Registra un HIT de transacción para Google Analytics.
 *
 * Webs en las que se ha implementado:
 *      the-art-company.com -> Módulo "lifeconcept_ga"
 *
 * @company     JIG
 * @author      Fernando Bartolomé López
 * @version     2019年05月23日
 */
function gaHitTransaction($pago_seleccionado, $localizador, $total_tarifa, $actividad, $servicio, $idioma_visita, $id_servicio, $extras_seleccionados)
{
    $paymenthMethodName = $pago_seleccionado; // Nombre de método de pago para el log.
    $tid                = ''; // (string) ID del google analytics. Por ejemplo: UA-831314-22

    // Obtenemos el cs y el cm de la tabla localziador_origen
    if (sizeof($_COOKIE) == 0) {
        require_once dirname(__DIR__) . '/../config.php';
        global $conexion;
        $conexion      = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);
        $sql_origen    = "SELECT * FROM localizador_origen where localizador = '" . $localizador . "'"; 
        $result_origen = $conexion->query($sql_origen);

        if($result_origen->rowCount() > 0){
            $row_origen = $result_origen->fetch(PDO::FETCH_ASSOC);
            $_COOKIE    = unserialize($row_origen['cookie']);
            
        }
    }
    
    $uniqid = uniqid();
    file_put_contents(__DIR__ . '/logs/' . date('YmdHis') . '_' . $uniqid . '_init.log', var_export(array(
        '$_SERVER'       => $_SERVER,
        'payment_method' => $paymenthMethodName,
    ), true));

    $iva = 0.21; // Tipo float. Porcentaje que corresponde a los impuestos. Si es el 21%; será 0.21.

    $cartVoucher = null; // (string) cupon usado en el carrito. Separado por comas, sin espacios.

    $cid = null;
    // En este punto concreto, averiguamos el CID del cliente si lo tenemos guardado en algún sitio. Si no, más abajo lo cogerá de las cookies o generará uno.
    file_put_contents(__DIR__ . '/logs/' . date('YmdHis') . '_' . $uniqid . '_cid.log', var_export(array(
        '$cid' => $cid,
    ), true));
    if (!$cid) {
        $cid = isset($_COOKIE['ga_cid']) ? $_COOKIE['ga_cid'] : null;
        if (!$cid) {
            $cookieGa = isset($_COOKIE['_ga']) ? $_COOKIE['_ga'] : null;
            if ($cookieGa) {
                $cookieGa = explode('.', $cookieGa);
                $cid      = $cookieGa[2] . '.' . $cookieGa[3];
            }
        }
    }
    if (!$cid || $cid == '') {
        $cid = rand() . '.' . (explode(' ', microtime())[1]);
    }

    $total_paid     = $total_tarifa; // Total pagado, impuesto incluidos
    $total_shipping = 0; // Total de envío.

    $urlOrderConfirmation = '/enoexperiencia/?compra_finalizada'; // RELLENAR con la URL de confirmacion

    $url      = 'https://www.google-analytics.com/collect';
    
    $postVars = array(
        'payload_data' => true,

        'v'            => 1, // versión del protocolo, no modificar, siempre 1
        'tid'          => $tid, // tracking id, de momento añadiremos el de pruebas y más tarde el de producción
        'cid'          => $cid, // client id, veremos de donde lo tenemos que extraer
        't'            => 'pageview', // tipo de hit

        'dh'           => $_SERVER['HTTP_HOST'], // host name, en este caso the-art-company.com
        'dp'           => $urlOrderConfirmation, // página donde se produce la transacción, vamos a rellenarlo con /es/confirmación-pedido
        'dt'           => 'enoexperiencia - compra finalizada', // (string) host name, por ejemplo 'PM Confirmación de pedido'

        'ti'           => $localizador, // ID de la transacción. ID del pedido.
        'ta'           => null, // id de afiliación, si no existe vacío
        'tr'           => $total_paid, // valor total de la transacción
        'tt'           => $total_paid * $iva, // valor tasas (IVA)
        'ts'           => $total_shipping, // valor de los costes de envío
        'tcc'          => $cartVoucher, // cupón, en el caso de que se aplique
        
        'pa'           => 'purchase', //  acción del producto, en este caso siempre el valor purchase
    );

    $products = array(array(
        'id'              => $id_servicio ,
        'nombre'          => $servicio ,
        'categoria'       => $actividad ,
        'marca'           => 'jig',
        'variante'        => $idioma_visita,
        'precio_unitario' => $total_paid,
        'cantidad'        => 1)); // (array) Producto o productos comprados

     foreach($extras_seleccionados as $extra){
        $products[] = array(
            'id'              => $id_servicio ,
            'nombre'          => $extra['nombre'] ,
            'categoria'       => $actividad ,
            'marca'           => '',
            'variante'        => $idioma_visita,
            'precio_unitario' => $extra['precio'],
            'cantidad'        => $extra['cantidad']
        );    
        
    }
    
    $i = 1; // índice. Indica la posición del producto en el array. Empieza por 1.
    foreach ($products as $product) {
        $postVars['pr' . $i . 'id'] = $product['id'] ; // identificador del producto. Un ID, un EAN, el campo más habitual para identificar un producto internamente.
        $postVars['pr' . $i . 'nm'] = $product['nombre'] ; // nombre del producto
        $postVars['pr' . $i . 'ca'] = $product['categoria'] ; // categoría a la que pertenece el producto
        $postVars['pr' . $i . 'br'] = $product['marca'] ; // marca del producto.
        $postVars['pr' . $i . 'va'] = $product['variante']; // variante del producto, por ejemplo el color del producto seleccionado
        $postVars['pr' . $i . 'ps'] = $i; // [NO TOCAR] posición del producto, es el valor de X.
        $postVars['pr' . $i . 'pr'] = $product['precio_unitario']; // precio unitario del producto
        $postVars['pr' . $i . 'qt'] = $product['cantidad']; // cantidad de un producto

        $i++;
    }

    // Limpiar y quitar los valores nulos
    foreach ($postVars as $key => $value) {
        if ($value === null) {
            unset($postVars[$key]);
        }
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postVars));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result   = curl_exec($ch); // ENVIAR ó NO ENVIAR
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    file_put_contents(__DIR__ . '/logs/' . date('YmdHis') . '_' . $uniqid . '_final.log', var_export(array(
        '$_SERVER' => $_SERVER,
        '$_COOKIE' => $_COOKIE,
        'url'      => $url,
        'postVars' => $postVars,
        'final_url' => $url . '?' . http_build_query($postVars),
        'result'   => $result,
        'httpcode' => $httpcode,
    ), true));

    return true;
}
