<?php
session_start();

/**
 * Error Reporting
 */
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/procesar_cecatpv_error_log.txt');
error_reporting(E_ALL);

/**
 *  Includes
 */
require_once '/server/www/html/' . $_SERVER['HTTP_HOST'] . '/httpdocs/wp-content/plugins/visitas/modules/visitas/reservas/config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRLIBCOMP . 'registro_logs.php';
require_once 'devolver_stock.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*******************************************************************
 * TRADUCCIONES
 *******************************************************************/
require_once DIRLIBCOMP . 'clases/lang.php';
$language = new lang();

/*****************************************************************
 * Mensajes del sistema
 *****************************************************************/
require_once DIRLIBCOMP . 'clases/messages.php';
$message = new messages();

// Inicio transacción
$conexion->beginTransaction();

file_put_contents(dirname(__FILE__) . '/procesar_cecatpv_post.txt', var_export($_REQUEST, true), FILE_APPEND);

/**
 * CECA TPV - Comunicacion ON-LINE
 */
// Comprobamos si ha pasado el timepo limite
$sql_localizador = "SELECT localizador.timestamp, localizador.total
                    FROM localizadores localizador JOIN CecaTpv tpv ON localizador.localizador = tpv.localizador
                    AND tpv.Num_operacion = :num_operacion  ";

$query_localizador = $conexion->prepare($sql_localizador);
$query_localizador->execute(array(':num_operacion' => $_POST['Num_operacion']));

/**
 * Si es diferente a 1, es que hay dos localizadores con mismo numero de operacion,
 * cosa que no es posible ya que el numero de operacion debe de ser unico.
 */
if ($query_localizador->rowCount() == 1) {
    $row_localizador = $query_localizador->fetch();
    procesar_localizadores($conexion, $query_localizador, $language, $message,$row_localizador['total']);
}else{
    // Puede que se haya ido a localizadores borrados
    // Comprobamos si ha pasado el timepo limite
    $sql_localizador_borrado = "SELECT localizador.timestamp, localizador.localizador, localizador.total
                                FROM localizadores localizador JOIN CecaTpv tpv ON localizador.localizador = tpv.localizador
                                AND tpv.Num_operacion = :num_operacion ";
  
    $query_localizador_borrado = $conexion->prepare($sql_localizador_borrado);
    $query_localizador_borrado->execute(array(':num_operacion' => $_POST['Num_operacion']));

    if ($query_localizador_borrado->rowCount() == 1) {
        $row = $query_localizador_borrado->fetch();
        recuperarBorrados($row['localizador'], $conexion);
        procesar_localizadores($conexion, $query_localizador_borrado, $language,$row['total']);
    }
}

function procesar_localizadores($conexion, $query_localizador, $language, $message,$precio){
    require DIRLIBCOMP . 'CecaTpv.class.php';

    $precio_formateado= str_pad($precio * 100, 12, "0", STR_PAD_LEFT);

    $settings = array(
        'Server'      => CECAServer,
        'MerchantID'  => CECAMerchantID, //Merchant ID, given by bank
        'AcquirerBIN' => CECAAcquirerBIN, //Bank ID, also given by bank
        'TerminalID'  => CECATerminalID, //Terminal ID, also given by bank
        'Clave'       => CECAClave_cifrado,
        'URL_OK'      => CECAURL_OK, //Complete URL when process is OK
        'URL_NOK'     => CECAURL_NOK, //Complete URL when process FAILs
    );

    $CecaTpv = new CecaTpv($settings);

    $checkFirma = $CecaTpv->check(array(
        'Firma'         => $_POST['Firma'],
        'Importe'       => $precio_formateado, //TODO Cambio por importe de base de datos
        'Referencia'    => $_POST['Referencia'],
        'Num_operacion' => $_POST['Num_operacion'],
    ));

    $estado = 'nuevo';
    if ($checkFirma) {
        $estado = 'pagado';
        /*** REGISTRO LOGS  ****/
        $sentencia = "LOCALIZADOR - " . $localizador . " - Firma Ok en la verificacion de la firma. Importe" . $_POST['Importe'] ;
        Insertar_Sentencia($sentencia, 'compra');
    }else{
        /*** REGISTRO LOGS  ****/
        $sentencia = "LOCALIZADOR - " . $localizador . " - INCIDENCIA en la verificacion de la firma. ". $_POST['Firma'] ." - ". $_POST['Importe'] . " - " . $_POST['Referencia'] . " - " . $_POST['Num_operacion'] . " - Precio bbdd: ". $precio_formateado ;
        Insertar_Sentencia($sentencia, 'compra');        
    }

    if( $precio_formateado != $_POST['Importe']  ){
          /*** REGISTRO LOGS  ****/
          $sentencia = "LOCALIZADOR - " . $localizador . " - INCIDENCIA descuadre de precios. Precio pasado". $_POST['Importe'] . " Num operacion- " . $_POST['Num_operacion'] . " - Precio bbdd: ". $precio_formateado ;
          Insertar_Sentencia($sentencia, 'compra');      
    }

    //UPDATE ESTADO COMPRA
    $sql_tpv = "UPDATE CecaTpv
                SET
                    MerchantID  = :MerchantID,
                    AcquirerBIN = :AcquirerBIN,
                    TipoMoneda  = :TipoMoneda,
                    Exponente   = :Exponente,
                    Referencia  = :Referencia,
                    Num_aut     = :Num_aut,
                    Idioma      = :Idioma,
                    Pais        = :Pais,
                    Descripcion = :Descripcion,
                    estado      = :estado
                WHERE Num_operacion = :Num_operacion";

    $result_tpv = $conexion->prepare($sql_tpv);
    $exec_tpv   = $result_tpv->execute(array(
        ':Num_operacion' => $_POST['Num_operacion'],
        ':MerchantID'    => $_POST['MerchantID'],
        ':AcquirerBIN'   => $_POST['AcquirerBIN'],
        ':TipoMoneda'    => $_POST['TipoMoneda'],
        ':Exponente'     => $_POST['Exponente'],
        ':Referencia'    => $_POST['Referencia'],
        ':Num_aut'       => $_POST['Num_aut'],
        ':Idioma'        => $_POST['Idioma'],
        ':Pais'          => $_POST['Pais'],
        ':Descripcion'   => $_POST['Descripcion'],
        ':estado'        => $estado,
    ));

    $sql_update_reserva = "UPDATE reservas reserva
                           JOIN CecaTpv tpv ON reserva.localizador = tpv.localizador
                           AND reserva.sala_horario_id = tpv.sala_horario_id
                           AND tpv.Num_operacion = :num_operacion
                           SET reserva.estado = 'finalizada'";

    $result_update_reserva = $conexion->prepare($sql_update_reserva);
    $exec_update_reserva   = $result_update_reserva->execute(array(
        ':num_operacion' => $_POST['Num_operacion'],
    ));

    $sql_update_localizador = "UPDATE localizadores localizador
                               JOIN CecaTpv tpv ON localizador.localizador = tpv.localizador
                               AND tpv.Num_operacion = :num_operacion
                               SET localizador.estado = 'pagado'";

    $result_update_localizador = $conexion->prepare($sql_update_localizador);
    $exec_update_localizador   = $result_update_localizador->execute(array(
        ':num_operacion' => $_POST['Num_operacion'],
    ));

    // Comprobamos si el timepo maximo de compra ha expirado
    $localizador = $query_localizador->fetch();
    $timeout     = false;
    /*if (strtotime($localizador['timestamp'] . ' +10 minutes') < time()) {
        $timeout = true;
    }*/

    // Si todo ha ido bien, commit
    if ($exec_tpv && $exec_update_reserva && $exec_update_localizador && !$timeout && $checkFirma) {
        $conexion->commit();
         
        // PHP con los textos estáticos de la plantilla
        require_once DIRLANGUAGESTRINGS . 'confirmar_compra/oky.php';

        /**
         *  Procesando el envio del correo electronico
         */
        require_once DIRMODULOSCOMP . 'compra/procesar_email_compra.php';

        /*** REGISTRO LOGS  ****/
        $sentencia = "LOCALIZADOR - " . $localizador . " - La reserva para el localizador ha cambiado de estado: finalizada";
        Insertar_Sentencia($sentencia, 'compra');
        $sentencia = "LOCALIZADOR - " . $localizador . " - Cambio de estado: pagado";
        Insertar_Sentencia($sentencia, 'compra');

        require_once DIRLANGUAGETEMPLATES . "compra_finalizada/oky.ctp";
    } else {
        $conexion->rollback();
        $conexion2 = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);
        devolver_stock('20' . $redsysObject['datos']['pedido'], $conexion2);
        /*** REGISTRO LOGS  ****/
        $sentencia = "LOCALIZADOR - " . $localizador . " - La reserva para el localizador no se ha podido finalizar; tpv: " . $exec_tpv . ", update reserva: " . $exec_update_reserva . " update localizador: " . $exec_update_localizador . " timeout: " . $timeout;
        Insertar_Sentencia($sentencia, 'compra');
        
        // PHP con los textos estáticos de la plantilla
        require_once DIRLANGUAGESTRINGS . 'compra_finalizada/nok_ups.php';

        // Compruebo si es móvil para cargar los css
        if (is_mobile()) {
            $RUTACSS = 'movil/compras_reservas.css';
        } else {
            $RUTACSS = 'compras_reservas.css';
        }

        $RAIZ = DOMINIO;
        $sesion_lang = $language->getSessionLang();
        $lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

        $protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
        $domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];
        
        $translated_form_action_contacta = $language->getFormActionTranslation('reserva_web/formulario_visitas.tpl_contacto', true);
        $form_action_contacta            = isset($translated_form_action_contacta) ? $translated_form_action_contacta : 'contacto-enoturismo';
        $ENLACECONTACTA                  = $domainLink . '/' . $form_action_contacta;

        $translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver', true);
        $form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : 'visitas';
        $IR_A_ENOTURISMO               = $domainLink . '/' . $form_action_volver;

        require_once DIRLANGUAGETEMPLATES . "compra_finalizada/nok_ups.ctp";
    }
}

function recuperarBorrados($localizador, $conexion)
{
    $delete_reservas      = "DELETE FROM reservas_borradas WHERE localizador = ?";
    $result_delres        = $conexion->prepare($delete_reservas);
    $result               = $result_delres->execute(array($localizador));
    $delete_localizadores = "DELETE FROM localizadores_borrados WHERE localizador = ?";
    $result_delloc        = $conexion->prepare($delete_localizadores);
    $result               = $result && $result_delloc->execute(array($localizador));
    $update_plazas        = "   UPDATE reservas rv
                                JOIN sala_horarios sh on rv.sala_horario_id=sh.id
                                JOIN salas sl on sl.id=sh.sala_id
                                JOIN localizadores loc on loc.localizador=rv.localizador
                                JOIN servicios sv on loc.servicio_id=sv.id
                                SET sh.plazas_libres = sh.plazas_libres - (CASE WHEN sv.horario_completo = 1 THEN sl.plazas ELSE rv.unidades END)
                                WHERE rv.localizador=?";
    $result_update      = $conexion->prepare($update_plazas);
    $result             = $result_update->execute(array($localizador));
    return $result;
}