<?php

date_default_timezone_set('Europe/Madrid');

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/email.txt');
error_reporting(E_ALL);

/**
 * ENVIO EMAIL COMPRA
 */
$sql_select_localizador = "SELECT localizador.*, servicio.nombre as servicio_nombre, servicio.gastro_bar, servicio.pases, servicio.creditos,
                           servicio.actividad_id as actividad_id, actividad.nombre as actividad_nombre,
                           instalacion.nombre as instalacion_nombre, instalacion.descripcion as instalacion_descripcion, instalacion.google_maps as instalacion_mapa, instalacion.google_maps, instalacion.enlace_prepago,
                           paypal.sala_horario_id as sala_horario_id
                           FROM localizadores localizador
                           JOIN Paypal paypal ON localizador.localizador = paypal.localizador
                           JOIN servicios servicio ON localizador.servicio_id = servicio.id
                           JOIN actividades actividad ON servicio.actividad_id = actividad.id
                           JOIN instalaciones instalacion ON servicio.instalacion_id = instalacion.id
                           AND localizador.estado = 'pagado' AND paypal.invoice = :num_operacion";

$result_select_localizador = $conexion->prepare($sql_select_localizador);
$exec_select_localizador   = $result_select_localizador->execute(array(':num_operacion' => $_POST['invoice']));

$info = $result_select_localizador->fetch();

// DATOS PARA EL CORREO
$localizador        = $info['localizador'];
$nombre             = $info['nombre'];
$apellidos          = $info['apellido'];
$telefono           = $info['telefono'];
$email              = $info['email'];
$actividad          = $info['actividad_nombre'];
$instalacion        = $info['instalacion_nombre'];
$instalacion_desc   = $info['instalacion_descripcion'];
$instalacion_mapa   = $info['instalacion_mapa'];
$instalacion_enlace = $info['enlace_prepago'];
$unidades           = $info['unidades'];
$id_pedido          = $info['id_pedido'];
$pago_instalacion   = 0;
$creditos_totales   = $info['pases_totales'];
$creditos_restantes = $info['servicio_pases'];
$instalacion_id     = $info['instalacion_id'];
$_SESSION["lang"]   = $language->getIsoLang($info['idioma']);
$pago_parcial       = '';
$idioma_visita_id = 1;

// IDIOMA DE LA VISITA
$sql_idioma_visita = "SELECT i.idioma,i.iso_code,i.id
					  FROM reservas r JOIN idiomas i ON r.idioma_id = i.id
					  AND r.localizador = '" . $localizador . "'";

$result_idioma_visita = $conexion->query($sql_idioma_visita);

if ($result_idioma_visita->rowCount() > 0) {
    $row_idioma_visita = $result_idioma_visita->fetch();
    $_SESSION["lang"]   = $row_idioma_visita['iso_code'];
    $language->setSessionLang($row_idioma_visita['iso_code']);
    $idioma_visita     = $language->getString($row_idioma_visita['idioma'], true);
    $idioma_visita_id  = $row_idioma_visita['id'];
}

// Traducciones
$servicio_id          = $info['servicio_id'];
$product_lang         = $language->getStringsProduct($servicio_id);
$condiciones_servicio = $product_lang['condiciones_servicio'];
$condiciones_extra    = $product_lang['condiciones_extra'];

// Archivos para el email
$archivos = $language->getArchivesProduct($servicio_id);

// Muestro cŕeditos si es servicio de descuento de créditos
// para bonos
if (($info['creditos'] == 1) && ($info['pases'] > 1)) {
    $creditos = 1;
} else {
    $creditos = 0;
}

// FECHA EN QUE REALIZÓ LA COMPRA
$fecha_compra = cambiaf_a_normal($info['fecha_compra']);

// PRECIO TOTAL
$total = sprintf('%0.2f', $info['total']);
$total = $total;

// TARIFAS
$sql_loc_taf = "SELECT lt.*, ug.nombre, t.precio, t.pago_grupo, t.usuarios_grupo_id
				FROM localizador_tarifas lt JOIN tarifas t ON lt.tarifa_id = t.id
				JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
				AND lt.localizador = '" . $info['localizador'] . "'";

$result_loc_taf = $conexion->query($sql_loc_taf);
$row_loc_taf    = $result_loc_taf->fetch();

$tarifas = $language->getString($row_loc_taf['nombre']);

$plazas_adulto   = $row_loc_taf['plazas_adulto'];
$plazas_infantil = $row_loc_taf['plazas_infantil'];


// Compruebo precio de la tarifa, por si luego hay descuento
if ($row_loc_taf['pago_grupo'] == 0) {
    $total_tarifa = $row_loc_taf['precio'] * $plazas_adulto;
} else {
    $total_tarifa = $row_loc_taf['precio'];
}
$total_tarifa = sprintf('%0.2f', $total_tarifa);

// DESCUENTOS O COSTES
$grupo_usuarios = $row_loc_taf['usuarios_grupo_id'];
$forma_pago     = $info['tipo_pago'];
$paso           = 'email_pdf';
$precio_total   = $total_tarifa;
$servicio       = $servicio_id;
// require_once DIRMODULOSCOMP . 'compra/descuentos_costes.php';

// PORCENTAJE PAGO PARCIAL
require_once DIRMODULOSCOMP . 'compra/pago_parcial.php';

// TEXTOS PARA EL EMAIL
$section_message = 'email_compra';
$servicio_texto  = $servicio_id;
require_once DIRMODULOSCOMP . 'otros/messages_email_pdf.php';

// Nombre del servicio
$servicio = $product_lang['nombre'];

// Tipo de pago
$sql_tipo_pago = "SELECT *
				  FROM tipos_pagos
				  WHERE id = " . $info['tipo_pago'];

$result_tipo_pago  = $conexion->query($sql_tipo_pago);
$row_tipo_pago     = $result_tipo_pago->fetch();
$pago_seleccionado = $language->getString($row_tipo_pago['pago']);

// Compruebo si hay reserva
if ($info['sala_horario_id'] != '') {
    // Busco reserva realizada para obtener plazas y fecha de reserva
    // Reserva para servicios comprados que no son horas valle
    $sql_reserva = "SELECT r.unidades, r.fecha_reserva, sh.fecha, sh.hora_inicio, sh.hora_fin, r.hora_balneario, r.deporte_id, s.s_instalacion, s.pistas
                    FROM reservas r JOIN localizadores l ON r.localizador = l.localizador
                    JOIN sala_horarios sh ON r.sala_horario_id = sh.id
                    JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                    JOIN servicios s ON ss.servicio_id = s.id
                    AND s.sala_id IS NOT NULL
                    AND ss.servicio_id = " . $servicio_id . "
                    AND r.localizador = '" . $localizador . "'
                    AND l.servicio_id = " . $servicio_id;

    $result_reserva = $conexion->query($sql_reserva);

    if ($result_reserva->rowCount() > 0) {
        $row_reserva = $result_reserva->fetch(PDO::FETCH_ASSOC);

        // Plazas, fecha en que realizó la reserva
        $fecha_realizada_reserva = cambiaf_a_normal($row_reserva['fecha_reserva']);
        $plazas                  = $row_reserva['unidades'];

        // Si es servicio de instalación mínimo 8 abonados
        if ($row_reserva['s_instalacion'] == 1 && (strpos(strtoupper($actividad), 'OTROS') === false)) {
            if ((strpos(strtoupper($nombre_tarifa), 'ABONADO') !== false)) {
                $plazas = 'Recuerden que como mínimo deben presentar 8 carnets de abonados';
            } else {
                $plazas = '';
            }
        }

        // Fecha y horario de la reserva
        $fecha_reserva = cambiaf_a_normal($row_reserva['fecha']);

        $hora_inicio = strtotime($row_reserva['hora_inicio']);
        $hora_inicio = date("H:i", $hora_inicio);
        $hora_fin    = strtotime($row_reserva['hora_fin']);
        $hora_fin    = date("H:i", $hora_fin);

        $esMasajes    = false;
        $esTipoCompra = false;

        // Compruebo si hay horario de balneario
        if ($row_reserva['hora_balneario'] != '') {
            $esMasajes         = true;
            $horario_balneario = $row_reserva['hora_balneario'];
        }

        // Compruebo si es servicio de pistas para mostrar jugadores en vez de plazas
        $pistas = $row_reserva['pistas'];

        // Busco reserva realizada para obtener plazas y fecha de reserva
        // Reserva para servicios comprados que no son horas valle
        $sql_reserva = "SELECT count(es.sala_horario_id) as cant_extras_horarios
        FROM extras_servicios_sala_horarios as es                
        INNER JOIN extras_servicios as e on es.extra_id = e.id and e.activo = 1 and e.publicado =1
        WHERE es.sala_horario_id = " . $info['sala_horario_id'];

        $result_reserva = $conexion->query($sql_reserva);

        if ($result_reserva->rowCount() > 0) {
            $row_reserva = $result_reserva->fetch(PDO::FETCH_ASSOC);
            if ( $row_reserva['cant_extras_horarios'] > 0){
                $hay_extras_horario = 1;
             
                $hash_encryp = encriptar("l=" . $localizador . "&requestpay=1&fecha=". $fecha_reserva );          
               
            }           
        }

    } else {

        // Comprobación de si es HORAS VALLE el servicio comprado
        // Compro bono o entrada y reservo servicio de horas valle

        // Busco servicio reservado de horas valle
        $sql_reservavalle = "SELECT s.*, r.fecha_reserva, r.unidades, r.sala_horario_id
							 FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
							 JOIN servicios s ON ss.servicio_id = s.id
							 AND r.localizador like '" . $localizador . "'
							 JOIN actividades a ON s.actividad_id = a.id
							 AND s.horas_valle = 1
							 AND s.actividad_id = " . $info['actividad_id'];

        $result_reservavalle = $conexion->query($sql_reservavalle);

        if ($result_reservavalle->rowCount() > 0) {
            $esMasajes    = false;
            $esTipoCompra = true;

            $row_reservavalle = $result_reservavalle->fetch(PDO::FETCH_ASSOC);

            $servicio_reserva = $row_reservavalle['nombre'];

            // Fecha en que se realizó la reserva y unidades reservadas
            $fecha_realizada_reserva = cambiaf_a_normal($row_reservavalle['fecha_reserva']);
            $plazas                  = $row_reservavalle['unidades'];

            // Fecha y horario de la reserva
            $sql_fecha_hora = "SELECT *
							   FROM sala_horarios WHERE id = " . $row_reservavalle['sala_horario_id'];

            $result_fecha_hora = $conexion->query($sql_fecha_hora);

            if ($result_fecha_hora->rowCount() > 0) {
                $row_fecha_hora = $result_fecha_hora->fetch(PDO::FETCH_ASSOC);

                $fecha_reserva = cambiaf_a_normal($row_fecha_hora['fecha']);
                $hora_inicio   = strtotime($row_fecha_hora['hora_inicio']);
                $hora_inicio   = date("H:i", $hora_inicio);
                $hora_fin      = strtotime($row_fecha_hora['hora_fin']);
                $hora_fin      = date("H:i", $hora_fin);
            }

            // Instalación horas valle
            $sql_instalacion = "SELECT nombre
								FROM instalaciones
								WHERE id = " . $row_reservavalle['instalacion_id'];

            $result_instalacion = $conexion->query($sql_instalacion);

            if ($result_instalacion->rowCount() > 0) {
                $row_instalacion = $result_instalacion->fetch();

                $instalacion = $row_instalacion['nombre'];
            }

            // Compruebo si es servicio de pistas para mostrar jugadores en vez de plazas
            $pistas = $row_reservavalle['pistas'];

        }
        // Busco servicio reservado de pistas
        else {

            $sql_reservapistas = "SELECT s.*, r.fecha_reserva, r.unidades, r.sala_horario_id
								  FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
								  JOIN servicios s ON ss.servicio_id = s.id
								  AND r.localizador like '" . $localizador . "'
								  JOIN actividades a ON s.actividad_id = a.id
								  AND s.pistas = 1
								  AND s.sala_id IS NOT NULL
								  AND s.actividad_id = " . $info['actividad_id'];

            $result_reservapistas = $conexion->query($sql_reservapistas);

            if ($result_reservapistas->rowCount() > 0) {
                $esMasajes    = false;
                $esTipoCompra = true;

                $row_reservapistas = $result_reservapistas->fetch(PDO::FETCH_ASSOC);

                $servicio_reserva = $row_reservapistas['nombre'];

                // Fecha en que se realizó la reserva y unidades reservadas
                $fecha_realizada_reserva = cambiaf_a_normal($row_reservapistas['fecha_reserva']);
                $plazas                  = $row_reservapistas['unidades'];

                // Fecha y horario de la reserva
                $sql_fecha_hora = "SELECT *
								   FROM sala_horarios WHERE id = " . $row_reservapistas['sala_horario_id'];

                $result_fecha_hora = $conexion->query($sql_fecha_hora);

                if ($result_fecha_hora->rowCount() > 0) {
                    $row_fecha_hora = $result_fecha_hora->fetch(PDO::FETCH_ASSOC);

                    $fecha_reserva = cambiaf_a_normal($row_fecha_hora['fecha']);
                    $hora_inicio   = strtotime($row_fecha_hora['hora_inicio']);
                    $hora_inicio   = date("H:i", $hora_inicio);
                    $hora_fin      = strtotime($row_fecha_hora['hora_fin']);
                    $hora_fin      = date("H:i", $hora_fin);
                }

                // Compruebo si es servicio de pistas para mostrar jugadores en vez de plazas
                $pistas = $row_reservapistas['pistas'];

            } else {
                $esMasajes    = false;
                $esTipoCompra = false;

                // Caso bonos compartidos en distintas actividades
                $sql_reserva = "SELECT r.unidades, r.fecha_reserva, sh.fecha, sh.hora_inicio, sh.hora_fin, s.s_instalacion, s.pistas, i.nombre as nombreI, s.nombre as nombreS
								FROM reservas r JOIN localizadores l ON r.localizador = l.localizador
								JOIN sala_horarios sh ON r.sala_horario_id = sh.id
								JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
								JOIN servicios s ON ss.servicio_id = s.id
								JOIN instalaciones i ON r.instalacion_id = i.id
								AND ss.servicio_id = " . $servicio_id . "
								AND r.localizador = '" . $localizador . "'
								AND l.servicio_id = " . $servicio_id;

                $result_reserva = $conexion->query($sql_reserva);

                if ($result_reserva->rowCount() > 0) {
                    $row_reserva = $result_reserva->fetch(PDO::FETCH_ASSOC);

                    // Plazas, fecha en que realizó la reserva
                    $fecha_realizada_reserva = cambiaf_a_normal($row_reserva['fecha_reserva']);
                    $plazas                  = $row_reserva['unidades'];

                    // Fecha y horario de la reserva
                    $fecha_reserva = cambiaf_a_normal($row_reserva['fecha']);

                    $hora_inicio = strtotime($row_reserva['hora_inicio']);
                    $hora_inicio = date("H:i", $hora_inicio);
                    $hora_fin    = strtotime($row_reserva['hora_fin']);
                    $hora_fin    = date("H:i", $hora_fin);

                    // Compruebo si es servicio de pistas para mostrar jugadores en vez de plazas
                    $pistas = $row_reserva['pistas'];

                    $instalacion      = $row_reserva['nombreI'];
                    $servicio_reserva = $row_reserva['nombreS'];

                    $deporte           = '';
                    $horario_balneario = '';
                }
            }
        }
    }
}

// CAMPOS EXTRA
$sql_campos_extra = "SELECT c.*, lc.value
                     FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
                     AND c.type NOT LIKE 'checkbox'
                     AND c.nombre NOT LIKE 'Observaciones'
                     AND lc.localizador = '" . $localizador . "'
                     AND c.id not in (100, 101, 102, 103)
                     UNION (
                        SELECT c.*, lc.value
                        FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
                        AND (c.type like 'checkbox' AND c.nombre like '%comida%')
                        AND lc.localizador = '" . $localizador . "'
                        )";


$result_campos_extra = $conexion->query($sql_campos_extra);

if ($result_campos_extra->rowCount() > 0) {

    $campos_extra = array();

    foreach ($result_campos_extra->fetchAll() as $row_campo) {
        $valor = $row_campo['value'];
        if ($valor == 'on') {
            $valor = $language->getString('Sí');
        }


        $campos_extra[] = '<span style="font-weight: 400; text-transform: uppercase;">' . $language->getString($row_campo['nombre'], true) .'</span><br />
                        <span style="font-size: 14px;color: #353535;font-weight: 400;letter-spacing: 0.03em;">' . $valor . '</span>';



    }
} else {
    $campos_extra = '';
}

if ($info['gastro_bar'] == 0) {
    $sql_loc_extras = "SELECT sum(le.unidades) as unidades, sum(le.total) as total,
            e.id, e.nombre, e.condiciones_extra, u.nombre as nombre_tarifa, et.tipo_clave,
            el.nombre as nombre_extra , el.condiciones_extra as condiciones_extra_tra
            FROM localizador_extras_servicio le 
            JOIN extras_servicios e ON le.extra_id = e.id
            INNER JOIN localizadores l ON le.localizador_extra = l.localizador  and l.estado='pagado'
            LEFT JOIN tarifas_extras t ON le.tarifa_id = t.id 
            LEFT JOIN usuarios_grupos u ON t.usuarios_grupo_id = u.id
            INNER JOIN extras_servicios_tipos et ON et.id = e.tipo_id
            LEFT JOIN extras_servicios_lang el ON el.extra_id = e.id AND el.idioma = ?
            WHERE le.localizador_extra = ?
            AND le.unidades > 0         
            GROUP BY le.tarifa_id, e.id, e.nombre, u.nombre, et.tipo_clave
            ORDER BY e.orden, le.tarifa_id
                       
                       ";

    $result_loc_extras = $conexion->prepare($sql_loc_extras);
    $result_loc_extras->execute(array( $idioma_visita_id, $info['localizador'] ));

    $extras_seleccionados = array();
    $extras_condiciones   = [];
    $condiciones_extra    = "";
    while ($row_loc_extra = $result_loc_extras->fetch()) {

        $nombre_extra = $language->getString($row_loc_extra['nombre'], true);
        if($idioma_visita_id != 1 && isset($row_loc_extra['nombre_extra'])){
            $nombre_extra = $row_loc_extra['nombre_extra'];
        }
        if($idioma_visita_id != 1 && isset($row_loc_extra['condiciones_extra_tra'])){
            $condiciones_extra_item = $row_loc_extra['condiciones_extra_tra'];
        }else{
            $condiciones_extra_item = $row_loc_extra['condiciones_extra'];
        }
        $extras_condiciones[$row_loc_extra['id']] =  $condiciones_extra_item;

        $nombre_tarifa = $language->getString($row_loc_extra['nombre_tarifa'], true);
        
        if ($nombre_tarifa == '' ){
            $nombre_extra = $nombre_extra;
        }else{
            $nombre_extra = $nombre_extra . " | " . $nombre_tarifa ;
        }

        $extras_seleccionados[] = array(
            'abreviatura'   => $row_loc_extra['abreviatura'],
            'imagen'        => $row_loc_extra['imagen'],
            'nombre'        => $nombre_extra,
            'nombre_tarifa' => $nombre_tarifa,
            'cantidad'      => $row_loc_extra['unidades'],
            'precio'        => number_format($row_loc_extra['total'],2) .' €',
        );
    }
    foreach ($extras_condiciones  as $key => $value) {
        $condiciones_extra = $condiciones_extra . ' ' . $value;
    }
} else {
    $sql_loc_extras = "SELECT lp.*, p.*, sp.precio as precio_extra_gastrobar
                       FROM localizador_productos lp
                       JOIN productos p ON lp.producto_id = p.id
                       JOIN servicios_productos sp on sp.producto_id = p.id
                       WHERE lp.localizador = ? AND sp.servicio_id = ?";

    $result_loc_extras = $conexion->prepare($sql_loc_extras);
    $result_loc_extras->execute(array($info['localizador'], $info['servicio_id']));

    $extras_seleccionados = array();
    while ($row_loc_extra = $result_loc_extras->fetch()) {

        $nombre_extra = $language->getString($row_loc_extra['nombre'], true);

        $extras_seleccionados[] = array(
            'abreviatura' => $row_loc_extra['abreviatura'],
            'imagen'      => $row_loc_extra['imagen'],
            'nombre'      => $language->getStringProducto($nombre_extra, true),
            'cantidad'    => $row_loc_extra['unidades'],
            'precio'      => $row_loc_extra['precio_extra_gastrobar'],
        );
    }
}

require_once DIRMODULOSCOMP . 'compra/recibircorreo_compra.php';