<?php

// ENVÍO DE CORREO LOS DATOS DE LA RESERVA
//require_once DIRLIBCOMP . 'mail/class.phpmailer.php';
require_once 'datos_ventas_analytics_hit.php';

require_once DIRLIBCOMP . 'QR/phpqrcode.php';

require_once DIRLIBCOMP . 'autoload.php';

use Passbook\PassFactory;
use Passbook\Pass\Barcode;
use Passbook\Pass\Field;
use Passbook\Pass\Image;
use Passbook\Pass\Structure;
use Passbook\Type\EventTicket;

//$archivo_qr = DIRWEBROOT . 'img/QR/' . $localizador . '.png';
$archivo_qr = CARPETAPROYECTO . '/modules/visitas/reservas/images/QR/' . $localizador . '.png';

if (!file_exists($archivo_qr)) {
    QRcode::png($localizador, $archivo_qr, QR_ECLEVEL_L, 6);
}

require_once DIRLIBCOMP . 'mail/PHPMailer.php';
require_once DIRLIBCOMP . 'mail/SMTP.php';
require_once DIRLIBCOMP . 'mail/Exception.php';

$mail = new PHPMailer\PHPMailer\PHPMailer(true);

$correo = obtenerDatosCorreo();

// -----------SMTP--------------
// Con PluginDir le indicamos a la clase phpmailer donde se
// encuentra la clase smtp que como he comentado al principio de
// este ejemplo va a estar en el subdirectorio includes
$mail->CharSet   = "UTF-8";
$mail->Encoding = 'base64';
// $mail->PluginDir = "";
// Con la propiedad Mailer le indicamos que vamos a usar un servidor smtp
$mail->Mailer = "smtp";
//Le indicamos el content-type HTML
$mail->isHTML(true);
$mail->SMTPSecure = 'tls';
// Asignamos a Host el nombre de nuestro servidor smtp
$mail->Host = MAILHOST;
// Le indicamos que el servidor smtp requiere autenticación
$mail->SMTPAuth = MAILSMTPAUTH;
// Le decimos cual es nuestro nombre de usuario y password
$mail->Username = $correo['user'] ?? MAILUSER;
$mail->Password = $correo['pass'] ?? MAILPASS;
// Asignamos a Host el nombre de nuestro servidor smtp
//$mail->Port      = 25;
$mail->Port = MAILPORT;
$mail->From = $correo['mail'] ?? MAILFROM;
$mail->SetLanguage(strtolower(substr($language->getSessionLang(), 0, -3)), DIRLIBCOMP . 'mail/');
//$mail->AddCustomHeader('Reply-to:informacion.bodegas@pruebajig.es');
//$mail->SMTPDebug = 2;
$mail->FromName = "=?UTF-8?B?" . base64_encode(mb_convert_encoding('Reservas ' . $instalacion, "UTF-8", mb_detect_encoding('Reservas ' . $instalacion))) . "=?=";
//para que coja la 'ñ';

$subject = $language->getString('Reserva Realizada', true) . ' - ' . $instalacion . ' - ' . $language->getString($servicio);

$mail->Subject  = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($subject, "UTF-8", mb_detect_encoding($subject))) . "=?=";

$tarifas_nombre  = array();
$precios         = array();
$unidades_tarifa = array();

// Muestro información de las tarifas seleccionadas
$sql_tarifa_carrito = "SELECT lt.*, ug.nombre, t.precio, t.pago_grupo, t.usuarios_grupo_id
                       FROM localizador_tarifas lt JOIN tarifas t ON lt.tarifa_id = t.id
                       JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
                       AND lt.localizador = '" . $localizador . "'";

$result_tarifa_carrito = $conexion->query($sql_tarifa_carrito);

if ($result_tarifa_carrito->rowCount() > 0) {
    while ($row_tarifa = $result_tarifa_carrito->fetch(PDO::FETCH_ASSOC)) {

        $nombre_tarifa    = $row_tarifa['nombre'];
        $tarifas_nombre[] = $language->getString($nombre_tarifa, true);

        // Precio con dos decimales
        // Compruebo si precio es por grupo o por persona
        if ($row_tarifa['pago_grupo'] == 0) {
            $precio = $row_tarifa['precio'] * $row_tarifa['plazas_adulto'];
        } else {
            $precio = $row_tarifa['precio'];
        }

        $precio            = sprintf('%0.2f', $precio);
        $precios[]         = $precio;
        $unidades_tarifa[] = $row_tarifa['plazas_adulto'];
    }
}

// Obtenemos el id dels ervicio
$sql_servicio    = "select id, gastro_bar, regalo, cargo_por_persona, cargo_por_porcentaje_total from servicios where nombre = '" . $servicio . "'";
$result_servicio = $conexion->query($sql_servicio);

if ($result_servicio->rowCount() > 0) {
    $row_servicio = $result_servicio->fetch(PDO::FETCH_ASSOC);
    $id_servicio  = $row_servicio['id'];
    $gastro_bar   = $row_servicio['gastro_bar'];
    $regalo       = $row_servicio['regalo'];
    $cargo_por_persona = $row_servicio['cargo_por_persona'];
    $cargo_por_porcentaje_total = $row_servicio['cargo_por_porcentaje_total'];
} else {
    $id_servicio = 0;
    $gastro_bar  = 0;
    $regalo      = 0;
    $cargo_por_persona = null;
    $cargo_por_porcentaje_total = null;
}

if ($total == 0) {
    $total = $language->getString('Gratuito', true);
} else {
    $total = (float) $total;
}

$long = sizeof($precios);
for ($i = 0; $i < $long; $i++) {
    if ($precios[$i] == 0) {
        $precios[$i] = $language->getString('Gratuito', true);
    } else {
        $precios[$i] = (float) $precios[$i];
    }
}

$protocol   = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];
$loc_encryp = encriptar($localizador);

// Comprobamos si tiene un cupón de descuento asignado
$sql_localizador_completo    = "SELECT * FROM localizadores WHERE localizador = '" . $localizador . "'";
$result_localizador_completo = $conexion->query($sql_localizador_completo);
$row_localizador_completo    = $result_localizador_completo->fetch(PDO::FETCH_ASSOC);
$localizador_id              = $row_localizador_completo['id'];

$cupon_correo = "";
if ($row_localizador_completo['bono'] != '') {
    $sql_cupon_correo    = "SELECT * FROM bonos WHERE codigo = '" . $row_localizador_completo['bono'] . "' ";
    $result_cupon_correo = $conexion->query($sql_cupon_correo);

    if ($result_cupon_correo->rowCount() > 0) {
        $cupon_correo = $result_cupon_correo->fetch(PDO::FETCH_ASSOC);
    }
}

// Para servicios de tipo mesa se manda el coste de "cancelacion" o "no asistencia"
$table_service_cost = ($cargo_por_persona) ? $cargo_por_persona . '€' : $cargo_por_porcentaje_total . '%';

// Paso de datos a la plantilla
$compra = array(
    'localizador'               => !empty($localizador) ? $localizador : '',
    'nombre'                    => !empty($nombre) ? $nombre : '',
    'apellidos'                 => !empty($apellidos) ? $apellidos : '',
    'telefono'                  => !empty($telefono) ? $telefono : '',
    'email'                     => !empty($email) ? $email : '',
    'actividad'                 => !empty($actividad) ? $actividad : '',
    'servicio'                  => !empty($servicio) ? $servicio : '',
    'instalacion'               => !empty($instalacion) ? $instalacion : '',
    'fecha_reserva'             => !empty($fecha_reserva) ? $fecha_reserva : '',
    'horario'                   => !empty($hora_inicio) ? $hora_inicio : '',
    'total'                     => !empty($total) ? $total : '',
    'esTipoCompra'              => !empty($esTipoCompra) ? $esTipoCompra : '',
    'servicio_reserva'          => !empty($servicio_reserva) ? $servicio_reserva : '',
    'unidades'                  => !empty($unidades) ? $unidades : '',
    'tarifas_nombre'            => !empty($tarifas_nombre) ? $tarifas_nombre : array(),
    'precios'                   => !empty($precios) ? $precios : array(),
    'unidades_tarifa'           => !empty($unidades_tarifa) ? $unidades_tarifa : array(),
    'fecha_compra'              => !empty($fecha_compra) ? $fecha_compra : '',
    'fecha_realizada_reserva'   => !empty($fecha_realizada_reserva) ? $fecha_realizada_reserva : '',
    'plazas'                    => !empty($plazas) ? $plazas : '',
    'creditos'                  => !empty($creditos) ? $creditos : '',
    'creditos_totales'          => !empty($creditos_totales) ? $creditos_totales : '',
    'creditos_restantes'        => !empty($creditos_restantes) ? $creditos_restantes : '',
    'id_pedido'                 => !empty($id_pedido) ? $id_pedido : '',
    'pago_instalacion'          => !empty($pago_instalacion) ? $pago_instalacion : '',
    'pistas'                    => !empty($pistas) ? $pistas : '',
    'opciones_seleccionadas'    => !empty($opciones_seleccionadas) ? $opciones_seleccionadas : '',
    'campos_extra'              => !empty($campos_extra) ? $campos_extra : array(),
    'plazas_adulto'             => !empty($plazas_adulto) ? $plazas_adulto : '',
    'plazas_infantil'           => !empty($plazas_infantil) ? $plazas_infantil : '',
    'pago_seleccionado'         => !empty($pago_seleccionado) ? $pago_seleccionado : '',
    'total_tarifa'              => !empty($total_tarifa) ? $total_tarifa : '',
    'descuento_coste'           => !empty($descuento_coste) ? $descuento_coste : '',
    'message_generico_emailPdf' => !empty($message_generico_emailPdf) ? $message_generico_emailPdf : '',
    'message_servicio_emailPdf' => !empty($message_servicio_emailPdf) ? $message_servicio_emailPdf : '',
    'condiciones_servicio'      => !empty($condiciones_servicio) ? $condiciones_servicio : '',
    'condiciones_extra'         => !empty($condiciones_extra) ? $condiciones_extra : '',
    'pago_parcial'              => !empty($pago_parcial) ? $pago_parcial : '',
    'descuento_coste_realizado' => !empty($descuento_coste_realizado) ? $descuento_coste_realizado : '',
    'tipo_aplicado'             => !empty($tipo_aplicado) ? $tipo_aplicado : '',
    'idioma_visita'             => !empty($idioma_visita) ? $idioma_visita : '',
    'extras_seleccionados'      => !empty($extras_seleccionados) ? $extras_seleccionados : array(),
    'domainLink'                => !empty($domainLink) ? $domainLink : '',
    'loc_encryp'                => !empty($loc_encryp) ? $loc_encryp : '',
    'cupon'                     => !empty($cupon_correo) ? $cupon_correo : '',
    'instalacion_descripcion'   => !empty($instalacion_desc) ? $instalacion_desc : '',
    'instalacion_mapa'          => !empty($instalacion_mapa) ? $instalacion_mapa : '',
    'instalacion_prepago'       => !empty($instalacion_enlace) ? $instalacion_enlace : '',
    'table_service_cost'        => !empty($table_service_cost) ? $table_service_cost : '',
    'custom_hour_extra_field'   => !empty($custom_hour_extra_field) ? $custom_hour_extra_field : ''
);


//generamos el .pkpass
generatePKPass($compra);
// TODO descomentar para cuando tengamos todo
//gaHitTransaction($pago_seleccionado, $localizador, $total, $actividad, $servicio, $idioma_visita, $id_servicio, $extras_seleccionados);

ob_start();
if ($gastro_bar == 1) {
    // Modificamos el asunto del correo
    // para que coja la 'ñ';
    $mail->FromName = "=?UTF-8?B?" . base64_encode(mb_convert_encoding('Gastro Bar ' . $instalacion, "UTF-8", mb_detect_encoding('Gastro Bar ' . $instalacion))) . "=?=";
    $subject = $language->getString('Gastro-Bar') . ' - ' . $instalacion;
    $mail->Subject  = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($subject, "UTF-8", mb_detect_encoding($subject))) . "=?=";

    // Conseguimos la mesa
    $sql_obtener_mesa    = "SELECT numero 
                            FROM localizador_mesas 
                            join mesas on mesas.id = localizador_mesas.mesa 
                            where localizador = '" . $localizador . "'";
    $result_obtener_mesa = $conexion->query($sql_obtener_mesa);

    if ($result_obtener_mesa->rowCount() > 0) {
        $row_mesa       = $result_obtener_mesa->fetch(PDO::FETCH_ASSOC);
        $compra['mesa'] = $row_mesa['numero'];
    }

    if (strpos(strtoupper($compra['pago_seleccionado']), 'BIZUM') !== false || strpos(strtoupper($compra['pago_seleccionado']), 'TARJETA') !== false) {
        $compra['id_pedido'] = substr($compra['id_pedido'], 2, 12);
    }

    require DIRLIBCOMP . 'mail/plantillas_correo/' . (isset($_SESSION["visitas_lang"]) ? $_SESSION["visitas_lang"] : 'es_ES') . '/QR-gastrobar-BFE.php'; //Plantilla de correo


    $extras_string = '';
    foreach ($compra['extras_seleccionados'] as $extra) {

        $extras_string .= $extra['cantidad'] . "   " . $extra['abreviatura'] . "(" . $extra['precio'] . ")\n";
    }

    $fecha_comanda = date('d-m-Y H:i');

    $a = file_get_contents(CARPETAPROYECTO . '/modules/visitas/reservas/modulos/compra/comanda.txt');
    $a = str_replace("###cliente_comanda###", $compra['nombre'] . ' ' . $compra['apellidos'], $a);
    $a = str_replace("###fecha_hora###", $fecha_comanda, $a);

    $long_total = 0;
    if (!empty($compra['cupon'])) {
        $total_productos = 0;
        foreach ($compra['extras_seleccionados'] as $extra) {
            $total_productos += number_format($extra['precio'], 2);
        }
        if ($compra['cupon']['porcentual'] == 1) {
            $descuento = -$total_productos * $compra['cupon']['cantidad'] / 100;
        } else {
            $descuento = $compra['cupon']['cantidad'] . " €";
        }

        $long_precio = strlen(number_format($total_productos, 2)) + 1;
        $long_cant   = strlen(number_format($descuento, 2)) + 1;
        $long_codigo = strlen($compra['cupon']['codigo']);
        $long_total  = strlen(strval(number_format($compra['total'], 2))) + 1;

        $string_subtotal = "SUBTOTAL:" . str_repeat(" ", 19 - $long_precio) . number_format($total_productos, 2) . "€\n";
        $string_subtotal .= "Descuentos(" . $compra['cupon']['codigo'] . "):" . str_repeat(" ", 15 - $long_cant - $long_codigo) . number_format($descuento, 2) . "€\n\n";

        $a = str_replace("###subtotal###", $string_subtotal, $a);
    } else {
        $a = str_replace("###subtotal###", "", $a);
    }

    $a = str_replace("###mesa_comanda###", $compra['mesa'], $a);
    $a = str_replace("###localizador###", $compra['localizador'], $a);
    $a = str_replace("###variable_extras###", $extras_string, $a);
    $a = str_replace("###tipo_pago###", $compra['pago_seleccionado'], $a);
    $a = str_replace("##total##", str_repeat(".", 21 - $long_total) . strval(number_format($compra['total'], 2)) . "€", $a);

    $file = fopen(CARPETAPROYECTO . "/modules/visitas/reservas/modulos/compra/comandas/comanda_" . $compra['localizador'] . ".txt", "a");
    fwrite($file, print_r($a, true) . PHP_EOL);
    fclose($file);

    $file2 = CARPETAPROYECTO . "/modules/visitas/reservas/modulos/compra/comandas/comanda_" . $compra['localizador'] . ".txt";
    shell_exec('lp -d Epson_Tickets ' . $file2);
    shell_exec('lp -d Epson_Tickets ' . $file2);

    // una vez mandado a la cola le ponemos el imprimir en taquilla a 1
    $sql_update_localizador_producto    = "UPDATE localizadores set impreso_en_taquilla=1 where localizador = '" . $compra['localizador'] . "'";
    $result_update_localizador_producto = $conexion->query($sql_update_localizador_producto);
} else if ($row_localizador_completo['regalo']) {
    // Se mandan dos emails uno al que ha realizado la compra y otro al que se le va a regalar
    // Obtenemos los datos del regalado
    $select_nombre_regalado = "SELECT value as nombre from localizador_campos where campo_id = 100 and localizador = '" . $compra['localizador'] . "'";
    $result_nombre_regalado = $conexion->query($select_nombre_regalado);

    if ($result_nombre_regalado->rowCount() > 0) {
        $row_nombre       = $result_nombre_regalado->fetch(PDO::FETCH_ASSOC);
        $compra['nombre_regalado'] = $row_nombre['nombre'];
    }

    $select_apellido_regalado = "SELECT value as apellido from localizador_campos where campo_id = 101 and localizador = '" . $compra['localizador'] . "'";
    $result_apellido_regalado = $conexion->query($select_apellido_regalado);

    if ($result_apellido_regalado->rowCount() > 0) {
        $row_apellido        = $result_apellido_regalado->fetch(PDO::FETCH_ASSOC);
        $compra['apellidos_regalado'] = $row_apellido['apellido'];
    }

    $select_email_regalado = "SELECT value as email from localizador_campos where campo_id = 102 and localizador = '" . $compra['localizador'] . "'";
    $result_email_regalado = $conexion->query($select_email_regalado);

    if ($result_email_regalado->rowCount() > 0) {
        $row_email       = $result_email_regalado->fetch(PDO::FETCH_ASSOC);
        $compra['email_regalado'] = $row_email['email'];

        $destinatarios2[] = array(
            'nombre' => $row_nombre['nombre'],
            'email'  => $row_email['email'],
        );
    }

    $select_telefono_regalado = "SELECT value as telefono from localizador_campos where campo_id = 103 and localizador = '" . $compra['localizador'] . "'";
    $result_telefono_regalado = $conexion->query($select_telefono_regalado);

    if ($result_telefono_regalado->rowCount() > 0) {
        $row_telefono                = $result_telefono_regalado->fetch(PDO::FETCH_ASSOC);
        $compra['telefono_regalado'] = $row_telefono['telefono'];
    }

    $subject = $compra['nombre'] . $language->getString(' te ha regalado una experiencia en ') . $instalacion . $language->getString(': descúbrela');
    $mail->Subject  = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($subject, "UTF-8", mb_detect_encoding($subject))) . "=?=";

    require DIRLIBCOMP . 'mail/plantillas_correo/' . (!empty($_SESSION["visitas_lang"]) ? $_SESSION["visitas_lang"] : 'es_ES') . '/correo_compra_regalo.php'; //Plantilla de correo
    $body2 = ob_get_contents();
    ob_end_clean();

    $mail->Body    = $body2;

    if (!empty($destinatarios2) && is_array($destinatarios2) === true) {
        foreach ($destinatarios2 as $destino) {

            $mail->AddAddress($destino['email'], $destino['nombre']);
            if ($mail->Send()) {
                //return true;

            } else {
                //return false;

            }
            $mail->ClearAddresses();
        }
    }
    ob_start();

    $subject = $language->getString($servicio) . ' - ' . $instalacion;
    $mail->Subject  = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($subject, "UTF-8", mb_detect_encoding($subject))) . "=?=";
    require DIRLIBCOMP . 'mail/plantillas_correo/' . (!empty($_SESSION["visitas_lang"]) ? $_SESSION["visitas_lang"] : 'es_ES') . '/correo_compra_regalador.php'; //Plantilla de correo
} else {
    $subject = $language->getString('Reserva Realizada', true) . ' - ' . $instalacion . ' - ' . $language->getString($servicio);
    $mail->Subject  = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($subject, "UTF-8", mb_detect_encoding($subject))) . "=?=";
    require DIRLIBCOMP . 'mail/plantillas_correo/' . (!empty($_SESSION["visitas_lang"]) ? $_SESSION["visitas_lang"] : 'es_ES') . '/correo_compra.php'; //Plantilla de correo
}

$body = ob_get_contents();
ob_end_clean();

$mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
$mail->Body    = $body;

// Envío de correo yo, nosotros, cliente(si lo puso) y bodega
// Yo
// Envío de correo a debug 
$emails_debug = (array)json_decode($_ENV['MAIL_TO_NOTIFY_DEBUG'], true);
//Envío de correo
if (is_array($emails_debug) === true) {
    foreach ($emails_debug as $email_ua => $email_data) {
        $destinatarios[] = array(
            'nombre' => $email_data['nombre'],
            'email'  => $email_data['email']
        );
    }
}

// Envío de correo yo, nosotros, cliente(si lo puso) y bodega
if (ENVIRONMENT == 'production') {
    //Bodega y eshop
    $emails_notify = (array)json_decode($_ENV['MAIL_TO_NOTIFY'], true);

    if (is_array($emails_notify) === true) {
        foreach ($emails_notify as $email_ua => $email_data) {
            $destinatarios[] = array(
                'nombre' => $email_data['nombre'],
                'email'  => $email_data['email']
            );
        }
    }
    // Cliente
    if ($email != '') {
        $email_ua        = $email;
        $destinatarios[] = array(
            'nombre' => $nombre,
            'email'  => $email,
        );
    }
}

if (is_array($destinatarios) === true) {
    foreach ($destinatarios as $destino) {
        $mail->AddAddress($destino['email'], $destino['nombre']);
        if ($mail->Send()) {
            //return true;
        } else {
            //return false;
        }
        $mail->ClearAddresses();
    }
}

function generatePKPass($compra)
{
    $OUTPUT_PATH = PASSBOOK_OUTPUT_PATH_BASE . $compra['localizador'];

    try {
        // Create an event ticket
        $pass = new EventTicket($compra['localizador'], html_entity_decode(strip_tags($compra['servicio'])));

        $pass->setBackgroundColor('rgb(30, 30, 30)'); //color de fondo
        $pass->setForegroundColor('rgb(150,150,150)'); //color del texto
        $pass->setLabelColor('rgb(197,159,79)'); //color de las etiquetas

        $image = new Image(PASSBOOK_ICON_FILE, 'logo');
        $image->setDensity(2);
        $pass->addImage($image);

        $image2 = new Image(PASSBOOK_BACKGROUND_FILE, 'strip');
        $pass->addImage($image2);

        // Create pass structure
        $structure = new Structure();

        $header = new Field('header', '');
        $header->setLabel($compra['fecha_reserva']);
        $header->setValue($compra['horario']);
        $structure->addHeaderField($header);

        $secondary = new Field('event', html_entity_decode(strtoupper(($compra['servicio']))));
        $secondary->setLabel('Enoexperiencia');
        $structure->addSecondaryField($secondary);

        // Add Secondary field
        $secondary = new Field('localizador', $compra['localizador']);
        $secondary->setLabel('Localizador');
        $structure->addSecondaryField($secondary);

        // Add auxiliary field
        $auxiliary = new Field('plazas', $compra['plazas']);
        $auxiliary->setLabel('Plazas');
        $structure->addAuxiliaryField($auxiliary);

        // Add auxiliary field
        $auxiliary = new Field('total', $compra['total'] . "€");
        $auxiliary->setLabel('Total');
        $structure->addAuxiliaryField($auxiliary);

        // Add icon image
        $icon = new Image(PASSBOOK_ICON_FILE, 'icon');
        $pass->addImage($icon);

        // Set pass structure
        $pass->setStructure($structure);

        // Add barcode
        $barcode = new Barcode(Barcode::TYPE_QR, $compra['localizador']);
        $pass->setBarcode($barcode);

        $backfile = new Field('nombre', html_entity_decode(strip_tags($compra['nombre'] . " " . $compra['apellidos'])));
        $backfile->setLabel('Nombre');
        $structure->addBackField($backfile);

        $backfile = new Field('email', html_entity_decode(strip_tags($compra['email'])));
        $backfile->setLabel('Email');
        $structure->addBackField($backfile);

        $backfile = new Field('lugar', html_entity_decode(strip_tags($compra['instalacion'])));
        $backfile->setLabel('Lugar');
        $structure->addBackField($backfile);

        $backfile = new Field('idioma', html_entity_decode(strip_tags($compra['idioma_visita'])));
        $backfile->setLabel('Idioma');
        $structure->addBackField($backfile);

        // Create pass factory instance
        $factory = new PassFactory(
            PASSBOOK_PASS_TYPE_IDENTIFIER,
            PASSBOOK_TEAM_IDENTIFIER,
            PASSBOOK_ORGANIZATION_NAME,
            PASSBOOK_P12_FILE,
            PASSBOOK_P12_PASSWORD,
            PASSBOOK_WWDR_FILE
        );
        $factory->setOutputPath($OUTPUT_PATH);

        $factory->package($pass);
    } catch (Exception $ex) {
        $sentencia        = " LOCALIZADOR -  " . $localizador . " Error generar pasbook " . $ex;
        Insertar_Sentencia($sentencia, 'compra');
    }


    return $OUTPUT_PATH;
}
