<?php

require_once dirname(__DIR__) . '/../config.php';
define('BASEPATH', $_SERVER['DOCUMENT_ROOT'] . '/wp-content/plugins/visitas');
/**************    Include cabecera  ***********************************/
require_once BASEPATH . '/modules/visitas/reservas/principal_compra_reserva.php';

require_once DIRLIBCOMP .'autoload.php';

use Passbook\Pass\Field;
use Passbook\Pass\Image;
use Passbook\PassFactory;
use Passbook\Pass\Barcode;
use Passbook\Pass\Structure;
use Passbook\Type\EventTicket;
use Passbook\Type\StoreCard;

$sql_localizador = "SELECT l.localizador, l.nombre, l.apellido, l.email, l.total, l.unidades, sh.fecha, sh.hora_inicio, s.nombre as servicio, i.idioma, ins.nombre as instalacion
                    FROM localizadores as l
                    JOIN reservas as r on l.localizador = r.localizador
                    JOIN sala_horarios as sh on r.sala_horario_id = sh.id
                    JOIN servicios as s on l.servicio_id = s.id
                    JOIN idiomas as i on l.idioma = i.id
                    JOIN instalaciones as ins on l.instalacion_id = ins.id
                    WHERE sh.fecha >= '2021-06-15'";

$result_localizador = $conexion->query($sql_localizador); 

if ($result_localizador->rowCount() > 0) {

    $localizadores = $result_localizador->fetchAll();

    foreach ($localizadores as $localizador) {
        //if ($localizador['localizador'] == 'LCGBBW' || $localizador['localizador'] == 'T2PLNN') {
            
            $compra = array(
                'localizador'   => $localizador['localizador'],
                'servicio'      => $localizador['servicio'],
                'fecha_reserva' => $localizador['fecha'],
                'horario'       => $localizador['hora_inicio'],
                'plazas'        => $localizador['unidades'],
                'nombre'        => $localizador['nombre'],
                'apellidos'     => $localizador['apellido'],
                'total'         => $localizador['total'],
                'email'         => $localizador['email'],
                'idioma_visita' => $localizador['idioma'],
                'instalacion'   => $localizador['instalacion'],
            );

            //generamos el .pkpass
            generatePKPass($compra);
        //}
    }
}

function generatePKPass($compra)
{   
    $OUTPUT_PATH = PASSBOOK_OUTPUT_PATH_BASE . $compra['localizador'];

    // Create an event ticket
    $pass = new EventTicket($compra['localizador'], html_entity_decode(strip_tags($compra['servicio'])));

    $pass->setBackgroundColor('rgb(30, 30, 30)'); //color de fondo
    $pass->setForegroundColor('rgb(150,150,150)'); //color del texto
    $pass->setLabelColor('rgb(197,159,79)'); //color de las etiquetas

    $image = new Image(PASSBOOK_ICON_FILE, 'logo');
    $image->setDensity(2);
    $pass->addImage($image);

    $image2 = new Image(PASSBOOK_BACKGROUND_FILE, 'strip');
    $pass->addImage($image2);

    // Create pass structure
    $structure = new Structure();

    $header = new Field('header', '');
    $header->setLabel($compra['fecha_reserva']);
    $header->setValue($compra['horario']);
    $structure->addHeaderField($header);

    $secondary = new Field('event', html_entity_decode(strtoupper(($compra['servicio']))));
    $secondary->setLabel('Enoexperiencia');
    $structure->addSecondaryField($secondary);

    // Add Secondary field
    $secondary = new Field('localizador', $compra['localizador']);
    $secondary->setLabel('Localizador');
    $structure->addSecondaryField($secondary);

    // Add auxiliary field
    $auxiliary = new Field('plazas', $compra['plazas']);
    $auxiliary->setLabel('Plazas');
    $structure->addAuxiliaryField($auxiliary);

    // Add auxiliary field
    $auxiliary = new Field('total', $compra['total'] . "€");
    $auxiliary->setLabel('Total');
    $structure->addAuxiliaryField($auxiliary);

    // Add icon image
    $icon = new Image(PASSBOOK_ICON_FILE, 'icon');
    $pass->addImage($icon);

    // Set pass structure
    $pass->setStructure($structure);

    // Add barcode
    $barcode = new Barcode(Barcode::TYPE_QR, $compra['localizador']);
    $pass->setBarcode($barcode);

    $backfile = new Field('nombre', html_entity_decode(strip_tags($compra['nombre'] . " " . $compra['apellidos'])));
    $backfile->setLabel('Nombre');
    $structure->addBackField($backfile);

    $backfile = new Field('email', html_entity_decode(strip_tags($compra['email'])));
    $backfile->setLabel('Email');
    $structure->addBackField($backfile);

    $backfile = new Field('lugar', html_entity_decode(strip_tags($compra['instalacion'])));
    $backfile->setLabel('Lugar');
    $structure->addBackField($backfile);

    $backfile = new Field('idioma', html_entity_decode(strip_tags($compra['idioma_visita'])));
    $backfile->setLabel('Idioma');
    $structure->addBackField($backfile);

    // Create pass factory instance
    $factory = new PassFactory(
        PASSBOOK_PASS_TYPE_IDENTIFIER,
        PASSBOOK_TEAM_IDENTIFIER,
        PASSBOOK_ORGANIZATION_NAME,
        PASSBOOK_P12_FILE,
        PASSBOOK_P12_PASSWORD,
        PASSBOOK_WWDR_FILE);
    $factory->setOutputPath($OUTPUT_PATH);

    $factory->package($pass);

    return $OUTPUT_PATH;
}
