<?php

/**************    Include cabecera  ***********************************/
require_once dirname(__DIR__) . '/principal_compra_reserva.php';

$protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

if (isset($_REQUEST['hash'])) {
    $idioma_navegador = 1;
    
    $hash_decryp = desencriptar($_REQUEST['hash']);
    
    list($param_loc, $requestpay) = explode("&", $hash_decryp);
    if (isset($param_loc)) {
        list($key_loc, $value_loc) = explode("=", $param_loc);
    }
    
    if (isset($requestpay)) {
        list($key_requestpay, $value_requestpay) = explode("=", $requestpay);
    }
    
    if ($value_requestpay == 1) {
        $localizador = $value_loc;
        
        $sql_localizador = " SELECT l.*,s.actividad_id,r.sala_horario_id,sh.fecha as fecha_visita,sh.hora_inicio as hora_inicio
                             FROM localizadores l, servicios s, reservas r, sala_horarios sh
                             WHERE l.localizador = :localizador
                             AND l.servicio_id=s.id
                             AND r.localizador = l.localizador
                             AND r.sala_horario_id=sh.id";

        $result_localizador = $conexion->prepare($sql_localizador);
        $result_localizador->execute(array(':localizador' => $localizador));

        if ($result_localizador != null && $result_localizador->rowCount() > 0) {
            

            $row_localizador = $result_localizador->fetch();

            $nombre             = $row_localizador['nombre'];
            $apellidos          = $row_localizador['apellido'];
            $telefono           = $row_localizador['telefono'];
            $dni                = isset($row_localizador['dni']) ? $row_localizador['dni'] : '';
            $email              = $row_localizador['email'];
            $recibir_correo     = isset($row_localizador['recibir_correo']) ? $row_localizador['recibir_correo'] : null;
            $condiciones_compra = 'on';
            $tipo_compra        = $row_localizador['servicio_id'];
            $pago_instalacion   = 0; //el pago no puede realizarse en la instalación
            $ong                = '';

            $tipo_pago         = $row_localizador['tipo_pago'];
            $pago_seleccionado = $tipo_pago;

            $campos_extra = "si";

            $plazas_adulto   = $row_localizador['plazas_adulto'];
            $plazas_infantil = isset($row_localizador['plazas_infantil']) ? $row_localizador['plazas_infantil'] : null;
            $web             = 1;
            $idioma          = $row_localizador['idioma'];

            if ($idioma == 2) {
                $lang = 'en_GB';
                $VOLVER = $domainLink . '/en/visits';
            } else if ($idioma == 3) {
                $lang = 'fr_FR';
                $VOLVER = $domainLink . '/fr/visites';
            } else {
                $lang = 'es_ES';
                $VOLVER = $domainLink . '/visitas';
            }

            define('LANGJS', $lang);

            // save language preference for future page requests
            $language->setSessionLang($lang);

            $_SESSION["lang"] = $lang;

            $lang .= '.utf8';
            putenv("LANG=" . $lang);
            // IMPORTANTE: ESTABLECER SOLO LC_MESSAGES ¡MESSAGES! Que si no se lía con los decimales
            setlocale(LC_MESSAGES, $lang);

            $directory = dirname(__FILE__) . '/Locale';

            // Instalación
            $instalacion = $row_localizador['instalacion_id'];

            // Actividad
            $actividad = $row_localizador['actividad_id'];

            // Carrito
            $precio_total = $row_localizador['total'];
            $usuarios     = $row_localizador['pases_totales'];

            // Datos servicio seleccionado
            $servicio        = $row_localizador['servicio_id'];
            $sala_horario_id = $row_localizador['sala_horario_id'];

            if (!empty($row_localizador['otra_tarifa'])) {
                $tarifa = '';
                $lista  = $row_localizador['plazas_adulto'];
            } else {

                $tarifa      = '';
                $tarifas     = '';
                $lista       = '';
                $sql_tarifas = "SELECT * FROM localizador_tarifas
                                WHERE localizador = :localizador ";

                $result_tarifas = $conexion->prepare($sql_tarifas);
                $result_tarifas->execute(array(':localizador' => $localizador));

                foreach ($result_tarifas->fetchAll() as $row_tarifa) {
                    $tarifas .= $row_tarifa['tarifa_id'] . ",";
                    $lista .= $row_tarifa['plazas_adulto'] . ",";
                }
                $tarifa = substr($tarifas, 0, -1);
                $lista  = substr($lista, 0, -1);
            }

            $hora_inicio   = $row_localizador['hora_inicio'];
            $fechacreacion = $row_localizador['fecha_creacion'];
            $fechavisita   = strtotime($row_localizador['fecha_visita']);
            $fechatope     = strtotime('+48 hour', strtotime($fechacreacion));
            $fechahoy      = strtotime(date('Y-m-j'));

            

            if ($row_localizador['estado'] != 'pagado' && $fechatope >= $fechahoy && $fechavisita >= $fechahoy && ($row_localizador['tipo_pago'] == 37 || $row_localizador['tipo_pago'] == 38)) {
        
                // Actualizamos el estado del localizador a pendiente_pago por exigencias del guión
                $update_localizador_estado = 'UPDATE localizadores set estado = "pendiente_pago" WHERE localizador = "' . $localizador . '"';
                $conexion->query($update_localizador_estado);

                if ($row_localizador['bono'] != '') {
                    $existe_bono = true;

                    $sql_bono = "select * from bonos where codigo = :bono ";

                    $result_bono = $conexion->prepare($sql_bono);
                    $result_bono->execute(array(':bono' => $row_localizador['bono']));

                    if ($result_bono != null && $result_bono->rowCount() > 0) {
                        $row_bono    = $result_bono->fetch();
                        $nombre_bono = $row_bono['codigo'];

                    }

                } else {
                    $existe_bono = false;
                }

                $LocalizadorSalaHorario = $sala_horario_id;
                $LocalizadorActividad   = $actividad;
                $LocalizadorServicio    = $servicio;
                $LocalizadorInstalacion = $instalacion;
                $LocalizadorTarifas     = $tarifa;
                $LocalizadorUnidades    = $plazas_adulto;

                $LocalizadorIdiomaId   = $idioma;
                $pago                  = $tipo_pago;
                $actividadSeleccionada = !empty($_POST['actividadSeleccionada']) ? $_POST['actividadSeleccionada'] : '';
                $actividadSeleccionada = $actividad;
                $fecha                 = $fechavisita;
                $hora                  = $hora_inicio;
                $plazas                = $plazas_adulto;
                $prepago               = 1;

                $TEXTENOTURISMO = _('Enoturismo');

                
                // PHP con los textos estáticos de la plantilla
                require_once DIRLANGUAGESTRINGS . 'compra/api/compra_api.php';
                require_once DIRLANGUAGESTRINGS . 'compra/api/confirmar_compra_api.php';
                
                // Cargamos el archivo de plantilla propio
                require_once DIRLANGUAGETEMPLATES . "compra/api/confirmar_compra_api.ctp";
              
            } else {    
                
                // PHP con los textos estáticos de la plantilla
                require_once DIRLANGUAGESTRINGS . 'compra_finalizada/nok.php';
                $texto_error = $TEXTLOCALIZADORCADUCADO;

                // Compruebo si es móvil para cargar los css
                if (is_mobile()) {
                    $RUTACSS = 'movil/compras_reservas.css';
                } else {
                    $RUTACSS = 'compras_reservas.css';
                }


                $RAIZ        = DOMINIO;
                $sesion_lang = $language->getSessionLang();
                $lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

                $protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
                $domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

                $translated_form_action_contacta = $language->getFormActionTranslation('reserva_web/formulario_visitas.tpl_contacto', true);
                $form_action_contacta            = isset($translated_form_action_contacta) ? $translated_form_action_contacta : 'contacto-enoturismo';
                $ENLACECONTACTA                  = URL_FRONT_PRINCIPAL . '/' . $form_action_contacta;

                $translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver', true);
                $form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : 'visitas';
                $IR_A_ENOTURISMO               = $domainLink . '/' . $form_action_volver;

                require_once DIRLANGUAGETEMPLATES . "compra/api/error_prepago.ctp";
            }
            
        } else {           
            
            // PHP con los textos estáticos de la plantilla
            require_once DIRLANGUAGESTRINGS . 'compra_finalizada/nok.php';
            $texto_error = $TEXTSINLOCALIZADOR;

            // Compruebo si es móvil para cargar los css
            if (is_mobile()) {
                $RUTACSS = 'movil/compras_reservas.css';
            } else {
                $RUTACSS = 'compras_reservas.css';
            }


            $RAIZ        = DOMINIO;
            $sesion_lang = $language->getSessionLang();
            $lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

            $protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
            $domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

            $translated_form_action_contacta = $language->getFormActionTranslation('reserva_web/formulario_visitas.tpl_contacto', true);
            $form_action_contacta            = isset($translated_form_action_contacta) ? $translated_form_action_contacta : 'contacto-enoturismo';
            $ENLACECONTACTA                  = URL_FRONT_PRINCIPAL . '/' . $form_action_contacta;

            $translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver', true);
            $form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : 'visitas';
            $IR_A_ENOTURISMO               = $domainLink . '/' . $form_action_volver;

            require_once DIRLANGUAGETEMPLATES . "compra/api/error_prepago.ctp";
        }

    }

}
