<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/**************    Include cabecera  ***********************************/
require_once dirname(__DIR__) . '/principal_compra_reserva.php';

require DIRLIBCOMP . 'autoload.php';

// Pulled from the .env file and upper cased e.g. SANDBOX, PRODUCTION.
$upper_case_environment = strtoupper(getenv('ENVIRONMENT'));

// Carga de plantilla
$RAIZ     = DOMINIO;
$RAIZ_URL = DIRECCIONPROYECTO;

$time_now = strtotime(date('Y-m-d H:i'));
$TIMENOW  = $time_now;

// PHP con los textos estáticos de la plantilla
require_once DIRLANGUAGESTRINGS . 'reserva_web/formulario_productos.php';

// Recogemos los datos por post que nos llegan desde el carrito

if (!empty($_POST['productos'])) {
    $total_compra = 0;
    $mesa         = $_POST['mesa'];
    $productos    = $_POST['productos'];
    $texto_mesa   = $_POST['texto-mesa'];
    $cupon        = $_POST['datos_cupon'];
    $servicio_id  = $_POST['servicio_id'];

    $productos_array = explode(",", $productos);

    foreach ($productos_array as $producto) {
        //Obtenemos el precio de la tarifa desde la base de datos
        $sql_precio = "SELECT  sp.precio
                       FROM productos p
                       JOIN servicios_productos sp on p.id = sp.producto_id
                       where p.id = :producto
                       and sp.servicio_id = :servicio_id ";

        $result_precio = $conexion->prepare($sql_precio);
        $result_precio->execute(array(':producto' => $producto, ':servicio_id' => $servicio_id));

        if ($result_precio->rowCount() > 0) {
            $row_precio = $result_precio->fetch();

            $total_compra += $row_precio['precio'];
        } else {
            //Si no existe el producto no continuamos

        }
    }
    $total_compra = number_format($total_compra, 2);

    $MESA           = $mesa;
    $TEXTOMESA      = $texto_mesa;
    $PRODUCTOS      = $productos;
    $TOTALCOMPRA    = $total_compra;
    $TOTALPRODUCTOS = sizeof(explode(",", $productos));

    if (!empty($cupon)) {
        $tCuponCompra     = true;
        $CUPON            = $cupon;
        $APLICADO         = 1;
        $DESCUENTO        = $_POST['datos_descuento'];
        $tDescuentoCompra = true;
        $total            = $total_compra - abs(floatval($_POST['datos_descuento']));
        $TOTAL            = number_format($total, 2);
    } else {
        $tCuponCompra     = false;
        $APLICADO         = 0;
        $tDescuentoCompra = false;
        $TOTAL            = number_format($total_compra, 2);
    }

    if ((int) $mesa == 0) {
        $TEXTSUSDATOSPERSONALESCOMPLETO = 'Tus datos';
    } else {
        $TEXTSUSDATOSPERSONALESCOMPLETO = 'Tus datos - MESA ' . $mesa;
    }

    // Si tenemos las cookies de las cosas ...
    $valor_nombre     = '';
    $valor_apellido   = '';
    $valor_telefono   = '';
    $valor_email      = '';
    $valor_asistentes = '';
    if (isset($_COOKIE['m_i_nombre']) && !empty($_COOKIE['m_i_nombre'])) {
        $valor_nombre = $_COOKIE['m_i_nombre'];
    }
    if (isset($_COOKIE['m_i_apellidos']) && !empty($_COOKIE['m_i_apellidos'])) {
        $valor_apellido = $_COOKIE['m_i_apellidos'];
    }
    if (isset($_COOKIE['m_i_telefono']) && !empty($_COOKIE['m_i_telefono'])) {
        $valor_telefono = $_COOKIE['m_i_telefono'];
    }
    if (isset($_COOKIE['m_i_email']) && !empty($_COOKIE['m_i_email'])) {
        $valor_email = $_COOKIE['m_i_email'];
    }
    if (isset($_COOKIE['m_i_url']) && !empty($_COOKIE['m_i_url'])) {
        $url_volver = $_COOKIE['m_i_url'];
    } else {
        $url_volver = '/gastro-bar/';
    }
    if (isset($_COOKIE['m_i_asistentes']) && !empty($_COOKIE['m_i_asistentes'])) {
        $valor_asistentes = $_COOKIE['m_i_asistentes'];
    }

    $URLVOLVER = $url_volver;

    $VALORNOMBRE      = $valor_nombre;
    $VALORAPELLIDOS   = $valor_apellido;
    $VALORTELEFONO    = $valor_telefono;
    $VALOREMAIL       = $valor_email;
    $VALORASISTENTES  = $valor_asistentes;

    //https://sis.redsys.es/sis/realizarPago
    $REDSYSIR = RedsysServer;

    // Obtenemos los datos del servicio
    $sql_servicios = "SELECT s.*, i.idioma
                      FROM servicios s
                      JOIN servicios_idiomas si on si.servicio_id=s.id
                      JOIN idiomas i on i.id=si.idioma_id
                      WHERE s.activo = 1
                      AND s.id = :servicio_id ";

    $result_servicios = $conexion->prepare($sql_servicios);
    $result_servicios->execute(array(':servicio_id' => $servicio_id));

    // Si no hay error en la consulta
    if ($result_servicios != null && $result_servicios->rowCount() > 0) {
        $row_servicio = $result_servicios->fetch();
        $CONDICIONES  = $row_servicio['condiciones_servicio'];

        $SERVICIOID    = $row_servicio['id'];
        $INSTALACIONID = $row_servicio['instalacion_id'];

        // Obtención de información relacionada con la compra
        // Lógica para la carga de campos de usuario
        require_once DIRMODULOSCOMP . 'otros/campos.php';

        // TIPOS DE PAGO // FORMAS DE PAGO

        // Muestro tarifas genéricas asociadas al servicio
        $sql_tipos_pago = "SELECT p.*
                           FROM tipos_pagos p JOIN servicios_pagos sp ON p.id = sp. pago_id
                           AND servicio_id = :servicio_id ";

        $result_tipos_pago = $conexion->prepare($sql_tipos_pago);
        $result_tipos_pago->execute(array(':servicio_id' => $row_servicio['id']));

        $CHECKEDPAGO = '';
        if ($result_tipos_pago->rowCount() > 0) {

            $tOpcionesCompra = true;
            $array_pagos     = array();
            foreach ($result_tipos_pago->fetchAll() as $row_tipo_pago) {

                $PAGOTIPO = $language->getString($row_tipo_pago['pago'], true);

                $pago_tipo_class = str_replace(" ", "_", $row_tipo_pago['pago']);
                $pago_tipo_class = str_replace(
                    array('á', 'é', 'í', 'ó', 'ú', 'Á', 'É', 'Í', 'Ó', 'Ú'),
                    array('a', 'e', 'i', 'o', 'u', 'a', 'e', 'i', 'o', 'u'),
                    $pago_tipo_class);
                $PAGOTIPOCLASS = strtolower($pago_tipo_class);

                $IDPAGO = $row_tipo_pago['id'];

                if ($row_tipo_pago['imagen'] != '') {
                    $PAGOIMAGEN = ENLACEIMAGEN . $row_tipo_pago['imagen'];
                }
                // Volver carrito
                if (isset($_POST['pago_seleccionado'])) {
                    if ($row_tipo_pago['id'] == $pago_seleccionado) {
                        $CHECKEDPAGO = 'checked';
                    }
                }

                $array_pagos[$IDPAGO]['PAGOTIPO']      = $PAGOTIPO;
                $array_pagos[$IDPAGO]['PAGOTIPOCLASS'] = $PAGOTIPOCLASS;
                $array_pagos[$IDPAGO]['IDPAGO']        = $IDPAGO;
                $array_pagos[$IDPAGO]['PAGOIMAGEN']    = $PAGOIMAGEN;
                $array_pagos[$IDPAGO]['CHECKEDPAGO']   = $CHECKEDPAGO;

            }

        } else {
            $tOpcionesCompra = false;
            $tipo_pago       = '';
            $TIPOPAGO        = $tipo_pago;
        }

        $translated_form_condiciones = $language->getFormActionTranslation('compra/compra.tpl_condiciones');
        $form_condiciones            = isset($translated_form_condiciones) ? $translated_form_condiciones : 'condiciones-de-reserva-de-visitas';

        $HREFCONDICIONES = $form_condiciones;

        // TEXTOS SECCIÓN (GENERALES Y DE SERVICIO)
        $section_message = 'comprar_paso_1';

        $tContenidoCompraReserva = true;
    } else {
        $tContenidoCompraReserva = false;
    }
} else {
    header("Location: /gastro-bar/");
}

// Establecemos en función del lenguaje seleccionado el js con los textos
$sesion_lang    = $language->getSessionLang();
$lang           = (isset($sesion_lang) ? $sesion_lang : 'es_ES');
$LANGJS         = $lang;
$TEXTENOTURISMO = $language->getString('Enoturismo');

$protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];
$URLHOME    = $domainLink;

require_once DIRLANGUAGETEMPLATES . "reserva_web/enoexperiencia_producto.ctp";
