<?php

// Iniciamos session
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/error_log_confirmar.txt');
error_reporting(E_ALL);

/**
 *   Includes
 */
require_once dirname(__DIR__) . '/../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRLIBCOMP . 'registro_logs.php';
require_once DIRLIBCOMP . 'KLogger.php';

/**
 *   Conectamos a la BD
 */
global $conexion;
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*******************************************************************
 * TRADUCCIONES
 *******************************************************************/
require_once DIRLIBCOMP . 'clases/lang.php';
$language = new lang();

$sesion_lang = $language->getUrlLang();
$lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');
define('LANGJS', $lang);

/**
 * Inicializamos el logger
 */
$logger = new KLogger(DIRLOG . "klogger/log.txt", KLogger::DEBUG);

/****************************************************************
Cargamos datos del entorno multilenguaje
 ****************************************************************/
require_once dirname(__DIR__) . '/../config_language.php';

/*****************************************************************
 * Mensajes del sistema
 *****************************************************************/
require_once DIRLIBCOMP . 'clases/messages.php';
$message = new messages();

if (isset($_SESSION['numero_operacion'])) {
    //Comprobamos si la compra se ha pagado y se ha realizado con exito
    $numero_operacion = $_SESSION['numero_operacion'];

    // A partir del número de operacion que tenemos buscamos a através del histórico cuál es el actual, por aquello de los desvíos
    $sql_historico = "SELECT l.*
                      FROM localizadores l
                      JOIN localizador_pedidos lp on l.localizador = lp.localizador
                      WHERE lp.id_pedido = $numero_operacion";
    $result_historico = $conexion->query($sql_historico);

    if ($result_historico->rowCount() > 0) {
        $row = $result_historico->fetch();

        $numero_operacion = $row['id_pedido'];
        $estado_actual    = $row['estado'];
        $idioma           = $row['idioma'];
    }

    if($estado_actual != 'pagado'){
        $sentencia      = "Compra finalzada ok OPERACION - " . $numero_operacion . " - Estado no pagado espera 5s ";
        Insertar_Sentencia($sentencia, 'compra');

        //Esperamos 5 segundos. Puede ser que aun no tengamos la respuesta de la plataforma de pago
        sleep(5);
        
    }else{
        $sentencia      = "Compra finalzada ok OPERACION - " . $numero_operacion . " - Estado pagado, se omite espera 5s ";
        Insertar_Sentencia($sentencia, 'compra');
    }

    // Fin de la comprobación de los históricos
    $sql_tpv = "SELECT tpv.*,localizador.*, ins.google_maps
                FROM Redsys tpv JOIN localizadores localizador ON tpv.localizador = localizador.localizador
                JOIN instalaciones ins on localizador.instalacion_id = ins.id
                AND tpv.estado = 'pagado' AND tpv.Ds_MerchantData = " . $numero_operacion;

    $result_tpv = $conexion->query($sql_tpv);

    $sql_paypal = "SELECT paypal.*,localizador.*, ins.google_maps
                   FROM Paypal paypal JOIN localizadores localizador ON paypal.localizador = localizador.localizador
                   JOIN instalaciones ins on localizador.instalacion_id = ins.id
                   AND paypal.invoice = " . $numero_operacion;

    $result_paypal = $conexion->query($sql_paypal);

    // Si la compra se ha realizado con exito, le mostrara la pagina del OK
    if ($result_tpv->rowCount() > 0 || $result_paypal->rowCount() > 0) {

        // Recuperamos informacion de la compra
        $info = ($result_tpv->rowCount() > 0) ? $result_tpv->fetch() : $result_paypal->fetch();
   
        // PHP con los textos estáticos de la plantilla
        require_once DIRLANGUAGESTRINGS . 'compra_finalizada_extra/ok.php';
        require_once DIRLANGUAGESTRINGS . 'modificar/modificar_api.php';
        require_once DIRLANGUAGESTRINGS . 'compra_finalizada_extra/confirmar_compra_api.php';

        // Compruebo si es móvil para cargar los css
        if (is_mobile()) {
            $RUTACSS = 'movil/compras_reservas.css';
        } else {
            $RUTACSS = 'compras_reservas.css';
        }

        if ($info['regalo']) {
            $tBloqueRegalo   = 1;
            $tBotonImprimir  = 0;
            $tBloqueNoRegalo = 0;
        } else {
            $tBloqueRegalo   = 0;
            $tBotonImprimir  = 1;
            $tBloqueNoRegalo = 1;
        }

        $TEXTGOOGLEMAPS    = $info['google_maps'];
        $TEXTSTRGOOGLEMAPS = $language->getString('Ver ubicación en google maps');

        // Variables del template iniciales
        $RAIZ             = DOMINIO;
        $localizador      = $info['localizador'];


        $NOMBRE           = $info['nombre'];
        $APELLIDOS        = $info['apellido'];
        $TELEFONO         = $info['telefono'];
        $EMAIL            = $info['email'];
        $SERVICIOID       = $info['servicio_id'];
        $FECHAID          = $info['sala_horario_id'];
        $HORAID           = $info['sala_horario_id'];
        $PLAZAS           = $info['unidades'];
        if($result_tpv->rowCount() > 0 ){
            $PRICE            = number_format($info['Ds_Amount'] / 100, 2, ".", ",");
        }else{
            $PRICE            = number_format($info['mc_gross'] , 2, ".", ",");
        }
        $DOMINIOPRINCIPAL = DOMINIOPRINCIPAL;

        $telefono = $info['telefono'];
        $email    = $info['email'];

        if ($email != '') {
            $tCorreo = 1;
            $EMAIL   = $email;
        } else {
            $tCorreo = 0;
        }


        // DESCUENTOS O COSTES
        $servicio       = $info['servicio_id'];
        $forma_pago     = $info['tipo_pago'];
        $paso           = "mostrar";
    
        // PORCENTAJE PAGO PARCIAL
        $paso = 'mostrar';

        // TEXTOS SECCIÓN (GENERALES Y DE SERVICIO)
        $section_message = 'comprar_paso_3';
        $servicio_texto  = $info['servicio_id'];

        // Precio total final
        $precio_total       = sprintf('%0.2f', $info['total']);
        $TOTALPRECIOCARRITO = $precio_total . ' €';

        // Precio total (se le han podido aplicar descuentos)
        $total              = sprintf('%0.2f', $info['total']);
        $TOTALPRECIOCARRITO = $total . ' €';
        $TOTALPRECIO        = $total;

        // TIPO DE PAGO SELECCIONADO
        $sql_tipo_pago = "SELECT *
                          FROM tipos_pagos
                          WHERE id = " . $info['tipo_pago'];

        $result_tipo_pago = $conexion->query($sql_tipo_pago);
        $row_tipo_pago    = $result_tipo_pago->fetch();
        $tipo_pago        = $language->getString($row_tipo_pago['pago'], true);

        $PAGOSELECCIONADO = $tipo_pago;

        /**
         * INFORMACIÓN DE LA COMPRA
         */
        // SERVICIO
        // Traducción datos servicio
        $product_lang = $language->getStringsProduct($info['servicio_id']);

        $sql_servicio = "SELECT s.*, a.id as actividad_id, a.nombre as actividad_nombre
                         FROM servicios s JOIN actividades a ON s.actividad_id = a.id
                         AND s.id = " . $info['servicio_id'];

        $result_servicio = $conexion->query($sql_servicio);

        if ($result_servicio->rowCount() > 0) {
            $row_servicio = $result_servicio->fetch(PDO::FETCH_ASSOC);

            $SERVICIO = $row_servicio['nombre'];

            // Muestro cŕeditos si es servicio de descuento de créditos
            // para bonos
            if ($row_servicio['creditos'] == 1) {
                $tCreditos         = 1;
                $CREDITOSTOTALES   = $info['pases_totales'];
                $CREDITOSRESTANTES = $info['servicio_pases'];
            } else {
                $tCreditos = 0;
            }

            // Busco servicio reservado de horas valle
            $tipo_compra      = '';
            $actividad_nombre = $row_servicio['actividad_nombre'];
            $actividad        = $row_servicio['actividad_nombre'];

            $sql_hValle = "SELECT s.id
                           FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
                           JOIN servicios s ON ss.servicio_id = s.id
                           AND r.localizador like '" . $info['localizador'] . "'
                           JOIN actividades a ON s.actividad_id = a.id
                           AND s.horas_valle = 1
                           AND s.actividad_id = " . $row_servicio['actividad_id'];

            $result_hValle = $conexion->query($sql_hValle);

            if ($result_hValle->rowCount() > 0) {
                $row_hValle = $result_hValle->fetch();

                $tipo_compra = $row_hValle['id'];
            }
            // Busco servicio reservado de pistas
            else {
                $sql_pistas = "SELECT s.id
                               FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
                               JOIN servicios s ON ss.servicio_id = s.id
                               AND r.localizador like '" . $info['localizador'] . "'
                               JOIN actividades a ON s.actividad_id = a.id
                               AND s.pistas = 1
                               AND s.actividad_id = " . $row_servicio['actividad_id'];

                $result_pistas = $conexion->query($sql_pistas);

                if ($result_pistas->rowCount() > 0) {
                    $row_pista = $result_pistas->fetch();

                    $tipo_compra = $row_pista['id'];
                }

            }

            $ACTIVIDADID           = $row_servicio['actividad_id'];
            $NOMBRESERVICIORESERVA = $product_lang['nombre'];

            $servicio = $product_lang['nombre'];

            $NOMBRESERVICIOCOMPRA = $product_lang['nombre'];

            $translated_form_action_imprimir = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_imprimir');
            $form_action_imprimir            = isset($translated_form_action_imprimir) ? $translated_form_action_imprimir : 'imprimir_compra';

            $ACTIONIMPRIMIR = $form_action_imprimir;
        }

        // INSTALACIÓN
        $sql_instalacion = "SELECT * FROM instalaciones
                            WHERE id = " . $row_servicio['instalacion_id'];

        $result_instalacion = $conexion->query($sql_instalacion);

        if ($result_instalacion->rowCount() > 0) {
            $row_instalacion   = $result_instalacion->fetch(PDO::FETCH_ASSOC);
            $NOMBREINSTALACION = $row_instalacion['nombre'];
        }

        // CAMPOS EXTRA
        $sql_campos_extra = "SELECT c.*, lc.value
                             FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
                             AND c.type NOT LIKE 'checkbox'
                             AND c.nombre NOT LIKE 'Observaciones'
                             AND lc.localizador = '" . $info['localizador'] . "'";

        $result_campos_extra = $conexion->query($sql_campos_extra);

        if ($result_campos_extra->rowCount() > 0) {

            $campos_extra = array();

            foreach ($result_campos_extra->fetchAll() as $row_campo) {
                $NOMBRECAMPOEXTRA = $language->getString($row_campo['nombre'], true);
                $VALORCAMPOEXTRA  = $row_campo['value'];
                $tCamposExtra     = 1;
            }
        } else {
            $tCamposExtra = 0;
        }

        // Compruebo si ha comprado y reservado o sólo ha comprado un servicio
        if ($info['sala_horario_id'] != 0) {
            // FECHA Y HORA
            // Me quedo con id hora, que tiene la fecha y hora seleccionadas
            $sql_fecha_hora = "SELECT *
                               FROM sala_horarios WHERE id = " . $info['sala_horario_id'];

            $result_fecha_hora = $conexion->query($sql_fecha_hora);

            if ($result_fecha_hora->rowCount() > 0) {
                $row_fecha_hora = $result_fecha_hora->fetch(PDO::FETCH_ASSOC);
                $FECHARESERVA   = cambiaf_a_normal($row_fecha_hora['fecha']);

                $hora_inicio = strtotime($row_fecha_hora['hora_inicio']);
                $hora_inicio = date("H:i", $hora_inicio);
                $hora_fin    = strtotime($row_fecha_hora['hora_fin']);
                $hora_fin    = date("H:i", $hora_fin);
                $HORARESERVA = $hora_inicio;
            }

            // Compruebo si la compra y primera reserva es de "masajes"
            // en cuyo caso muestro información de reserva del balneario
            // Si es masajes busco si hay reserva para balneario
            // Compruebo instalación de la reserva
            $sql_balneario_instalacion = "SELECT hora_balneario, instalacion_id
                                          FROM reservas
                                          WHERE localizador = '" . $info['localizador'] . "'";

            $result_balneario_instalacion = $conexion->query($sql_balneario_instalacion);

            if ($result_balneario_instalacion->rowCount() > 0) {
                $row_bal_instalacion = $result_balneario_instalacion->fetch(PDO::FETCH_ASSOC);

                // Instalación, caso de bonos multiinstalación como frontones
                if ($row_bal_instalacion['instalacion_id'] != null) {

                    $sql_instalacion = "SELECT *
                                        FROM instalaciones
                                        WHERE id = " . $row_bal_instalacion['instalacion_id'];

                    $result_instalacion = $conexion->query($sql_instalacion);

                    if ($result_instalacion->rowCount() > 0) {
                        $row_instalacion   = $result_instalacion->fetch(PDO::FETCH_ASSOC);
                        $NOMBREINSTALACION = $row_instalacion['nombre'];
                    }
                }
            }
        } else {
            $tDatosReserva = 0;
        }

        // Boton volver

        if ($info['regalo']) {
            // Boton volver
            $translated_form_action_volver = $language->getFormActionTranslation('reserva_web/formulario_visitas.tpl_volver_regalar', true);
            $form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : 'regalar';
            $VOLVER                        = $form_action_volver;
            $tPassbook                     = 0;
        } else {
            // Boton volver
            $translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver', true);
            $form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : 'visitas';

            $VOLVER    = $form_action_volver;
            $tPassbook = 1;
        }
        $localizador_padre = substr( $localizador , 0 , 6);   
        $hash_misextras    = encriptar("l=" . $localizador_padre . "&requestpay=1&fecha=". $FECHARESERVA );          

    
        if(  $idioma  == 1){
            $url_misextras_raiz =  '/tusvisitas/?misextras';
        }else if( $idioma == 2 ){
            $url_misextras_raiz =  '/en/yourvisits/?misextras';
        }elseif( $idioma == 3){
            $url_misextras_raiz =  '/fr/tusvisitas/?misextras';
        }else{
            $url_misextras_raiz =  '/tusvisitas/?misextras';
        }

        require_once DIRLANGUAGETEMPLATES . "compra_finalizada_extra/ok.ctp";
    }

    // Sino le mostrara la pagina del NOK
    else {

        // PHP con los textos estáticos de la plantilla
        require_once DIRLANGUAGESTRINGS . 'compra_finalizada_extra/nok.php';

        // Compruebo si es móvil para cargar los css
        if (is_mobile()) {
            $RUTACSS = 'movil/compras_reservas.css';
        } else {
            $RUTACSS = 'compras_reservas.css';
        }

        $RAIZ        = DOMINIO;
        $sesion_lang = $language->getSessionLang();
        $lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

        $protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
        $domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

        $translated_form_action_contacta = $language->getFormActionTranslation('reserva_web/formulario_visitas.tpl_contacto', true);
        $form_action_contacta            = isset($translated_form_action_contacta) ? $translated_form_action_contacta : 'contacto-enoturismo';
        $ENLACECONTACTA                  = URL_FRONT_PRINCIPAL . '/' . $form_action_contacta;

        $translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver', true);
        $form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : 'visitas';
        $IR_A_ENOTURISMO               = $domainLink . '/' . $form_action_volver;

        require_once DIRLANGUAGETEMPLATES . "compra_finalizada_extra/nok.ctp";

    }
} else {

    // PHP con los textos estáticos de la plantilla
    require_once DIRLANGUAGESTRINGS . 'compra_finalizada_extra/nok_ups.php';

    // Compruebo si es móvil para cargar los css
    if (is_mobile()) {
        $RUTACSS = 'movil/compras_reservas.css';
    } else {
        $RUTACSS = 'compras_reservas.css';
    }

    $RAIZ        = DOMINIO;
    $sesion_lang = $language->getSessionLang();
    $lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

    $protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
    $domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

    $translated_form_action_contacta = $language->getFormActionTranslation('reserva_web/formulario_visitas.tpl_contacto', true);
    $form_action_contacta            = isset($translated_form_action_contacta) ? $translated_form_action_contacta : 'contacto-enoturismo';
    $ENLACECONTACTA                  = URL_FRONT_PRINCIPAL . '/' . $form_action_contacta;

    $translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver', true);
    $form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : 'visitas';
    $IR_A_ENOTURISMO               = $domainLink . '/' . $form_action_volver;

    require_once DIRLANGUAGETEMPLATES . "compra_finalizada_extra/nok_ups.ctp";
}

// output the results
