<?php
require_once DIRLIBCOMP . 'autoload.php';

ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/email.txt');
error_reporting(E_ALL);

use Passbook\PassFactory;
use Passbook\Pass\Barcode;
use Passbook\Pass\Field;
use Passbook\Pass\Image;
use Passbook\Pass\Structure;
use Passbook\Type\EventTicket;

// OBTENGO INFORMACIÓN DE LA COMPRA
$sql_localizador = "SELECT l.*, s.pases, s.creditos, tp.pago, i.idioma
                    FROM localizadores l
                    JOIN servicios s ON l.servicio_id = s.id
                    JOIN tipos_pagos as tp ON l.tipo_pago = tp.id
                    JOIN idiomas as i on i.id = l.idioma
                    WHERE l.localizador = :localizador ";

$result_localizador = $conexion->prepare($sql_localizador);
$result_localizador->execute(array(
    ':localizador' => $localizador,
));

if ($result_localizador->rowCount() > 0) {
    $row_localizador = $result_localizador->fetch(PDO::FETCH_ASSOC);

    $servicio         = $row_localizador['servicio_id'];
    $idpedido         = $row_localizador['id_pedido'];
    $idioma_visita    = $row_localizador['idioma'];
    $tipo_pago        = $row_localizador['pago'];
    $nombre           = $row_localizador['nombre'];
    $apellidos        = $row_localizador['apellido'];
    $telefono         = $row_localizador['telefono'];
    $email            = $row_localizador['email'];
    $fecha_compra     = cambiaf_a_normal($row_localizador['fecha_compra']);
    $pago_instalacion = $row_localizador['pago_instalacion'];
    $total            = sprintf('%0.2f', $row_localizador['total']);
    $total            = $total . ' €';
}

// Compruebo si es servicio de pistas
$language = new Lang();

// Datos reserva anulada
// Traducción datos servicio
$product_lang = $language->getStringsProduct($servicio);

//Datos reserva original
$sql_reservaanulada = "SELECT sh.fecha, sh.hora_inicio, sh.hora_fin, s.nombre
                       FROM sala_horarios sh
                       JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                       JOIN servicios s ON ss.servicio_id = s.id
                       AND ss.servicio_id = :servicio
                       AND sh.id = :sala_horario_id ";

$result_reservaanulada = $conexion->prepare($sql_reservaanulada);
$result_reservaanulada->execute(array(
    ':servicio'        => $servicio,
    ':sala_horario_id' => $sala_horario_id,
));

if ($result_reservaanulada->rowCount() > 0) {
    $row_anulada = $result_reservaanulada->fetch(PDO::FETCH_ASSOC);

    $hora_inicio     = strtotime($row_anulada['hora_inicio']);
    $hora_inicio     = date("H:i", $hora_inicio);
    $hora_fin        = strtotime($row_anulada['hora_fin']);
    $hora_fin        = date("H:i", $hora_fin);
    $horario_anulada = $hora_inicio;

    $fecha_anulada    = cambiaf_a_normal($row_anulada['fecha']);
    $servicio_anulado = $product_lang['nombre'];
    $servicio_ant     = $row_anulada['nombre'];
}

// Datos nueva reserva
$sql_nuevareserva = "SELECT sh.fecha, sh.hora_inicio, sh.hora_fin, s.nombre
                     FROM sala_horarios sh
                     JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                     JOIN servicios s ON ss.servicio_id = s.id
                     AND ss.servicio_id = :servicio
                     AND sh.id = :fechaId ";

$result_nuevareserva = $conexion->prepare($sql_nuevareserva);
$result_nuevareserva->execute(array(
    ':servicio' => $servicio,
    ':fechaId'  => $fechaId,
));

if ($result_nuevareserva->rowCount() > 0) {
    $row_reserva = $result_nuevareserva->fetch(PDO::FETCH_ASSOC);

    $hora_inicio     = strtotime($row_reserva['hora_inicio']);
    $hora_inicio     = date("H:i", $hora_inicio);
    $hora_fin        = strtotime($row_reserva['hora_fin']);
    $hora_fin        = date("H:i", $hora_fin);
    $horario_reserva = $hora_inicio;

    $fecha_reserva_nueva = cambiaf_a_normal($row_reserva['fecha']);
    $servicio_nuevo      = $row_anulada['nombre'];
}

$protocol   = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];
$loc_encryp = encriptar($localizador);

if ($row_localizador['web'] == 1) {
    $ruta_qr = $domainLink . '/wp-content/plugins/visitas/modules/visitas/reservas/images/QR/';
} else {
    $ruta_qr = DOMRESERVAS . 'img/QR/';
}

$cupon_correo = "";
if ($row_localizador['bono'] != '') {
    $sql_cupon_correo    = "SELECT * FROM bonos WHERE codigo = '" . $row_localizador['bono'] . "' ";
    $result_cupon_correo = $conexion->query($sql_cupon_correo);

    if ($result_cupon_correo->rowCount() > 0) {
        $cupon_correo = $result_cupon_correo->fetch(PDO::FETCH_ASSOC);
        if (!$cupon_correo['porcentual']){
            $cupon_correo['cantidad']= number_format($cantidad_descuento,2);    
        }
        
    }
}

// TEXTOS PARA EL EMAIL
$section_message = 'email_modificacion';
$servicio_texto  = $servicio;
$message         = new messages();
require_once DIRMODULOSCOMP . 'otros/messages_email_pdf.php';

require_once DIRLIBCOMP . 'mail/PHPMailer.php';
require_once DIRLIBCOMP . 'mail/SMTP.php';
require_once DIRLIBCOMP . 'mail/Exception.php';

$mail = new PHPMailer\PHPMailer\PHPMailer( true );

$correo = obtenerDatosCorreo();

// -----------SMTP--------------
// Con PluginDir le indicamos a la clase phpmailer donde se
// encuentra la clase smtp que como he comentado al principio de
// este ejemplo va a estar en el subdirectorio includes
$mail->CharSet   = "UTF-8";
// $mail->PluginDir = "";
// Con la propiedad Mailer le indicamos que vamos a usar un servidor smtp
$mail->Mailer = "smtp";
// Le indicamos el content-type HTML
$mail->isHTML(true);
$mail->SMTPSecure = 'tls';
// Asignamos a Host el nombre de nuestro servidor smtp
$mail->Host = MAILHOST;
// Le indicamos que el servidor smtp requiere autenticación
$mail->SMTPAuth = MAILSMTPAUTH;
// Le decimos cual es nuestro nombre de usuario y password
$mail->Username = $correo['user'] ?? MAILUSER;
$mail->Password = $correo['pass'] ?? MAILPASS;
// Asignamos a Host el nombre de nuestro servidor smtp
$mail->Port = MAILPORT;
$mail->From = $correo['mail'] ?? MAILFROM;
// $mail->AddCustomHeader('Reply-to:informacion.bodegas@pruebajig.es');
//$mail->SMTPDebug = 2;

$mail->FromName = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($instalacion, "UTF-8", mb_detect_encoding($instalacion))) . "=?=";
//para que coja la 'ñ';
$mail->Subject = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($language->getString('Reserva Modificada', true) . ' - ' . $instalacion, "UTF-8", mb_detect_encoding($language->getString('Reserva Modificada', true) . ' - ' . $instalacion))
) . "=?=";

//Paso de datos a la plantilla
$compra = array(
    'localizador'                   => !empty($localizador) ? $localizador : '',
    'localizador_extra'             => !empty($localizador_extra) ? $localizador_extra : '',
    'nombre'                        => !empty($nombre) ? $nombre : '',
    'apellidos'                     => !empty($apellidos) ? $apellidos : '',
    'telefono'                      => !empty($telefono) ? $telefono : '',
    'email'                         => !empty($email) ? $email : '',
    'fecha_compra'                  => !empty($fecha_compra) ? $fecha_compra : '',
    'servicio_anulado'              => !empty($servicio_anulado) ? $servicio_anulado : '',
    'servicio'                      => !empty($product_lang['nombre']) ? $product_lang['nombre'] : '',
    'pago_instalacion'              => !empty($pago_instalacion) ? $pago_instalacion : '',
    'fecha_reserva'                 => !empty($fecha_reserva_nueva) ? $fecha_reserva_nueva : '',
    'horario_reserva'               => !empty($horario_reserva) ? $horario_reserva : '',
    'unidades_tarifa'               => !empty($arrTarifas) ? $arrTarifas : array(),
    'tarifas_nombre'                => !empty($arrTarifasNombre) ? $arrTarifasNombre : array(),
    'plazas'                        => !empty($plazas_total) ? $plazas_total : array(),
    'precios'                       => !empty($arrTarifasPrecio) ? $arrTarifasPrecio : array(),
    'condiciones_servicio'          => !empty($product_lang['condiciones_servicio']) ? $product_lang['condiciones_servicio'] : '',
    'domainLink'                    => !empty($domainLink) ? $domainLink : '',
    'loc_encryp'                    => !empty($loc_encryp) ? $loc_encryp : '',
    'ruta_qr'                       => !empty($ruta_qr) ? $ruta_qr : '',
    'extras_seleccionados'          => !empty($extras_seleccionados) ? $extras_seleccionados : '',
    'id_pedido'                     => !empty($idpedido) ? $idpedido : '',
    'idioma_visita'                 => !empty($idioma_visita) ? $idioma_visita : '',
    'creditos'                      => !empty($creditos) ? $creditos : '',
    'pago_seleccionado'             => !empty($tipo_pago) ? $tipo_pago : '',
    'campos_extra'                  => !empty($campos_extra) ? $campos_extra : array(),
    'horario'                       => !empty($horario_reserva) ? $horario_reserva : '',
    'plazas_ant'                    => !empty($total_antes_unidades) ? $total_antes_unidades : '',
    'total'                         => !empty($precio_total) ? $precio_total : '',
    'id_pedido'                     => !empty($idpedido) ? $idpedido : '',
    'fecha_reserva_ant'             => !empty($fecha_anulada) ? $fecha_anulada : '',
    'horario_ant'                   => !empty($horario_anulada) ? $horario_anulada : '',
    'servicio_ant'                  => !empty($servicio_ant) ? $servicio_ant : '',
    'servicio_nuevo'                => !empty($servicio_nuevo) ? $servicio_nuevo : '',
    'precios_ant'                   => !empty($arrTarifasPrecioAnt) ? $arrTarifasPrecioAnt : array(),
    'tarifas_nombre_ant'            => !empty($arrTarifasNombre) ? $arrTarifasNombre : array(),
    'unidades_tarifa_ant'           => !empty($arrTarifasUnidades) ? $arrTarifasUnidades : array(),
    'extras_seleccionados_ant'      => !empty($extras_seleccionados_ant) ? $extras_seleccionados_ant : array(),
    'descuento_coste_realizado'     => isset($descuento_coste_realizado) ? $descuento_coste_realizado : 0,
    'descuento_coste'               => isset($descuento_coste) ? $descuento_coste : 0,
    'pago_parcial'                  => isset($pago_parcial) ? $pago_parcial : '',
    'tipo_aplicado'                 => !empty($tipo_aplicado) ? $tipo_aplicado : '',
    'descuento_coste_realizado_ant' => !empty($descuento_coste_realizado_ant) ? $descuento_coste_realizado_ant : '',
    'descuento_coste_ant'           => !empty($descuento_coste_ant) ? $descuento_coste_ant : '',
    'pago_parcial_ant'              => !empty($pago_parcial_ant) ? $pago_parcial_ant : '',
    'total_ant'                     => !empty($total_ant) ? $total_ant : 0,
    'cupon'                         => !empty($cupon_correo) ? $cupon_correo : '',
    'instalacion_mapa'              => !empty($instalacion_mapa) ? $instalacion_mapa : '',
    'instalacion_descripcion'       => !empty($instalacion_descripcion) ? $instalacion_descripcion : '',
    'instalacion_prepago'           => !empty($instalacion_pregago) ? $instalacion_pregago : '',
    'instalacion'                   => !empty($instalacion) ? $instalacion : '',
    'instalacion_ant'               => !empty($instalacion) ? $instalacion : '',
    'cantidad_descuento_anterior'   => !empty($cantidad_descuento_anterior) ? $cantidad_descuento_anterior : '',
    'total_reembolsado'             => !empty($format_cantidad_a_devolver) ? $format_cantidad_a_devolver : '',
    'condiciones_extra'             => !empty($condiciones_extra) ? $condiciones_extra : '',
    

);

// generatePKPass($compra);

ob_start();
require DIRLIBCOMP . 'mail/plantillas_correo/' . (!empty($_SESSION["visitas_lang"]) ? $_SESSION["visitas_lang"] : 'es_ES')  . '/correo_modificar_extras.php'; //Plantilla de correo

$body = ob_get_contents();
ob_end_clean();

$mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
$mail->Body    = $body;

$emails_debug = (array)json_decode($_ENV['MAIL_TO_NOTIFY_DEBUG'],true);
//Envío de correo
if (is_array($emails_debug) === true) {
    foreach ($emails_debug as $email_ua => $email_data) {        
        $destinatarios[] = array(
            'nombre' => $email_data['nombre'],
            'email'  => $email_data['email']);
    }
}

if (ENVIRONMENT == 'production') {
    // Nosotros
    $emails_notify = (array)json_decode($_ENV['MAIL_TO_NOTIFY'],true);

    if (is_array($emails_notify) === true) {
        foreach ($emails_notify as $email_ua => $email_data) {        
            $destinatarios[] = array(
                'nombre' => $email_data['nombre'],
                'email'  => $email_data['email']);
        }
    }
    
    // Cliente
    if ($email != '') {
        $email_ua        = $email;
        $destinatarios[] = array(
            'nombre' => $nombre,
            'email'  => $email,
        );
    }
}

if (is_array($destinatarios) === true) {
    foreach ($destinatarios as $destino) {

        $mail->AddAddress($destino['email'], $destino['nombre']);
        if ($mail->Send()) {
            //return true;

        } else {
            //return false;
        }
        $mail->ClearAddresses();
    }
}

function generatePKPass($compra)
{   
    $OUTPUT_PATH = PASSBOOK_OUTPUT_PATH_BASE . $compra['localizador'];

    // Create an event ticket
    $pass = new EventTicket($compra['localizador'], html_entity_decode(strip_tags($compra['servicio'])));

    $pass->setBackgroundColor('rgb(239, 239, 239)'); //color de fondo
    $pass->setForegroundColor('rgb(123,131,134)'); //color del texto
    $pass->setLabelColor('rgb(181,143,98)'); //color de las etiquetas

    $image = new Image(PASSBOOK_ICON_FILE, 'logo');
    $image->setDensity(2);
    $pass->addImage($image);

    $image2 = new Image(PASSBOOK_BACKGROUND_FILE, 'strip');
    $pass->addImage($image2);

    // Create pass structure
    $structure = new Structure();

    $header = new Field('header', '');
    $header->setLabel($compra['fecha_reserva']);
    $header->setValue($compra['horario']);
    $structure->addHeaderField($header);

    $secondary = new Field('event', html_entity_decode(strtoupper(($compra['servicio']))));
    $secondary->setLabel('Enoexperiencia');
    $structure->addSecondaryField($secondary);

    // Add auxiliary field
    $auxiliary = new Field('plazas', $compra['plazas']);
    $auxiliary->setLabel('Plazas');
    $structure->addAuxiliaryField($auxiliary);

    // Add auxiliary field
    $auxiliary = new Field('total', $compra['total'] . "€");
    $auxiliary->setLabel('Total');
    $structure->addAuxiliaryField($auxiliary);

    // Add icon image
    $icon = new Image(PASSBOOK_ICON_FILE, 'icon');
    $pass->addImage($icon);

    // Set pass structure
    $pass->setStructure($structure);

    // Add barcode
    $barcode = new Barcode(Barcode::TYPE_QR, $compra['localizador']);
    $pass->setBarcode($barcode);

    $backfile = new Field('nombre', html_entity_decode(strip_tags($compra['nombre'] . " " . $compra['apellidos'])));
    $backfile->setLabel('Nombre');
    $structure->addBackField($backfile);

    $backfile = new Field('email', html_entity_decode(strip_tags($compra['email'])));
    $backfile->setLabel('Email');
    $structure->addBackField($backfile);

    $backfile = new Field('lugar', html_entity_decode(strip_tags($compra['instalacion'])));
    $backfile->setLabel('Lugar');
    $structure->addBackField($backfile);

    $backfile = new Field('idioma', html_entity_decode(strip_tags($compra['idioma_visita'])));
    $backfile->setLabel('Idioma');
    $structure->addBackField($backfile);

    // Create pass factory instance
    $factory = new PassFactory(
        PASSBOOK_PASS_TYPE_IDENTIFIER,
        PASSBOOK_TEAM_IDENTIFIER,
        PASSBOOK_ORGANIZATION_NAME,
        PASSBOOK_P12_FILE,
        PASSBOOK_P12_PASSWORD,
        PASSBOOK_WWDR_FILE);
    $factory->setOutputPath($OUTPUT_PATH);

    $factory->package($pass);

    return $OUTPUT_PATH;
}
