<?php
// Iniciamos session
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/../error_log_confirmar.txt');
error_reporting(E_ALL);

/**
 *   Includes
 */
require_once dirname(__DIR__) . '/../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIBCOMP . 'funciones.php';

/**
 *   Conectamos a la BD
 */
global $conexion;
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*******************************************************************
 * TRADUCCIONES
 *******************************************************************/
require_once DIRLIBCOMP . 'clases/lang.php';
$language = new lang();

/****************************************************************
Cargamos datos del entorno multilenguaje
 ****************************************************************/
require_once dirname(__DIR__) . '/../config_language.php';

// PHP con los textos estáticos de la plantilla
require_once DIRLANGUAGESTRINGS . 'compra_finalizada_extra/nok.php';

// Compruebo si es móvil para cargar los css
if (is_mobile()) {
    $RUTACSS = 'movil/compras_reservas.css';
} else {
    $RUTACSS = 'compras_reservas.css';
}

$RAIZ        = DOMINIO;
$sesion_lang = $language->getSessionLang();
$lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

$protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

$translated_form_action_contacta = $language->getFormActionTranslation('reserva_web/formulario_visitas.tpl_contacto', true);
$form_action_contacta            = isset($translated_form_action_contacta) ? $translated_form_action_contacta : 'contacto-enoturismo';
$ENLACECONTACTA                  = URL_FRONT_PRINCIPAL . '/' . $form_action_contacta;

$translated_form_action_volver = $language->getFormActionTranslation('compra/pago_instalacion_fin.tpl_volver', true);
$form_action_volver            = isset($translated_form_action_volver) ? $translated_form_action_volver : 'visitas';
$IR_A_ENOTURISMO               = $domainLink . '/' . $form_action_volver;

require_once DIRLANGUAGETEMPLATES . "compra_finalizada/nok.ctp";


$RAIZ = DOMINIO;
unset($_SESSION['numero_operacion']);
