<?php

//PHP con los textos estáticos de la plantilla
require_once DIRLANGUAGESTRINGS . 'factura/solicitud_factura_api.php';

$translated_form_action = $language->getFormActionTranslation('factura/solicitud_factura.tpl');
$form_action            = isset($translated_form_action) ? $translated_form_action : 'solicitud-de-factura';

$RAIZ             = DOMINIO;
$DOMINIOPRINCIPAL = DOM;
$FORMULARIO       = $form_action;

$lang                   = (isset($sesion_lang) ? $sesion_lang : 'es_ES');
$translated_form_action = $language->getFormActionTranslation('factura/solicitud_factura.tpl_volver');
$form_action            = isset($translated_form_action) ? $translated_form_action : 'solicitar-factura';

$FORMULARIO_VOLVER = '/' . $form_action;

// Compruebo si es móvil para cargar los css
if (is_mobile()) {
    $RUTACSS = 'compras_reservas.css';
} else {
    $RUTACSS = 'compras_reservas.css';
}

// LOCALIZADOR
$LOCALIZADOR = $localizador;

$sql_info = "SELECT l.*,sh.fecha, sh.hora_inicio
			 FROM localizadores l
             JOIN reservas r on l.localizador = r.localizador
             JOIN sala_horarios sh ON r.sala_horario_id = sh.id      
			 WHERE l.localizador = :localizador ";

$result_info = $conexion->prepare($sql_info);
$result_info->execute(array( ':localizador' => $localizador));

if ($result_info->rowCount() > 0) {

    $row_info = $result_info->fetch();

    $NOMBRE     = $row_info['nombre'];
    $APELLIDOS  = $row_info['apellido'];
    $TELEFONO   = $row_info['telefono'];
    $SERVICIOID = $row_info['servicio_id'];
    $FECHA      = $row_info['fecha'];
    $HORA       = $row_info['hora_inicio'];
    $PLAZAS     = $row_info['plazas_adulto'];

    if ($row_info['email'] != '') {
        //$tpl->touchBlock('tEmailInfo');
        //$tpl->hideBlock('tEmailCompletar');

        $EMAIL = $row_info['email'];
    }
    /*else {
    	$tpl->touchBlock('tEmailCompletar');
    	$tpl->hideBlock('tEmailInfo');
    }*/

    $PLAZASADULTO = $row_info['plazas_adulto'];

    if ($row_info['plazas_infantil'] != 0) {
        $PLAZASINFANTIL = $row_info['plazas_infantil'];
    } else {
        $tPlazasInfantil = 0;
        // $tpl->hideBlock('tPlazasInfantil');
    }

    // INFO DEL SERVICIO COMPRADO
    $sql_servicio = "SELECT s.nombre as nombreS, i.nombre as nombreI
					 FROM servicios s JOIN instalaciones i ON s.instalacion_id = i.id
					 AND s.id = " . $row_info['servicio_id'];

    $result_servicio = $conexion->query($sql_servicio);

    if ($result_servicio->rowCount() > 0) {
        $row_servicio = $result_servicio->fetch();

        $NOMBRESERVICIO    = $row_servicio['nombreS'];
        $NOMBREINSTALACION = $row_servicio['nombreI'];
    }

    //CAMPOS EXTRA
    $sql_campos_extra = "SELECT DISTINCT c.*, lc.value
						 FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
						 AND c.type NOT LIKE  'checkbox'
						 AND lc.value != ''
						 AND lc.localizador = '" . $localizador . "'";

    $result_campos_extra = $conexion->query($sql_campos_extra);

    if ($result_campos_extra->rowCount() > 0) {

        $campos_extra = array();
        $where        = " AND sc.campo_id NOT IN (";

        foreach ($result_campos_extra->fetchAll() as $row_campo) {
            $NOMBRECAMPOEXTRA = $language->getString($row_campo['nombre']);
            $VALORCAMPOEXTRA  = $row_campo['value'];
            if($row_campo['type'] == 'textarea') $CLASSCAMPOEXTRA = 'textarea-full';
            else $CLASSCAMPOEXTRA = "";

            // Añado condición para que al buscar los que faltan no se añadan
            // los que ya están
            $where .= "'" . $row_campo['id'] . "',";
 
            array_push($campos_extra , array(
                "nombre" => $NOMBRECAMPOEXTRA,
                "valor"  => $VALORCAMPOEXTRA,
                "css"    => $CLASSCAMPOEXTRA,
            ));
        

            // $tpl->parse('tCamposExtra');
        }
        $where .= "'') ";
    } else {
        $tCamposExtra = 0;
        // $tpl->hideBlock('tCamposExtra');
    }

    // CAMPOS EXTRA PARA EL SERVICIO QUE FALTAN POR RELLENAR PARA LA FACTURA
    // Lógica para la carga de campos de usuario
    // require_once DIRMODULOSCOMP . 'otros/campos_factura.php';

    $sql_campos_extra_label = "SELECT
                				DISTINCT
                					c.id as campo_id,
                					c.nombre as campo_nombre,
                					c.descripcion as campo_descripcion,
                					c.archivo as campo_archivo,
                					c.type as campo_type,
                					c.input_id as input_id,
                					c.campo_tipo_id as campo_tipo_id,
                					ct.nombre as campo_tipo_nombre,
                					sc.es_obligatorio,
                					(
                						select count(*) > 0
                						from campos_options co
                						where co.campo_id = c.id
                					) as tiene_opciones
                				FROM campos c JOIN servicio_campos sc
                					ON c.id = sc.campo_id left join campo_tipos ct
                					ON ct.id = c.campo_tipo_id
                				WHERE
                					c.type NOT LIKE  'checkbox'
                					AND sc.servicio_id = " . $row_info['servicio_id'] . "
                					AND c.factura = 1
                					" . $where . "
                					ORDER BY c.orden ASC";

    // $result_campos_extra_label = $conexion->query($sql_campos_extra_label);

    // if ($result_campos_extra_label->rowCount() > 0) {
    //     foreach ($result_campos_extra_label->fetchAll() as $row_campo_label) {
    //         // Cargamos el campo en la plantilla
    //         cargaCampo($tpl, $row_campo_label, $conexion, $language);

    //         $tpl->parse('tCamposExtraLabel');
    //     }
    // } else {
    //     $tpl->hideBlock('tCamposExtraLabel');
    // }

}

//Cargamos el archivo de plantilla propio
require_once DIRLANGUAGETEMPLATES . "factura/solicitud_factura.ctp";
