<?php

//PHP con los textos estáticos de la plantilla
require_once DIRLANGUAGESTRINGS . 'factura/solicitud_factura_finalizada.php';

$RAIZ = DOMINIO;

$lang                   = (isset($sesion_lang) ? $sesion_lang : 'es_ES');
$translated_form_action = $language->getFormActionTranslation('factura/solicitud_factura_finalizada.tpl_volver');
$form_action            = isset($translated_form_action) ? $translated_form_action : 'solicitar-factura';

$DOMINIOPRINCIPAL  = DOM;
$FORMULARIO_VOLVER = '/' . $form_action;
$RUTACSS           = 'compras_reservas.css';

//Info de la compra
$sql_info = "SELECT l.*, s.pases, s.creditos, tp.pago, i.idioma
             FROM localizadores l
             JOIN servicios s ON l.servicio_id = s.id
             JOIN tipos_pagos as tp ON l.tipo_pago = tp.id
             JOIN idiomas as i on i.id = l.idioma
             WHERE l.localizador = '" . $localizador . "'";

$result_info = $conexion->query($sql_info);
$row_info    = $result_info->fetch();

$nombre             = $row_info['nombre'];
$apellidos          = $row_info['apellido'];
$telefono           = $row_info['telefono'];
$email              = $row_info['email'];
$creditos_totales   = $row_info['pases_totales'];
$creditos_restantes = $row_info['servicio_pases'];
$servicio_id        = $row_info['servicio_id'];
$plazas             = $row_info['unidades'];
$plazas_adulto      = $row_info['plazas_adulto'];
$plazas_infantil    = $row_info['plazas_infantil'];
$total              = sprintf('%0.2f', $row_info['total']);
$total              = $total . ' €';
$idpedido           = $row_info['id_pedido'];
$idioma_visita      = $row_info['idioma'];
$tipo_pago          = $row_info['pago'];
$fecha_compra       = $row_info['fecha_compra'];
$pago_instalacion   = $row_info['pago_instalacion'];
    

// Servicio comprado
$sql_servicio = "SELECT s.nombre as nombreS, i.nombre as nombreI, i.id, i.descripcion as instalacion_descripcion, i.google_maps as instalacion_mapa, i.enlace_prepago
				 FROM servicios s JOIN instalaciones i ON s.instalacion_id = i.id
				 AND s.id = " . $servicio_id;

$result_servicio = $conexion->query($sql_servicio);
$row_servicio    = $result_servicio->fetch();

$servicio       = $row_servicio['nombreS'];
$instalacion    = $row_servicio['nombreI'];
$instalacion_id = $row_servicio['id'];

// Reserva realizada
$sql_reserva = "SELECT r.*, sh.fecha, sh.hora_inicio, r.fecha_reserva
				FROM reservas r JOIN sala_horarios sh ON r.sala_horario_id = sh.id
				AND r.localizador = '" . $localizador . "'";

$result_reserva = $conexion->query($sql_reserva);
$row_reserva    = $result_reserva->fetch();

$fecha_reserva           = cambiaf_a_normal($row_reserva['fecha']);
$hora_inicio             = date("H:i", strtotime($row_reserva['hora_inicio']));
$fecha_realizada_reserva = date("d/m/Y", strtotime($row_reserva['fecha_reserva']));

// INFORMACIÓN DE LA RESERVA A ANULAR
$sql_reserva_facturar = "SELECT r.unidades, r.sala_horario_id, 
                        s.pases, s.condiciones_servicio,
                        ss.servicio_id, s.s_instalacion, s.pistas
                       FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
                       JOIN servicios s ON ss.servicio_id = s.id
                       AND localizador = '" . $localizador . "'
                       AND ss.servicio_id = " . $servicio_id . "
                       AND r.id = " . $row_reserva['id'];

$result_reservas_facturar = $conexion->query($sql_reserva_facturar);

if ($result_reservas_facturar->rowCount() > 0) {
    $row_facturar = $result_reservas_facturar->fetch(PDO::FETCH_ASSOC);

    // Oculto plazas para las instalaciones
    if ($row_facturar['s_instalacion'] == 0) {
        // Saco el numero de plazas de esa reserva
        $sql_tarifas_localizador = "SELECT lt.plazas_adulto
                                    FROM localizador_tarifas lt
                                    JOIN localizadores l ON l.localizador = lt.localizador
                                    WHERE l.localizador = '" . $localizador . "'";

        $result_tarifas_localizador = $conexion->query($sql_tarifas_localizador);

        $plazas_totales_localizador = 0;
        if ($result_tarifas_localizador->rowCount() > 0) {
            foreach ($result_tarifas_localizador as $row_tarifa_localizador) {
                $plazas_totales_localizador += $row_tarifa_localizador['plazas_adulto'];
            }
        }

        $unidades = $plazas_totales_localizador;
    } else {
        $unidades = '';
    }

    $horario              = $row_facturar['sala_horario_id'];
    $pistas               = $row_facturar['pistas'];
    $condiciones_servicio = $row_facturar['condiciones_servicio'];
}

// DATOS RESERVA FACTURADA
$sql_reserva = "SELECT sh.*, i.nombre as nombreI
                FROM sala_horarios sh JOIN salas sa ON sh.sala_id = sa.id
                JOIN instalaciones i ON sa.instalacion_id = i.id
                AND sh.id = " . $horario;

$result_reserva = $conexion->query($sql_reserva);
if ($result_reserva->rowCount() > 0) {
    $row_reserva = $result_reserva->fetch(PDO::FETCH_ASSOC);

    $hora_inicio = strtotime($row_reserva['hora_inicio']);
    $hora_inicio = date("H:i", $hora_inicio);
    $hora_fin    = strtotime($row_reserva['hora_fin']);
    $hora_fin    = date("H:i", $hora_fin);
    $horario     = $hora_inicio;

    $fecha = cambiaf_a_normal($row_reserva['fecha']);
}

$tarifas_nombre  = array();
$precios         = array();
$unidades_tarifa = array();

// Muestro información de las tarifas seleccionadas
$sql_tarifa_carrito = "SELECT lt.*, ug.nombre, t.precio, t.pago_grupo, t.usuarios_grupo_id
                       FROM localizador_tarifas lt JOIN tarifas t ON lt.tarifa_id = t.id
                       JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
                       AND lt.localizador = '" . $localizador . "'";

$result_tarifa_carrito = $conexion->query($sql_tarifa_carrito);

if ($result_tarifa_carrito->rowCount() > 0) {
    while ($row_tarifa = $result_tarifa_carrito->fetch(PDO::FETCH_ASSOC)) {

        $nombre_tarifa    = $row_tarifa['nombre'];
        $tarifas_nombre[] = $language->getString($nombre_tarifa, true);

        // Precio con dos decimales
        // Compruebo si precio es por grupo o por persona
        if ($row_tarifa['pago_grupo'] == 0) {
            $precio = $row_tarifa['precio'] * $row_tarifa['plazas_adulto'];
        } else {
            $precio = $row_tarifa['precio'];
        }

        $precio            = sprintf('%0.2f', $precio);
        $precios[]         = (float)$precio;
        $unidades_tarifa[] = $row_tarifa['plazas_adulto'];
    }

}

// CAMPOS EXTRA
$sql_campos_extra = "SELECT DISTINCT c.*, lc.value
					 FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
					 AND c.type NOT LIKE 'checkbox'
					 AND lc.localizador = '" . $localizador . "'";

$result_campos_extra = $conexion->query($sql_campos_extra);

if ($result_campos_extra->rowCount() > 0) {

    $campos_extra = array();

    foreach ($result_campos_extra->fetchAll() as $row_campo) {
        $campos_extra[] = '<strong>' . $language->getString($row_campo['nombre']) . ': </strong>' . $row_campo['value'] . '<br/>';
    }
} else {
    $campos_extra = '';
}

//TEXTOS PARA EL EMAIL
$servicio_texto  = $servicio_id;
$section_message = 'email_reserva';
require_once DIRMODULOSCOMP . 'otros/messages_email_pdf.php';

//Cargamos el archivo de plantilla propio
require_once DIRLANGUAGETEMPLATES . "factura/solicitud_factura_finalizada.ctp";