<?php

//Guardo log de errores
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/imprimir.txt');
error_reporting(E_ALL & ~E_DEPRECATED);

date_default_timezone_set('Europe/Madrid');

require_once '../../config.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRLIBCOMP . 'SPDO.php';

/****************************************************************
Conectamos a la BD
 *****************************************************************/
global $conexion;
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*******************************************************************
 * TRADUCCIONES
 *******************************************************************/
require_once DIRCLASS . 'lang.php';
$language = new lang();

/*****************************************************************
 * Mensajes del sistema
 *****************************************************************/
require_once DIRCLASS . 'messages.php';
$message = new messages();

//Obtengo fecha de compra y número de unidades reservadas
$sql_localizador = "SELECT *
                    FROM localizadores
                    WHERE localizador = '" . $_POST['localizador'] . "'";

$result_localizador = $conexion->query($sql_localizador);

if ($result_localizador->rowCount() > 0) {
    $row_localizador = $result_localizador->fetch(PDO::FETCH_ASSOC);

    // Idioma
    $_SESSION["lang"]         = $language->getUrlLang();
    $_SESSION["visitas_lang"] = $language->getUrlLang();

    if (!empty($row_servicio) && $row_servicio['pases'] > 1) //si es bono
    {
        $plazas = $_POST['plazas'];

        // Muestro cŕeditos si es servicio de descuento de créditos
        // para bonos
        $creditos           = $row_servicio['creditos'];
        $creditos_totales   = $row_localizador['pases_totales'];
        $creditos_restantes = $row_localizador['servicio_pases'];

    } else // es entrada, el número de plazas es el número de unidades compradas
    {
        $plazas = $row_localizador['unidades'];

        // Créditos si es servicio de créditos y es bono
        $creditos = 0;
    }

    $fecha_compra    = cambiaf_a_normal($row_localizador['fecha_compra']);
    $id_pedido       = $row_localizador['id_pedido'];
    $plazas_adulto   = $row_localizador['plazas_adulto'];
    $plazas_infantil = $row_localizador['plazas_infantil'];

}

// TARIFAS
$sql_loc_taf = "SELECT *
                FROM localizador_tarifas
                WHERE localizador = '" . $_POST['localizador'] . "' and plazas_adulto > 0";

$result_loc_taf = $conexion->query($sql_loc_taf);

if ($result_loc_taf->rowCount() > 0) {

    $result_loc_taf = $result_loc_taf->fetch();

    $tarifas_nombre  = array();
    $precios         = array();
    $unidades_tarifa = array();

    //Muestro información de las tarifas seleccionadas
    $sql_tarifa_carrito = "SELECT lt.*, ug.nombre, t.precio, t.pago_grupo, t.usuarios_grupo_id
                           FROM localizador_tarifas lt JOIN tarifas t ON lt.tarifa_id = t.id
                           JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
                           AND lt.localizador = '" . $row_localizador['localizador'] . "' and lt.plazas_adulto > 0";

    $result_tarifa_carrito = $conexion->query($sql_tarifa_carrito);

    if ($result_tarifa_carrito->rowCount() > 0) {
        while ($row_tarifa = $result_tarifa_carrito->fetch(PDO::FETCH_ASSOC)) {

            $grupo_usuarios   = $row_tarifa['usuarios_grupo_id'];
            $nombre_tarifa    = $row_tarifa['nombre'];
            $tarifas_nombre[] = $language->getString($nombre_tarifa, true);

            //Precio con dos decimales
            //Compruebo si precio es por grupo o por persona
            if ($row_tarifa['pago_grupo'] == 0) {
                $precio = $row_tarifa['precio'] * $row_tarifa['plazas_adulto'];
            } else {
                $precio = $row_tarifa['precio'];
            }

            $precio = sprintf('%0.2f', $precio);
            if ($precio == 0) {
                $precio = $language->getString('Gratuito', true);
            } else {
                $precio = (int) $precio;
            }
            $precios[]         = $precio;
            $unidades_tarifa[] = $row_tarifa['plazas_adulto'];
        }
    }

} else {
    $tarifas_nombre = '';
}

// DESCUENTOS O COSTES
$servicio     = $row_localizador['servicio_id'];
$forma_pago   = $row_localizador['tipo_pago'];
$paso         = 'email_pdf';
$precio_total = $precio; // Precio total de la tarifa sin descuento
if ($grupo_usuarios) {
    // require_once DIRMODULOSCOMP . 'compra/descuentos_costes.php';
}

// Precio total final
$precio_total = sprintf('%0.2f', $row_localizador['total']);

// PORCENTAJE PAGO PARCIAL
require_once DIRMODULOSCOMP . 'compra/pago_parcial.php';

// INFORMACIÓN DE LA COMPRA
// ACTIVIDAD
$sql_actividad = "SELECT nombre
                  FROM actividades
                  WHERE id = " . $_POST['actividadSeleccionada'];

$result_actividad = $conexion->query($sql_actividad);

if ($result_actividad->rowCount() > 0) {
    $row_actividad    = $result_actividad->fetch(PDO::FETCH_ASSOC);
    $actividad_nombre = $row_actividad['nombre'];
}

//Busco servicio reservado de horas valle
$tipo_compra = '';
$sql_hValle  = "SELECT s.id
                FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
                JOIN servicios s ON ss.servicio_id = s.id
                AND r.localizador like '" . $_POST['localizador'] . "'
                JOIN actividades a ON s.actividad_id = a.id
                AND s.horas_valle = 1
                AND s.actividad_id = " . $_POST['actividadSeleccionada'];

$result_hValle = $conexion->query($sql_hValle);

if ($result_hValle->rowCount() > 0) {
    $row_hValle = $result_hValle->fetch();

    $tipo_compra = $row_hValle['id'];
} else {
    //Es servicio de pistas
    $sql_pistas = "SELECT s.id
                   FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
                   JOIN servicios s ON ss.servicio_id = s.id
                   AND r.localizador like '" . $_POST['localizador'] . "'
                   JOIN actividades a ON s.actividad_id = a.id
                   AND s.pistas = 1
                   AND s.actividad_id = " . $_POST['actividadSeleccionada'];

    $result_pistas = $conexion->query($sql_pistas);

    if ($result_pistas->rowCount() > 0) {
        $row_pistas = $result_pistas->fetch();

        $tipo_compra = $row_pistas['id'];
    }
}

// SERVICIO
// Traducciones
$product_lang = $language->getStringsProduct($_POST['servicio']);

$sql_servicio = "SELECT *
                 FROM servicios
                 WHERE id = " . $_POST['servicio'];

$result_servicio = $conexion->query($sql_servicio);

if ($result_servicio->rowCount() > 0) {
    $row_servicio = $result_servicio->fetch(PDO::FETCH_ASSOC);

    $servicio_nombre_reserva = $product_lang['nombre'];
    $servicio_nombre_compra  = $product_lang['nombre'];
    $condiciones_servicio    = $product_lang['condiciones_servicio'];

}

// Compra + reserva de horas valle (compra bono o entrada, reserva
// servicio de horas valle)
if ($tipo_compra != '') {
    $sql_servicio = "SELECT * FROM servicios WHERE id = " . $tipo_compra;

    $result_servicio = $conexion->query($sql_servicio);

    if ($result_servicio->rowCount() > 0) {
        $row_servicio = $result_servicio->fetch(PDO::FETCH_ASSOC);

        $servicio_nombre_compra = $row_servicio['nombre'] . ' - ' . $actividad_nombre;
    }
}

// INSTALACIÓN
$sql_instalacion = "SELECT * FROM instalaciones
                    WHERE id = " . $row_servicio['instalacion_id'];

$result_instalacion = $conexion->query($sql_instalacion);

if ($result_instalacion->rowCount() > 0) {
    $row_instalacion = $result_instalacion->fetch(PDO::FETCH_ASSOC);

    $instalacion_nombre = $row_instalacion['nombre'];
}

// Compruebo si ha comprado y reservado o sólo ha comprado un servicio
if ($_POST['fecha'] != 0) {
    // FECHA Y HORA
    // Me quedo con id hora, que tiene la fecha y hora seleccionadas
    $sql_fecha_hora = "SELECT *
                       FROM sala_horarios
                       WHERE id = " . $_POST['fecha'];

    $result_fecha_hora = $conexion->query($sql_fecha_hora);

    if ($result_fecha_hora->rowCount() > 0) {
        $row_fecha_hora = $result_fecha_hora->fetch(PDO::FETCH_ASSOC);

        $fecha = cambiaf_a_normal($row_fecha_hora['fecha']);

        $hora_inicio = date("H:i", strtotime($row_fecha_hora['hora_inicio']));
        $hora_fin    = date("H:i", strtotime($row_fecha_hora['hora_fin']));
        $hora        = $hora_inicio;
    }

    // Compruebo si la compra y primera reserva es de "masajes"
    // en cuyo caso muestro información de reserva del balneario
    $sql_reserva = "SELECT hora_balneario, instalacion_id
                    FROM reservas
                    WHERE localizador like '" . $_POST['localizador'] . "'";

    $result_reserva = $conexion->query($sql_reserva);

    if ($result_reserva->rowCount() > 0) {

        $row_reservabal_instalacion = $result_reserva->fetch();

        // Balneario
        $horario_balneario = $row_reservabal_instalacion['hora_balneario'];

        // Instalación, caso de bonos multiinstalación como frontones
        if ($row_reservabal_instalacion['instalacion_id'] != null) {

            $sql_instalacion = "SELECT *
                                FROM instalaciones
                                WHERE id = " . $row_reservabal_instalacion['instalacion_id'];

            $result_instalacion = $conexion->query($sql_instalacion);

            if ($result_instalacion->rowCount() > 0) {
                $row_instalacion = $result_instalacion->fetch(PDO::FETCH_ASSOC);

                $instalacion_nombre      = $row_instalacion['nombre'];
                $instalacion             = $row_instalacion['nombre'];
                $instalacion_mapa        = $row_instalacion['google_maps'];
                $instalacion_prepago     = $row_instalacion['enlace_prepago'];
                $instalacion_descripcion = $row_instalacion['descripcion'];
            }
        }
    }

}

// OPCIONES SELECCIONADAS PARA LA VISITA SI LAS HAY
$sql_opciones_reserva = "SELECT c.nombre as nombreC, co.nombre as nombreOp
                         FROM reservas r JOIN reserva_caracteristicas rc ON r.id = rc.reserva_id
                         JOIN caracteristicas_opciones co ON rc.caracteristica_opcion_id = co.id
                         JOIN caracteristicas c ON rc.caracteristica_id = c.id
                         AND r.localizador = '" . $_POST['localizador'] . "'";

$result_opciones_reserva = $conexion->query($sql_opciones_reserva);

if ($result_opciones_reserva->rowCount() > 0) {

    $opciones_seleccionadas = array();

    foreach ($result_opciones_reserva->fetchAll() as $row_caracteristica_opcion) {
        $opciones_seleccionadas[] = '<strong>' . $language->getString($row_caracteristica_opcion['nombreC']) . ' : </strong>' . $row_caracteristica_opcion['nombreOp'];
    }
} else {
    $opciones_seleccionadas = '';
}

$sql_campos_extra = "SELECT DISTINCT c.*, lc.value
                     FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
                     AND c.type NOT LIKE 'checkbox'
                     AND c.nombre NOT LIKE 'Observaciones'
                     AND lc.localizador = '" . $_POST['localizador'] . "'
                     UNION (
                            SELECT c.*, lc.value
                            FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
                            AND (c.type like 'checkbox' AND c.nombre like '%comida%')
                            AND lc.localizador = '" . $_POST['localizador'] . "'
                        )";

$result_campos_extra = $conexion->query($sql_campos_extra);

if ($result_campos_extra->rowCount() > 0) {

    $campos_extra = array();

    foreach ($result_campos_extra->fetchAll() as $row_campo) {

        $valor = $row_campo['value'];
        if ($valor == 'on') {
            $valor = $language->getString('Sí');
        }

        if ($valor == '0') {
            $valor = 'No';
        }

        $campos_extra[] = '<span>' . strtoupper($language->getString($row_campo['nombre'], true)) . ' : </span><span style="font-style: italic;">' . $valor . '</span>';
    }
} else {
    $campos_extra = '';
}

// IDIOMA DE LA VISITA
$sql_idioma_visita = "SELECT i.idioma, i.id
                      FROM reservas r JOIN idiomas i ON r.idioma_id = i.id
                      AND r.localizador = '" . $_POST['localizador'] . "'";

$result_idioma_visita = $conexion->query($sql_idioma_visita);

if ($result_idioma_visita->rowCount() > 0) {
    $row_idioma_visita = $result_idioma_visita->fetch();
    $idioma_visita     = $language->getString($row_idioma_visita['idioma'], true);
    $idioma_visita_id  = $row_idioma_visita['id'];
}

// IDIOMA DE LA VISITA
$sql_tipo_pago = "SELECT *
                  FROM tipos_pagos
                  WHERE id = " . $forma_pago;

$result_tipo_pago = $conexion->query($sql_tipo_pago);

if ($result_tipo_pago->rowCount() > 0) {
    $row_tipo_pago          = $result_tipo_pago->fetch();
    $forma_pago_selecionada = $language->getString($row_tipo_pago['pago'], true);
}

$sql_loc_extras = "SELECT sum(le.unidades) as unidades, sum(le.total) as total,
            e.id, e.nombre, e.condiciones_extra, u.nombre as nombre_tarifa, et.tipo_clave,
            el.nombre as nombre_extra , el.condiciones_extra as condiciones_extra_tra
            FROM localizador_extras_servicio le 
            JOIN extras_servicios e ON le.extra_id = e.id
            INNER JOIN localizadores l ON le.localizador_extra = l.localizador  and l.estado='pagado'
            LEFT JOIN tarifas_extras t ON le.tarifa_id = t.id 
            LEFT JOIN usuarios_grupos u ON t.usuarios_grupo_id = u.id
            INNER JOIN extras_servicios_tipos et ON et.id = e.tipo_id
            LEFT JOIN extras_servicios_lang el ON el.extra_id = e.id AND el.idioma = ?
            WHERE le.localizador_extra = ?
            AND le.unidades > 0      
            GROUP BY le.tarifa_id, e.id, e.nombre, u.nombre, et.tipo_clave
            ORDER BY e.orden, le.tarifa_id ";

$result_loc_extras = $conexion->prepare($sql_loc_extras);
$result_loc_extras->execute(array( $idioma_visita_id , $_POST['localizador']));

$extras_seleccionados = array();
$extras_condiciones   = [];
$condiciones_extra    = "";
while ($row_loc_extra = $result_loc_extras->fetch()) {

    $nombre_extra = $language->getString($row_loc_extra['nombre'], true);

    if($idioma_visita_id != 1 && isset($row_loc_extra['nombre_extra'])){
        $nombre_extra = $row_loc_extra['nombre_extra'];
    }
 
    $nombre_tarifa = $language->getString($row_loc_extra['nombre_tarifa'], true);

    if ($nombre_tarifa == ''){
        $nombre_extra = $nombre_extra;
    }else{
        $nombre_extra = $nombre_extra . " | " . $nombre_tarifa ;
    }

    if($idioma_visita_id != 1 && isset($row_loc_extra['condiciones_extra_tra'])){
        $condiciones_extra_item = $row_loc_extra['condiciones_extra_tra'];
    }else{
        $condiciones_extra_item = $row_loc_extra['condiciones_extra'];
    }
    $extras_condiciones[$row_loc_extra['id']] =  $condiciones_extra_item;


    if ($row_loc_extra['total'] == 0) {
        $precio_extra = $language->getString('Gratuito', true);
    } else {
        $precio_extra_format = number_format($row_loc_extra['total'], 2);
        $precio_extra        = $precio_extra_format . ' €';
    }

    $extras_seleccionados[] = array(
        'nombre'   => $nombre_extra,
        'cantidad' => $row_loc_extra['unidades'],
        'precio'   => $precio_extra);

}
foreach ($extras_condiciones  as $key => $value) {
    $condiciones_extra = $condiciones_extra . ' ' . $value;
}

// TEXTOS PARA EL PDF
$section_message = 'imprimir_compra';
$servicio_texto  = $servicio;
require_once DIRMODULOSCOMP . 'otros/messages_email_pdf.php';

if ($precio_total == 0) {
    $precio_total = $language->getString('Gratuito', true);
} else {
    $precio_total = (float) $precio_total;
}

$protocol   = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

if (!empty($_POST['imprimir_reservas'])) {
    $ruta_qr = DOMRESERVAS . 'img/QR/';
} else {
    $ruta_qr = $domainLink . '/wp-content/plugins/visitas/modules/visitas/reservas/images/QR/';
}

$cupon_correo = "";
if ($row_localizador['bono'] != '') {
    $sql_cupon_correo    = "SELECT * FROM bonos WHERE codigo = '" . $row_localizador['bono'] . "' ";
    $result_cupon_correo = $conexion->query($sql_cupon_correo);

    if ($result_cupon_correo->rowCount() > 0) {
        $cupon_correo = $result_cupon_correo->fetch(PDO::FETCH_ASSOC);
    }
}

$data = array(
    'title'                     => isset($instalacion) ? $instalacion : '',
    'nombre'                    => isset($_POST['nombre']) ? $_POST['nombre'] : '',
    'apellidos'                 => isset($_POST['apellidos']) ? $_POST['apellidos'] : '',
    'telefono'                  => isset($_POST['telefono']) ? $_POST['telefono'] : '',
    'email'                     => isset($_POST['email']) ? $_POST['email'] : '',
    'localizador'               => isset($_POST['localizador']) ? $_POST['localizador'] : '',
    'id_pedido'                 => isset($id_pedido) ? $id_pedido : '',
    'tarifas_nombre'            => isset($tarifas_nombre) ? $tarifas_nombre : array(),
    'precios'                   => isset($precios) ? $precios : array(),
    'unidades_tarifa'           => isset($unidades_tarifa) ? $unidades_tarifa : array(),
    'precio_total'              => isset($precio_total) ? $precio_total : '',
    'actividad_nombre'          => isset($actividad_nombre) ? $actividad_nombre : '',
    'instalacion_nombre'        => isset($instalacion_nombre) ? $instalacion_nombre : '',
    'servicio_nombre_compra'    => isset($servicio_nombre_compra) ? $servicio_nombre_compra : '',
    'servicio_nombre_reserva'   => isset($servicio_nombre_reserva) ? $servicio_nombre_reserva : '',
    'fecha_reserva'             => isset($fecha) ? $fecha : null,
    'horario'                   => isset($hora) ? $hora : null,
    'fecha'                     => isset($fecha) ? $fecha : null,
    'hora'                      => isset($hora) ? $hora : null,
    'horario_balneario'         => isset($horario_balneario) ? $horario_balneario : null,
    'fecha_compra'              => isset($fecha_compra) ? $fecha_compra : '',
    'plazas'                    => isset($plazas) ? $plazas : '',
    'pistas'                    => isset($pistas) ? $plazas : '',
    'creditos'                  => isset($creditos) ? $creditos : '',
    'creditos_totales'          => isset($creditos_totales) ? $creditos_totales : '',
    'creditos_restantes'        => isset($creditos_restantes) ? $creditos_restantes : '',
    'deporte'                   => isset($deporte) ? $deporte : null,
    'pago_instalacion'          => isset($_POST['pago_instalacion']) ? $_POST['pago_instalacion'] : '',
    'opciones_seleccionadas'    => isset($opciones_seleccionadas) ? $opciones_seleccionadas : '',
    'campos_extra'              => isset($campos_extra) ? $campos_extra : '',
    'plazas_adulto'             => isset($plazas_adulto) ? $plazas_adulto : '',
    'plazas_infantil'           => isset($plazas_infantil) ? $plazas_infantil : '',
    'pago_seleccionado'         => !empty($language->getString($forma_pago_selecionada, true)) ? $language->getString($forma_pago_selecionada, true) : '',
    'descuento_coste'           => isset($descuento_coste) ? $descuento_coste : 0,
    'message_generico_emailPdf' => isset($message_generico_emailPdf) ? $message_generico_emailPdf : '',
    'message_servicio_emailPdf' => isset($message_servicio_emailPdf) ? $message_servicio_emailPdf : '',
    'pago_parcial'              => isset($pago_parcial) ? $pago_parcial : '',
    'descuento_coste_realizado' => isset($descuento_coste_realizado) ? $descuento_coste_realizado : 0,
    'tipo_aplicado'             => isset($tipo_aplicado) ? $tipo_aplicado : '',
    'idioma_visita'             => isset($idioma_visita) ? $idioma_visita : '',
    'extras_seleccionados'      => isset($extras_seleccionados) ? $extras_seleccionados : '',
    'condiciones_servicio'      => isset($condiciones_servicio) ? $condiciones_servicio : '',
    'condiciones_extra'         => isset($condiciones_extra) ? $condiciones_extra : '',
    'domainLink'                => isset($domainLink) ? $domainLink : '',
    'ruta_qr'                   => isset($ruta_qr) ? $ruta_qr : '',
    'cupon'                     => isset($cupon_correo) ? $cupon_correo : '',
    'instalacion_mapa'          => isset($instalacion_mapa) ? $instalacion_mapa : '',
    'accion'                    => 'realizado',
    'instalacion_descripcion'   => isset($instalacion_descripcion) ? $instalacion_descripcion : '',
    'instalacion_prepago'       => isset($instalacion_prepago) ? $instalacion_prepago : '',
    'instalacion'               => isset($instalacion) ? $instalacion : '',
    'loc_encryp'                => encriptar($_POST['localizador'])

);

/**
 * Sacamos PDF
 */

require_once DIRLIBCOMP . "/http-message-master/src/MessageInterface.php";
require_once DIRLIBCOMP . "/http-message-master/src/RequestInterface.php";
require_once DIRLIBCOMP . "/http-message-master/src/ResponseInterface.php";
require_once DIRLIBCOMP . "/http-message-master/src/ServerRequestInterface.php";
require_once DIRLIBCOMP . "/http-message-master/src/StreamInterface.php";
require_once DIRLIBCOMP . "/http-message-master/src/UploadedFileInterface.php";
require_once DIRLIBCOMP . "/http-message-master/src/UriInterface.php";


require_once DIRLIBCOMP . "/psr-http-message-shim-master/src/Request.php";
require_once DIRLIBCOMP . "/psr-http-message-shim-master/src/Response.php";
require_once DIRLIBCOMP . "/psr-http-message-shim-master/src/Stream.php";
require_once DIRLIBCOMP . "/psr-http-message-shim-master/src/Uri.php";

require_once DIRLIBCOMP . "/psr-log-aware-trait/src/MpdfPsrLogAwareTrait.php";
require_once DIRLIBCOMP . "/psr-log-aware-trait/src/PsrLogAwareTrait.php";
require_once DIRLIBCOMP . '/autoload.php';

require_once DIRLIBCOMP . '/FPDI/src/autoload.php';

/*$templatePath = DIRTPL . '/impresion/' . $language->getURLLang() . '/impresion_compra.php';
$content = compile($templatePath, $data);

$mpdf = new \Mpdf\Mpdf();
$mpdf->WriteHTML($content);
$mpdf->Output();

*/

require 'toPDF.php';

toPDF::$libPath = DIRLIBCOMP . 'mpdf/src/Mpdf.php';
$toPDF          = new toPDF(array(
'templatePath' => DIRTPL . '/impresion/' . $language->getURLLang() . '/impresion_compra.php',
'PDFname'      => $instalacion,
'data'         => $data,
));

//debug($data);

$toPDF->get();

exit;
