<?php
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/imprimir.txt');
require_once '../../config.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRLIBCOMP . 'SPDO.php';

/****************************************************************
Conectamos a la BD
 *****************************************************************/
global $conexion;
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*******************************************************************
 * TRADUCCIONES
 *******************************************************************/
require_once DIRCLASS . 'lang.php';
$language = new lang();

/*****************************************************************
 * Mensajes del sistema
 *****************************************************************/
require_once DIRCLASS . 'messages.php';
$message = new messages();

//INFORMACIÓN DE LA COMPRA
//Obtengo fecha de compra y número de unidades reservadas
$sql_localizador = "SELECT l.unidades, l.fecha_compra, l.servicio_pases, l.pases_totales, l.pago_instalacion, l.plazas_adulto, l.plazas_infantil, l.idioma, s.creditos, s.pases
                    FROM localizadores l JOIN servicios s ON l.servicio_id = s.id
                    AND l.localizador = '" . $_POST['localizador'] . "'";

$result_localizador = $conexion->query($sql_localizador);

if ($result_localizador->rowCount() > 0) {
    $row_localizador = $result_localizador->fetch(PDO::FETCH_ASSOC);

    $plazas          = $_POST['plazas'];
    $plazas_adulto   = $row_localizador['plazas_adulto'];
    $plazas_infantil = $row_localizador['plazas_infantil'];

    $fecha_compra     = cambiaf_a_normal($row_localizador['fecha_compra']);
    $pago_instalacion = $row_localizador['pago_instalacion'];
}

//Idioma
$_SESSION["lang"] = $language->getIsoLang($row_localizador['idioma']);

//ACTIVIDAD
$sql_actividad = "SELECT nombre
                      FROM actividades
                      WHERE id = " . $_POST['actividadSeleccionada'];

$result_actividad = $conexion->query($sql_actividad);

if ($result_actividad->rowCount() > 0) {
    $row_actividad    = $result_actividad->fetch();
    $actividad_nombre = $row_actividad['nombre'];
}

//Busco servicio reservado de horas valle
$tipo_compra = '';
$sql_hValle  = "SELECT s.id
                FROM reservas r JOIN sala_horario_servicios ss ON r.sala_horario_id = ss.sala_horario_id
                JOIN servicios s ON ss.servicio_id = s.id
                JOIN actividades a ON s.actividad_id = a.id
                AND r.localizador like '" . $_POST['localizador'] . "'
                AND s.id like '" . $_POST['servicio'] . "'
                AND (a.nombre like '%VALLE%' OR a.nombre like '%Valle%' OR a.nombre like '%valle%')
                AND s.actividad_id = " . $_POST['actividadSeleccionada'];

$result_hValle = $conexion->query($sql_hValle);

if ($result_hValle->rowCount() > 0) {
    $row_hValle = $result_hValle->fetch();

    $tipo_compra = $row_hValle['id'];
}

//SERVICIO
$product_lang = $language->getStringsProduct($_POST['servicio']);

$sql_servicio = "SELECT *
                 FROM servicios
                 WHERE id = " . $_POST['servicio'];

$result_servicio = $conexion->query($sql_servicio);

if ($result_servicio->rowCount() > 0) {
    $row_servicio = $result_servicio->fetch(PDO::FETCH_ASSOC);

    //Compruebo que no es una compra + reserva de horas valle
    $servicio_nombre_reserva = $product_lang['nombre'];

    if ($tipo_compra == '') {
        $servicio_nombre_compra = $product_lang['nombre'];
    }

    //Si es servicio de instalación
    if ($row_servicio['s_instalacion'] == 1) {
        $plazas = '';
    }

    //Compruebo si es sevicio de pistas
    $pistas = $row_servicio['pistas'];

    //Compruebo si es servicio de créditos y es bono
    if (($row_localizador['creditos'] == 1) && ($row_localizador['pases'] > 1)) {
        $creditos           = 1;
        $creditos_totales   = $row_localizador['pases_totales'];
        $creditos_restantes = $row_localizador['servicio_pases'];
    } else {
        $creditos = 0;
    }

}

//Compra + reserva de horas valle (compra bono o entrada, reserva
// servicio de horas valle)
if ($tipo_compra != '') {

    $sql_servicio = "SELECT *
                     FROM servicios
                     WHERE id = " . $tipo_compra;

    $result_servicio = $conexion->query($sql_servicio);

    if ($result_servicio->rowCount() > 0) {
        $row_servicio = $result_servicio->fetch(PDO::FETCH_ASSOC);

        $servicio_nombre_compra = $row_servicio['nombre'];
    }
}

//INSTALACIÓN
$sql_instalacion = "SELECT *
                    FROM instalaciones
                    WHERE id = " . $_POST['instalacion'];

$result_instalacion = $conexion->query($sql_instalacion);

if ($result_instalacion->rowCount() > 0) {
    $row_instalacion = $result_instalacion->fetch(PDO::FETCH_ASSOC);

    $instalacion_nombre = $row_instalacion['nombre'];
}

//Compruebo si ha comprado y reservado o sólo ha comprado un servicio
if ($_POST['fecha'] != 0) {
    //FECHA Y HORA
    //Me quedo con id hora, que tiene la fecha y hora seleccionadas
    $sql_fecha_hora = "SELECT *
                       FROM sala_horarios
                       WHERE id = " . $_POST['fecha'];

    $result_fecha_hora = $conexion->query($sql_fecha_hora);

    if ($result_fecha_hora->rowCount() > 0) {
        $row_fecha_hora = $result_fecha_hora->fetch(PDO::FETCH_ASSOC);

        $fecha = cambiaf_a_normal($row_fecha_hora['fecha']);

        $hora_inicio = date("H:i", strtotime($row_fecha_hora['hora_inicio']));
        $hora_fin    = date("H:i", strtotime($row_fecha_hora['hora_fin']));

        $hora = $hora_inicio;
    }

}

//OPCIONES SELECCIONADAS PARA LA VISITA SI LAS HAY
$sql_opciones_reserva = "SELECT c.nombre as nombreC, co.nombre as nombreOp
                         FROM reservas r JOIN reserva_caracteristicas rc ON r.id = rc.reserva_id
                         JOIN caracteristicas_opciones co ON rc.caracteristica_opcion_id = co.id
                         JOIN caracteristicas c ON rc.caracteristica_id = c.id
                         AND r.localizador = '" . $_POST['localizador'] . "'
                         AND r.sala_horario_id = " . $_POST['fecha'];

$result_opciones_reserva = $conexion->query($sql_opciones_reserva);

if ($result_opciones_reserva->rowCount() > 0) {

    $opciones_seleccionadas = array();

    foreach ($result_opciones_reserva->fetchAll() as $row_caracteristica_opcion) {
        $opciones_seleccionadas[] = '<strong>' . $language->getString($row_caracteristica_opcion['nombreC']) . ' : </strong>' . $row_caracteristica_opcion['nombreOp'];
    }
} else {
    $opciones_seleccionadas = '';
}

//IDIOMA DE LA VISITA
$sql_idioma_visita = "SELECT i.idioma
                      FROM reservas r JOIN idiomas i ON r.idioma_id = i.id
                      AND r.localizador = '" . $_POST['localizador'] . "'";

$result_idioma_visita = $conexion->query($sql_idioma_visita);

if ($result_idioma_visita->rowCount() > 0) {
    $row_idioma_visita = $result_idioma_visita->fetch();
    $idioma_visita     = $row_idioma_visita['idioma'];
}

//CAMPOS EXTRA
$sql_campos_extra = "SELECT DISTINCT c.*, lc.value
                     FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
                     AND c.type NOT LIKE  'checkbox'
                     AND lc.localizador = '" . $_POST['localizador'] . "'";

$result_campos_extra = $conexion->query($sql_campos_extra);

if ($result_campos_extra->rowCount() > 0) {

    $campos_extra = array();

    foreach ($result_campos_extra->fetchAll() as $row_campo) {
        $campos_extra[] = '<strong>' . $language->getString($row_campo['nombre'], true) . ': </strong>' . $row_campo['value'] . '<br/>';
    }
} else {
    $campos_extra = '';
}

//TEXTOS PARA EL PDF
$section_message = 'imprimir_reserva';
$servicio_texto  = $_POST['servicio'];
require_once DIRMODULOSCOMP . 'otros/messages_email_pdf.php';

$protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

$data = array(
    'title'                     => $instalacion_nombre,
    'nombre'                    => $_POST['nombre'],
    'apellidos'                 => $_POST['apellidos'],
    'telefono'                  => $_POST['telefono'],
    'email'                     => $_POST['email'],
    'localizador'               => $_POST['localizador'],
    'pago_instalacion'          => $pago_instalacion,
    'actividad_nombre'          => $actividad_nombre,
    'instalacion_nombre'        => $instalacion_nombre,
    'servicio_nombre_compra'    => $servicio_nombre_compra,
    'servicio_nombre_reserva'   => $servicio_nombre_reserva,
    'fecha'                     => isset($fecha) ? $fecha : null,
    'hora'                      => isset($hora) ? $hora : null,
    'horario_balneario'         => isset($horario_balneario) ? $horario_balneario : null,
    'fecha_compra'              => $fecha_compra,
    'pistas'                    => $pistas,
    'creditos'                  => $creditos,
    'creditos_totales'          => $creditos_totales,
    'creditos_restantes'        => $creditos_restantes,
    'plazas'                    => $plazas,
    'opciones_seleccionadas'    => $opciones_seleccionadas,
    'campos_extra'              => $campos_extra,
    'plazas_adulto'             => $plazas_adulto,
    'plazas_infantil'           => $plazas_infantil,
    'message_generico_emailPdf' => $message_generico_emailPdf,
    'message_servicio_emailPdf' => $message_servicio_emailPdf,
    'idioma_visita'             => $idioma_visita,
    'domainLink'                => $domainLink,
);

/**
 * Sacamos PDF
 */
require 'toPDF.php';

toPDF::$libPath = DIRLIBCOMP . 'mpdf/mpdf.php';
$toPDF          = new toPDF(array(
    'templatePath' => DIRTPL . '/impresion/' . $_SESSION["visitas_lang"] . '/impresion_reserva.php',
    'PDFname'      => $instalacion_nombre,
    'data'         => $data,
));

//debug($data);

$toPDF->get();

exit;
