<?php

ini_set('display_errors', 0);
require_once '../../config.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRLIBCOMP . 'SPDO.php';

/****************************************************************
Conectamos a la BD
 *****************************************************************/
global $conexion;
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*******************************************************************
 * TRADUCCIONES
 *******************************************************************/
require_once DIRCLASS . 'lang.php';
$language = new lang();

/*****************************************************************
 * Mensajes del sistema
 *****************************************************************/
require_once DIRCLASS . 'messages.php';
$message = new messages();

//DATOS PERSONALES
$localizador = $_POST['localizador'];
$nombre      = $_POST['nombre'];
$apellidos   = $_POST['apellidos'];
$telefono    = $_POST['telefono'];
$email       = $_POST['email'];
$plazas      = $_POST['plazas'];

//OBTENGO INFORMACIÓN DE LA COMPRA
$sql_localizador = "SELECT l.*, s.*
					FROM localizadores l JOIN servicios s ON l.servicio_id = s.id
					WHERE l.localizador = '" . $localizador . "'";

$result_localizador = $conexion->query($sql_localizador);
if ($result_localizador->rowCount() > 0) {
    $row_localizador = $result_localizador->fetch(PDO::FETCH_ASSOC);

    //Compruebo si el servicio es de créditos y bono
    if (($row_localizador['creditos'] == 1) && ($row_localizador['pases'] > 1)) {
        $creditos           = 1;
        $creditos_totales   = $row_localizador['pases_totales'];
        $creditos_restantes = $row_localizador['servicio_pases'];
    } else {
        $creditos = 0;
    }

    $pago_instalacion = $row_localizador['pago_instalacion'];

    $plazas_adulto   = $row_localizador['plazas_adulto'];
    $plazas_infantil = $row_localizador['plazas_infantil'];
}

//Idioma
$_SESSION["lang"] = $language->getIsoLang($row_localizador['idioma']);

//ACTIVIDAD
$sql_actividad = "SELECT nombre
				  FROM actividades
				  WHERE id = " . $_POST['actividadSeleccionada'];

$result_actividad = $conexion->query($sql_actividad);

if ($result_actividad->rowCount() > 0) {
    $row_actividad = $result_actividad->fetch(PDO::FETCH_ASSOC);
    $actividad     = $row_actividad['nombre'];
}

//SERVICIO
//Traducción datos servicio anulado
$product_lang = $language->getStringsProduct($row_localizador['servicio_id']);

$sql_servicio = "SELECT *
				 FROM servicios
                 WHERE id = " . $_POST['servicio'];

$result_servicio = $conexion->query($sql_servicio);

if ($result_servicio->rowCount() > 0) {
    $row_servicio = $result_servicio->fetch(PDO::FETCH_ASSOC);
    $servicio     = $product_lang['nombre'];
}

//Compruebo si el servicio es de instalación
if ($row_servicio['s_instalacion'] == 1) {
    $plazas = "";
}

//Compruebo si es servicio de pistas
$pistas = $row_servicio['pistas'];

//CAMPOS EXTRA
$sql_campos_extra = "SELECT c.*, lc.value
					 FROM campos c JOIN localizador_campos lc ON c.id = lc.campo_id
					 AND c.type NOT LIKE 'checkbox'
					 AND lc.localizador = '" . $localizador . "'";

$result_campos_extra = $conexion->query($sql_campos_extra);

if ($result_campos_extra->rowCount() > 0) {

    $campos_extra = array();

    foreach ($result_campos_extra->fetchAll() as $row_campo) {
        $campos_extra[] = '<strong>' . $language->getString($row_campo['nombre'], true) . ': </strong>' . $row_campo['value'] . '<br/>';
    }
} else {
    $campos_extra = '';
}

//INSTALACIÓN
$sql_instalacion = "SELECT *
					FROM instalaciones
                    WHERE id = " . $_POST['instalacion'];

$result_instalacion = $conexion->query($sql_instalacion);

if ($result_instalacion->rowCount() > 0) {
    $row_instalacion = $result_instalacion->fetch(PDO::FETCH_ASSOC);

    $instalacion = $row_instalacion['nombre'];
}

//INFORMACIÓN RESERVA ANULADA
//Traducción datos servicio nuevo
$product_lang = $language->getStringsProduct($_POST['servicio']);

$sql_anulada = "SELECT fecha, hora_inicio, hora_fin, s.nombre, i.nombre as nombreI, sa.nombre as nombreSa
				FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
				JOIN servicios s ON ss.servicio_id = s.id
				JOIN salas sa ON sh.sala_id = sa.id
				JOIN instalaciones i ON sa.instalacion_id = i.id
				AND ss.servicio_id =" . $_POST['servicio'] . "
				AND sh.id = " . $_POST['horaAnterior'];

$result_anulada = $conexion->query($sql_anulada);

if ($result_anulada->rowCount() > 0) {
    $row_anulada = $result_anulada->fetch(PDO::FETCH_ASSOC);

    $fecha_anulada = cambiaf_a_normal($row_anulada['fecha']);

    $hora_inicio     = date("H:i", strtotime($row_anulada['hora_inicio']));
    $hora_fin        = date("H:i", strtotime($row_anulada['hora_fin']));
    $horario_anulada = $hora_inicio;

    $servicio_anulado = $product_lang['nombre'];
    $sala_anulada     = $row_anulada['nombreSa'];

}

//Compruebo si el servicio es de instalaciones en cuyo caso el servicio
// de la reserva anulada y de la nueva es el mismo
if ($row_servicio['s_instalacion'] == 1) {
    $servicio_anulado = $row_servicio['nombre'];

}
$instalacion_anulada = $row_anulada['nombreI'];

//INFORMACIÓN RESERVA NUEVA
$sql_reserva = "SELECT fecha, hora_inicio, hora_fin
				FROM sala_horarios
				WHERE id = " . $_POST['horaNueva'];

$result_nueva = $conexion->query($sql_reserva);

if ($result_nueva->rowCount() > 0) {
    $row_nueva = $result_nueva->fetch(PDO::FETCH_ASSOC);

    $fecha_nueva = cambiaf_a_normal($row_nueva['fecha']);

    $hora_inicio   = date("H:i", strtotime($row_nueva['hora_inicio']));
    $hora_fin      = date("H:i", strtotime($row_nueva['hora_fin']));
    $horario_nueva = $hora_inicio;

}

//IDIOMA DE LA VISITA
$sql_idioma_visita = "SELECT i.idioma
					  FROM reservas r JOIN idiomas i ON r.idioma_id = i.id
					  AND r.localizador = '" . $localizador . "'";

$result_idioma_visita = $conexion->query($sql_idioma_visita);

if ($result_idioma_visita->rowCount() > 0) {
    $row_idioma_visita = $result_idioma_visita->fetch();
    $idioma_visita     = $row_idioma_visita['idioma'];
}

//CARACTERÍSTICAS SELECCIONADAS PARA LA VISITA SI LAS HAY
//Compruebo el id de la nueva reserva
$sql_reserva_nueva = "SELECT id
					  FROM reservas
					  WHERE localizador = '" . $localizador . "'
					  AND sala_horario_id = " . $_POST['horaNueva'];

$sql_reserva_nueva = $conexion->query($sql_reserva_nueva);

if ($sql_reserva_nueva->rowCount() > 0) {
    $row_reserva_nueva = $sql_reserva_nueva->fetch();
    $reserva_id_nueva  = $row_reserva_nueva['id'];

    //Compruebo si hay características
    $sql_opciones_reserva = "SELECT c.nombre as nombreC, co.nombre as nombreOp
							 FROM reservas r JOIN reserva_caracteristicas rc ON r.id = rc.reserva_id
							 JOIN caracteristicas_opciones co ON rc.caracteristica_opcion_id = co.id
							 JOIN caracteristicas c ON rc.caracteristica_id = c.id
							 AND rc.reserva_id = " . $reserva_id_nueva;

    $result_opciones_reserva = $conexion->query($sql_opciones_reserva);

    if ($result_opciones_reserva->rowCount() > 0) {

        $opciones_seleccionadas = array();

        foreach ($result_opciones_reserva->fetchAll() as $row_caracteristica_opcion) {
            $opciones_seleccionadas[] = '<strong>' . $row_caracteristica_opcion['nombreC'] . ' : </strong>' . $row_caracteristica_opcion['nombreOp'];
        }
    } else {
        $opciones_seleccionadas = '';
    }
} else {
    $opciones_seleccionadas = '';
}

//TEXTOS PARA EL PDF
$section_message = 'imprimir_modificacion';
$servicio_texto  = $row_localizador['servicio_id'];
require_once DIRMODULOSCOMP . 'otros/messages_email_pdf.php';

$protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

// Datos para la plantilla
$data = array(
    'title'                     => $instalacion,
    'nombre'                    => $nombre,
    'apellidos'                 => $apellidos,
    'telefono'                  => $telefono,
    'email'                     => $email,
    'localizador'               => $localizador,
    'actividad'                 => $actividad,
    'instalacion'               => $instalacion,
    'servicio'                  => $servicio,
    'fecha_anulada'             => $fecha_anulada,
    'horario_anulada'           => $horario_anulada,
    'servicio_anulado'          => $servicio_anulado,
    'fecha_nueva'               => $fecha_nueva,
    'horario_nueva'             => $horario_nueva,
    'hora_balneario'            => $hora_balneario,
    'pistas'                    => $pistas,
    'creditos'                  => $creditos,
    'creditos_totales'          => $creditos_totales,
    'creditos_restantes'        => $creditos_restantes,
    'instalacion_anulada'       => $instalacion_anulada,
    'pago_instalacion'          => $pago_instalacion,
    'plazas'                    => $plazas,
    'opciones_seleccionadas'    => $opciones_seleccionadas,
    'plazas_adulto'             => $plazas_adulto,
    'plazas_infantil'           => $plazas_infantil,
    'campos_extra'              => $campos_extra,
    'message_generico_emailPdf' => $message_generico_emailPdf,
    'message_servicio_emailPdf' => $message_servicio_emailPdf,
    'idioma_visita'             => $idioma_visita,
    'domainLink'                => $domainLink,
);

/**
 * Sacamos PDF
 */
require 'toPDF.php';

toPDF::$libPath = DIRLIBCOMP . 'mpdf/mpdf.php';
$toPDF          = new toPDF(array(
    'templatePath' => DIRTPL . '/impresion/' . $_SESSION["visitas_lang"] . '/imprimir_reservamodificada.php',
    'PDFname'      => $instalacion,
    'data'         => $data,
));

//debug($data);

$toPDF->get();

exit;
