<?php

/*
 * Dada una plantilla, un campo y una conexión, carga una plantilla secundaria
 *     para cada campo dependiendo del tipo de éste en la plantilla principal
 *     en el bloque tCamposExtraLabel
 *
 * @tpl: la plantilla principal que contiene el bloque tCamposExtraLabel en la que se cargará
 *             el campo
 * @campo: campo que se cargará en la plantilla principal
 * @conexion: conexión de BBDD para obtener las opciones seleccionables del campo si las tiene
 */
function cargaCampo(&$tpl, $campo, $conexion, $language)
{

    // Almacena la relación entre tipos de campo y sus plantillas
    $tipos_campos_plantillas = array(
        1 => array('text', 'estandar.tpl'),
        2 => array('checkbox', 'seleccionable.tpl'),
        3 => array('select', 'seleccionable.tpl'),
        4 => array('radio_button', 'radio_button.tpl'),
        5 => array('cuenta_corriente', 'cuenta_corriente.tpl'),
        6 => array('textarea', 'textarea.tpl'),
    );

    // Obtenemos los datos de los campos
    $campo_tipo_id          = $campo['campo_tipo_id'];
    $campo_id               = $campo['campo_id'];
    $campo_tipo_nombre      = $campo['campo_tipo_nombre'];
    $campo_nombre           = $campo['campo_nombre'];
    $campo_nombre_traducido = $language->getString($campo_nombre, true);
    $opciones               = null;

    // Si tiene opciones (es un seleccionable, como select o radio_button)
    //    las obtenemos
    $tiene_opciones = $campo['tiene_opciones'];
    if ($tiene_opciones) {
        $opciones = getCampoOptions($campo_id, $conexion);
    }

    // Reemplazamos el bloque el campo genérico tCamposExtraLabel por una plantilla
    //    personalizada según el tipo de campo
    $tpl->replaceBlockfile('tCamposExtraLabel', 'otros/campos/' . $tipos_campos_plantillas[$campo_tipo_id][1], true);

    $tpl->setVariable('NOMBRECAMPOEXTRA', $campo_nombre_traducido);
    $tpl->setVariable('CAMPOEXTRA', $campo_id);
    $tpl->setVariable('IDCAMPOEXTRA', $campo_id);

    // Campo obligatorio
    if ($campo['es_obligatorio'] == 1) {
        $tpl->setVariable('ESOBLIGATORIO', '* ');
        $tpl->setVariable('REQUIRED', 'required');
    }

    // Según el tipo de campo, establecemos valores en la plantilla concreta cargada
    if ($campo_tipo_nombre == 'text') {
        $tpl->setVariable('TIPOCAMPOEXTRA', 'text');
    }
    // Estos campos tienen valores seleccionables
    elseif ($campo_tipo_nombre == 'select' || $campo_tipo_nombre == 'radio_button') {
        if ($tiene_opciones && isset($opciones) && sizeof($opciones) > 0) {
            // Establecemos los valores seleccionables
            foreach ($opciones as $opcion) {
                $tpl->setVariable("CAMPOVALOR", $opcion['id']);
                $tpl->setVariable("CAMPOOPCION", $language->getString($opcion['opcion']));

                if ($campo_tipo_nombre == 'radio_button') {
                    $tpl->setVariable("RBCAMPOEXTRA", $campo_id);
                }

                // Controlamos los valores por defecto
                if ($campo_nombre == 'País' && $opcion['opcion'] == 'España') {
                    $tpl->setVariable("SELECTED", 'SELECTED');
                }

                $tpl->parse('tCampoSeleccionables');
            }
        } elseif (($campo_tipo_nombre == 'cuenta_corriente')) {;
        }

        return $tpl_campo;
    }
}

// Para un campo, obtiene las opciones seleccionables
function getCampoOptions($campo_id, $conexion)
{
    $query = "SELECT co.*
			  FROM campos_options as co
			  WHERE co.campo_id = " . $campo_id;

    $campo_options = $conexion->query($query);
    return $campo_options;
}
