<?php

/**
 * Redsys
 */
require DIRLIBCOMP . 'ApiRedsysREST/initRedsysApi.php';

// DATOS REDSYS
$sql_redsys_data = "SELECT r.*
                    FROM localizadores l JOIN Redsys r ON l.id_pedido = r.Ds_MerchantData
                    AND r.estado = 'pagado'
                    AND l.localizador like '" . $localizador . "'";

$result_redsys_data = $conexion->query($sql_redsys_data);

if ($result_redsys_data->rowCount() > 0) {
    $row_redsys_data = $result_redsys_data->fetch();

    $ds_merchant_order      = $row_redsys_data['Ds_Order'];
    $ds_merchant_amount     = isset($refund_amount) ? $refund_amount : $row_redsys_data['Ds_Amount'];
    $ds_merchant_currency   = $row_redsys_data['Ds_Currency'];
    $ds_merchant_data       = $row_redsys_data['Ds_MerchantData'];
    $sala_horario_id_redsys = $row_redsys_data['sala_horario_id'];

    // Vemos si tenemos la instalación y buscamos su configuración de redsys
    $sql_redsys_conf = "SELECT *
                        FROM instalaciones i
                        JOIN redsys_configuraciones rc ON i.redsys_conf_id = rc.id
                        WHERE i.id = 43
                        LIMIT 1"; /*$$instalacion*/
    $result_redsys_conf = $conexion->query($sql_redsys_conf);

    if (!is_bool($result_redsys_conf) && $result_redsys_conf->rowCount() > 0) {

        $row_redsys           = $result_redsys_conf->fetch();
        $redsys_key           = $row_redsys['Secret_Key'];
        $redsys_merchant_code = $row_redsys['Ds_Merchant_MerchantCode'];
        $redsys_terminal      = $row_redsys['Ds_Merchant_Terminal'];
        $nombre_instalacion   = $row_redsys['nombre'];

        $refundRequest = new RestOperationMessage();

        // Operation mandatory data
        $refundRequest->setAmount((string) $ds_merchant_amount); // i.e. 1,23 (decimal point depends on currency code)
        $refundRequest->setCurrency($ds_merchant_currency); // ISO-4217 numeric currency code
        $refundRequest->setMerchant($redsys_merchant_code);
        $refundRequest->setTerminal($redsys_terminal);
        $refundRequest->setOrder($ds_merchant_order);
        $refundRequest->setTransactionType(RESTConstants::$REFUND);

        // Other optional parameters example can be added by "addParameter" method
        $texto_devolucion = "Devolución ". $nombre_instalacion . " " .$localizador;
        $refundRequest->addParameter("DS_MERCHANT_PRODUCTDESCRIPTION", $texto_devolucion);
   
        // Service setting (Signature, Environment, type of payment)
        $entorno_redsys = RESTConstants::$ENV_SANDBOX;
        if(RedsysEnviromentProduction == true){
            $entorno_redsys = RESTConstants::$ENV_PRODUCTION;
            $sentencia        = "LOCALIZADOR - refund " . $localizador. " - Entorno produccion ". $entorno_redsys . " " . RedsysEnviromentProduction . " " . $texto_devolucion ;
            Insertar_Sentencia($sentencia, 'anulacion');
        }else{
            $sentencia        = "LOCALIZADOR - refund " . $localizador. " - Entorno desarrollo ". $entorno_redsys . " " . $texto_devolucion ;
            Insertar_Sentencia($sentencia, 'anulacion');
        }
        $service = new RESTOperationService($redsys_key, $entorno_redsys);

        $refundResponse = $service->sendOperation($refundRequest);
        $texto_reembolso = "";
        
        switch ($refundResponse->getResult()) {
            case RESTConstants::$RESP_LITERAL_OK:

                $sql_tpv = "INSERT INTO Redsys (Ds_MerchantData, Ds_Order, Ds_Amount, sala_horario_id, Ds_Currency, Ds_MerchantCode, Ds_Terminal, Ds_Signature,
                    Ds_Response, Ds_SecurePayment, Ds_TransactionType, Ds_Card_Country, Ds_AuthorisationCode, Ds_ConsumerLanguage, Ds_Date, Ds_Hour, estado, localizador) VALUES (?, ?, ?, ?, ?, ?, ?, ?,
                    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                $result_tpv = $conexion->prepare($sql_tpv);

                $datos_redsys = array(
                    $ds_merchant_data,
                    $ds_merchant_order,
                    $ds_merchant_amount,
                    $sala_horario_id_redsys,
                    $refundResponse->getOperation()->getCurrency(),
                    $refundResponse->getOperation()->getMerchant(),
                    $refundResponse->getOperation()->getTerminal(),
                    $refundResponse->getOperation()->getSignature(),
                    $refundResponse->getOperation()->getResponseCode(),
                    $refundResponse->getOperation()->getSecurePayment(),
                    $refundResponse->getOperation()->getTransactionType(),
                    !empty($refundResponse->getOperation()->getCardCountry()) ? $refundResponse->getOperation()->getCardCountry() : 0,
                    $refundResponse->getOperation()->getAuthCode(),
                    $refundResponse->getOperation()->getLanguage(),
                    date("d/m/Y"),
                    date("H:i"),
                    'reembolso',
                    $localizador,
                );

                $exec_tpv = $result_tpv->execute($datos_redsys);

                //Guardamos un log si no podemos realizar el registro en la bbdd
                if ($exec_tpv != 1) {
                    $file = fopen(CARPETAPROYECTO . "/modules/visitas/reservas/modulos/RegistroErrorRedsysBBDD.txt", "a");
                    fwrite($file, print_r($exec_tpv, true) . PHP_EOL);
                    fwrite($file, print_r($datos_redsys, true) . PHP_EOL);
                    fclose($file);
                }

                if ($es_una_baja == 1 && $exec_tpv == 1) {
                    $sql_update_estado = "UPDATE localizadores
                            SET anulacion_ok = 1
                            WHERE localizador = :localizador
                        ";

                    $result_local_extra = $conexion->prepare($sql_update_estado);
                    $exito_local_extra  = $result_local_extra->execute(array(
                        ':localizador' => $localizador,
                    ));

                } else {

                    $sql_update_estado = "UPDATE localizadores_cambios_plazas_det
                            SET modificacion_ok = 1
                            WHERE localizador = :localizador
                            and uuid = :uuid
                        ";

                    $result_local_extra = $conexion->prepare($sql_update_estado);
                    $exito_local_extra  = $result_local_extra->execute(array(
                        ':localizador' => $localizador,
                        ':uuid'        => $uuid_v4,
                    ));

                }
               

                $protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
                $domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

               
                $texto_reembolso_01 = _('Su solicitud de reembolso ha sido procesada con éxito y hemos emitido un reembolso a su tarjeta.');
                $texto_reembolso_02 = _('Por favor no dude en ponerse en contacto con nosotros si tiene cualquier duda.');
                if($es_una_baja == 1 ){
                    $texto_reembolso_03 = _('Muchas gracias por confiar en nosotros, esperamos pueda volver muy pronto.');
                }else{
                    $texto_reembolso_03 = "";

                }
                
                $texto_reembolso = _($texto_reembolso_01 . '<br>' . $texto_reembolso_02 . '<br>' . $texto_reembolso_03);
               
                $tReservaReembolso      = 1;
                $LABELTOTALREEMBOLSADO  = _('Total reembolsado: ');
                $CANTIDADREEMBOLSO      = sprintf('%0.2f', $ds_merchant_amount / 100) . ' €';
                $TEXTRESERVAREEMBOLSADA = $texto_reembolso;
            
                break;

            default:
                $tReservaReembolso = 1;
                $TEXTRESERVAREEMBOLSADA = _('Su reembolso no ha podido ser realizado. Por favor, póngase en contacto con nuestro equipo de atención al cliente.');
                break;
        }
    }

} else {
    $tReservaReembolso = 1;
    $TEXTRESERVAREEMBOLSADA = _('Su reembolso no ha podido ser realizado. Por favor, póngase en contacto con nuestro equipo de atención al cliente.');

}
