<?php
require_once DIRLIBCOMP . 'autoload.php';

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/email.txt');
error_reporting(E_ALL);

use Passbook\PassFactory;
use Passbook\Pass\Barcode;
use Passbook\Pass\Field;
use Passbook\Pass\Image;
use Passbook\Pass\Structure;
use Passbook\Type\EventTicket;

// OBTENGO INFORMACIÓN DE LA COMPRA
$sql_localizador = "SELECT l.*, s.pases, s.creditos, tp.pago, i.idioma
                    FROM localizadores l
                    JOIN servicios s ON l.servicio_id = s.id
                    JOIN tipos_pagos as tp ON l.tipo_pago = tp.id
                    JOIN idiomas as i on i.id = l.idioma
                    WHERE l.localizador = '" . $localizador . "'";

$result_localizador = $conexion->query($sql_localizador);
if ($result_localizador->rowCount() > 0) {
    $row_localizador = $result_localizador->fetch(PDO::FETCH_ASSOC);

    $servicio         = $row_localizador['servicio_id'];
    $idpedido         = $row_localizador['id_pedido'];
    $idioma_visita    = $row_localizador['idioma'];
    $tipo_pago        = $row_localizador['pago'];
    $nombre           = $row_localizador['nombre'];
    $apellidos        = $row_localizador['apellido'];
    $telefono         = $row_localizador['telefono'];
    $email            = $row_localizador['email'];
    $plazas           = $row_localizador['unidades'];
    $fecha_compra     = cambiaf_a_normal($row_localizador['fecha_compra']);
    $pago_instalacion = $row_localizador['pago_instalacion'];
    $total            = sprintf('%0.2f', $row_localizador['total']);
    $total            = $total . ' €';
}

// Compruebo si es servicio de pistas
$language = new Lang();

// Datos reserva anulada
// Traducción datos servicio
$product_lang = $language->getStringsProduct($servicio);

// Datos nueva reserva
$sql_nuevareserva = "SELECT sh.fecha, sh.hora_inicio, sh.hora_fin, s.nombre
                     FROM sala_horarios sh
                     JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                     JOIN servicios s ON ss.servicio_id = s.id
                     AND ss.servicio_id =" . $servicio . "
                     AND sh.id = " . $fechaId;

$result_nuevareserva = $conexion->query($sql_nuevareserva);
if ($result_nuevareserva->rowCount() > 0) {
    $row_reserva = $result_nuevareserva->fetch(PDO::FETCH_ASSOC);

    $hora_inicio     = strtotime($row_reserva['hora_inicio']);
    $hora_inicio     = date("H:i", $hora_inicio);
    $hora_fin        = strtotime($row_reserva['hora_fin']);
    $hora_fin        = date("H:i", $hora_fin);
    $horario_reserva = $hora_inicio;

    $fecha_reserva_nueva = cambiaf_a_normal($row_reserva['fecha']);
    $instalacion_nueva   = $row_anulada['nombre'];

}

$protocol   = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];
$loc_encryp = encriptar($localizador);

if ($row_localizador['web'] == 1) {
    $ruta_qr = $data['domainLink'] . '/wp-content/plugins/visitas/modules/visitas/reservas/images/QR/';
} else {
    $ruta_qr = DOMRESERVAS . 'img/QR/';
}

$extras_seleccionados = array();

$extras_seleccionados_ant = $extras_seleccionados;

// Extras seleccionados
$sql_loc_campos = "SELECT lc.*
                   FROM localizador_campos lc
                   WHERE lc.localizador = ?";

$result_loc_campos = $conexion->prepare($sql_loc_campos);
$result_loc_campos->execute(array($localizador));

while ($row_loc_campo = $result_loc_campos->fetch()) {

    switch ($row_loc_campo['campo_id']) {
        case 100:
            $nombre_regalado = $row_loc_campo['value'];
            break;
        case 101:
            $apellido_regalado = $row_loc_campo['value'];
            break;
        case 102:
            $email_regalado = $row_loc_campo['value'];
            break;
        case 103:
            $telefono_regalado = $row_loc_campo['value'];
            break;
    }
}

// TEXTOS PARA EL EMAIL
$section_message = 'email_modificacion';
$servicio_texto  = $servicio;
$message         = new messages();
require_once DIRMODULOSCOMP . 'otros/messages_email_pdf.php';

//require_once DIRLIBCOMP . 'mail/class.phpmailer.php';

//$mail = new PHPMailer();

// ENVÍO DE CORREO LOS DATOS DE LA RESERVA
require_once DIRLIBCOMP . 'mail/PHPMailer.php';
require_once DIRLIBCOMP . 'mail/SMTP.php';
require_once DIRLIBCOMP . 'mail/Exception.php';

$mail = new PHPMailer\PHPMailer\PHPMailer(true);

$correo = obtenerDatosCorreo();

// -----------SMTP--------------
// Con PluginDir le indicamos a la clase phpmailer donde se
// encuentra la clase smtp que como he comentado al principio de
// este ejemplo va a estar en el subdirectorio includes
$mail->CharSet   = "UTF-8";
// $mail->PluginDir = "";
// Con la propiedad Mailer le indicamos que vamos a usar un servidor smtp
$mail->Mailer = "smtp";
// Le indicamos el content-type HTML
$mail->isHTML(true);
$mail->SMTPSecure = 'tls';
// Asignamos a Host el nombre de nuestro servidor smtp
$mail->Host = MAILHOST;
// Le indicamos que el servidor smtp requiere autenticación
$mail->SMTPAuth = MAILSMTPAUTH;
// Le decimos cual es nuestro nombre de usuario y password
$mail->Username = $correo['user'] ?? MAILUSER;
$mail->Password = $correo['pass'] ?? MAILPASS;
// Asignamos a Host el nombre de nuestro servidor smtp
$mail->Port = MAILPORT;
$mail->From = $correo['mail'] ?? MAILFROM;
// $mail->AddCustomHeader('Reply-to:informacion.bodegas@pruebajig.es');

$mail->FromName = "=?UTF-8?B?" . base64_encode(mb_convert_encoding('Reservas ' . $instalacion, "UTF-8", mb_detect_encoding('Reservas ' . $instalacion))) . "=?=";
//para que coja la 'ñ';
$mail->Subject = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($language->getString('Reserva Realizada',true) . ' - ' . $instalacion, "UTF-8", mb_detect_encoding($language->getString('Reserva Realizada',true) . ' - ' . $instalacion))) . "=?=";

//Paso de datos a la plantilla
$compra = array(
    'localizador'             => $localizador,
    'nombre'                  => $nombre,
    'apellidos'               => $apellido,
    'telefono'                => $telefono,
    'email'                   => $email,
    'fecha_compra'            => $fecha_compra,
    'servicio_anulado'        => $servicio_anulado,
    'servicio'                => $product_lang['nombre'],
    'pago_instalacion'        => $pago_instalacion,
    'fecha_reserva'           => $fecha_reserva_nueva,
    'horario_reserva'         => $horario_reserva,
    'unidades_tarifa'         => !empty($arrTarifas) ? $arrTarifas : array(),
    'tarifas_nombre'          => !empty($arrTarifasNombre) ? $arrTarifasNombre : array(),
    'plazas'                  => !empty($plazas) ? $plazas : '',
    'precios'                 => !empty($arrTarifasPrecio) ? $arrTarifasPrecio : array(),
    'condiciones_servicio'    => $product_lang['condiciones_servicio'],
    'domainLink'              => $domainLink,
    'loc_encryp'              => $loc_encryp,
    'ruta_qr'                 => $ruta_qr,
    'extras_seleccionados'    => !empty($extras_seleccionados) ? $extras_seleccionados : array(),
    'id_pedido'               => !empty($idpedido) ? $idpedido : '',
    'idioma_visita'           => !empty($idioma_visita) ? $idioma_visita : '',
    'creditos'                => !empty($creditos) ? $creditos : '',
    'pago_seleccionado'       => !empty($tipo_pago) ? $tipo_pago : '',
    'campos_extra'            => !empty($campos_extra) ? $campos_extra : array(),
    'horario'                 => $horario_reserva,
    'total'                   => $precio_total,
    'id_pedido'               => $idpedido,
    'instalacion'             => !empty($instalacion) ? $instalacion : '',
    'nombre_regalado'         => $nombre_regalado,
    'apellidos_regalado'      => $apellido_regalado,
    'telefono_regalado'       => $telefono_regalado,
    'email_regalado'          => $email_regalado,
    'instalacion_descripcion' => !empty($instalacion_desc) ? $instalacion_desc : '',
    'instalacion_mapa'        => !empty($instalacion_mapa) ? $instalacion_mapa : '',
    'instalacion_prepago'     => !empty($instalacion_enlace) ? $instalacion_enlace : '',
);

//generatePKPass($compra);

ob_start();
require DIRLIBCOMP . 'mail/plantillas_correo/' . (!empty($_SESSION["visitas_lang"]) ? $_SESSION["visitas_lang"] : 'es_ES') . '/correo_modificar_regalo.php'; //Plantilla de correo

$body = ob_get_contents();
ob_end_clean();

$mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
$mail->Body    = $body;

$emails_debug = (array)json_decode($_ENV['MAIL_TO_NOTIFY_DEBUG'],true);
//Envío de correo
if (is_array($emails_debug) === true) {
    foreach ($emails_debug as $email_ua => $email_data) {        
        $destinatarios[] = array(
            'nombre' => $email_data['nombre'],
            'email'  => $email_data['email']);
    }
}

if (ENVIRONMENT == 'production') {
    // Nosotros
    $emails_notify = (array)json_decode($_ENV['MAIL_TO_NOTIFY'],true);

    if (is_array($emails_notify) === true) {
        foreach ($emails_notify as $email_ua => $email_data) {        
            $destinatarios[] = array(
                'nombre' => $email_data['nombre'],
                'email'  => $email_data['email']);
        }
    }

    // Cliente
    if ($email_regalado != '') {
        $email_ua        = $email_regalado;
        $destinatarios[] = array(
            'nombre' => $nombre_regalado,
            'email'  => $email_regalado,
        );
    }
}

if (is_array($destinatarios) === true) {
    foreach ($destinatarios as $destino) {

        $mail->AddAddress($destino['email'], $destino['nombre']);
        if ($mail->Send()) {
            //return true;

        } else {
            //return false;
        }
        $mail->ClearAddresses();
    }
}

// Repetimos proceso para el señor que hizo el regalo

//para que coja la 'ñ';
$mail->FromName = "=?UTF-8?B?" . base64_encode(mb_convert_encoding($instalacion, "UTF-8", mb_detect_encoding($instalacion))) . "=?=";
$mail->Subject  = "=?UTF-8?B?" . base64_encode(mb_convert_encoding(utf8_decode($language->getString('Reserva Canjeada por tu amigo') . ' - ' . $instalacion), "UTF-8", mb_detect_encoding(utf8_decode($language->getString('Reserva Canjeada por tu amigo') . ' - ' . $instalacion)))) . "=?=";

ob_start();
require DIRLIBCOMP . 'mail/plantillas_correo/' . (!empty($_SESSION["visitas_lang"]) ? $_SESSION["visitas_lang"] : 'es_ES') . '/correo_canjeo_regalo.php'; //Plantilla de correo

$body2 = ob_get_contents();
ob_end_clean();

$mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
$mail->Body    = $body2;

$destinatarios = array();

// Cliente
if ($email != '') {
    $email_ua        = $email;
    $destinatarios[] = array(
        'nombre' => $nombre,
        'email'  => $email,
    );
}

if (is_array($destinatarios) === true) {
    foreach ($destinatarios as $destino) {

        $mail->AddAddress($destino['email'], $destino['nombre']);
        if ($mail->Send()) {
            //return true;

        } else {
            //return false;
        }
        $mail->ClearAddresses();
    }
}

function generatePKPass($compra)
{   
    $OUTPUT_PATH = PASSBOOK_OUTPUT_PATH_BASE . $compra['localizador'];

    // Create an event ticket
    $pass = new EventTicket($compra['localizador'], html_entity_decode(strip_tags($compra['servicio'])));

    $pass->setBackgroundColor('rgb(30, 30, 30)'); //color de fondo
    $pass->setForegroundColor('rgb(150,150,150)'); //color del texto
    $pass->setLabelColor('rgb(197,159,79)'); //color de las etiquetas

    $image = new Image(PASSBOOK_ICON_FILE, 'logo');
    $image->setDensity(2);
    $pass->addImage($image);

    $image2 = new Image(PASSBOOK_BACKGROUND_FILE, 'strip');
    $pass->addImage($image2);

    // Create pass structure
    $structure = new Structure();

    $header = new Field('header', '');
    $header->setLabel($compra['fecha_reserva']);
    $header->setValue($compra['horario']);
    $structure->addHeaderField($header);

    $secondary = new Field('event', html_entity_decode(strtoupper(($compra['servicio']))));
    $secondary->setLabel('Enoexperiencia');
    $structure->addSecondaryField($secondary);

    // Add auxiliary field
    $auxiliary = new Field('plazas', $compra['plazas']);
    $auxiliary->setLabel('Plazas');
    $structure->addAuxiliaryField($auxiliary);

    // Add auxiliary field
    $auxiliary = new Field('total', $compra['total'] . "€");
    $auxiliary->setLabel('Total');
    $structure->addAuxiliaryField($auxiliary);

    // Add icon image
    $icon = new Image(PASSBOOK_ICON_FILE, 'icon');
    $pass->addImage($icon);

    // Set pass structure
    $pass->setStructure($structure);

    // Add barcode
    $barcode = new Barcode(Barcode::TYPE_QR, $compra['localizador']);
    $pass->setBarcode($barcode);

    $backfile = new Field('nombre', html_entity_decode(strip_tags($compra['nombre'] . " " . $compra['apellidos'])));
    $backfile->setLabel('Nombre');
    $structure->addBackField($backfile);

    $backfile = new Field('email', html_entity_decode(strip_tags($compra['email'])));
    $backfile->setLabel('Email');
    $structure->addBackField($backfile);

    $backfile = new Field('lugar', html_entity_decode(strip_tags($compra['instalacion'])));
    $backfile->setLabel('Lugar');
    $structure->addBackField($backfile);

    $backfile = new Field('idioma', html_entity_decode(strip_tags($compra['idioma_visita'])));
    $backfile->setLabel('Idioma');
    $structure->addBackField($backfile);

    // Create pass factory instance
    $factory = new PassFactory(
        PASSBOOK_PASS_TYPE_IDENTIFIER,
        PASSBOOK_TEAM_IDENTIFIER,
        PASSBOOK_ORGANIZATION_NAME,
        PASSBOOK_P12_FILE,
        PASSBOOK_P12_PASSWORD,
        PASSBOOK_WWDR_FILE);
    $factory->setOutputPath($OUTPUT_PATH);

    $factory->package($pass);

    return $OUTPUT_PATH;
}
