<?php
/**************    Include cabecera  ***********************************/
require_once BASEPATH . '/modules/visitas/reservas/principal_compra_reserva.php';

// Cargamos el archivo de plantilla propio
$RAIZ     = DOMINIO;
$RAIZ_URL = DIRECCIONPROYECTO;

// PHP con los textos estáticos de la plantilla
require_once DIRLANGUAGESTRINGS . 'reserva_web/formulario_productos.php';

// Establecemos en función del lenguaje seleccionado el js con los textos
$sesion_lang = $language->getUrlLang();
$lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');
$LANGJS      = $lang;

$time_now = strtotime(date('Y-m-d H:i'));
$TIMENOW  = $time_now;

$fecha_actual = date('Y-m-d');
$hora_actual  = date('H:i:s');

// Recogemos la url encriptada donde tenemos el servicio y la mesa si la hubiera
$params      = array_keys($_GET);
if(!empty($params)){

    $param_mesa  = base64_decode($params[0]);
    $servicio_id = explode("=", $param_mesa)[1];
    $servicio_id = explode("&", $servicio_id)[0];

    $SERVICIOID = $servicio_id;

    $sql_servicio = "SELECT *
                     FROM servicios
                     WHERE id = $servicio_id";

    $result_servicio = $conexion->query($sql_servicio);

    if ($result_servicio->rowCount() > 0) {

        $servicio = $result_servicio->fetch();

        $sala_id = $servicio['sala_id'];

        if(!empty($sala_id)){
            $sql_sala_horarios = "SELECT *
                                  FROM sala_horarios
                                  WHERE fecha = '$fecha_actual'
                                  AND hora_inicio <= '$hora_actual'
                                  AND hora_fin >= '$hora_actual'
                                  AND sala_id = $sala_id ";

            $result_sala_horarios = $conexion->query($sql_sala_horarios);

            // Si no hay error en la consulta
            if ($result_sala_horarios != null && $result_sala_horarios->rowCount() > 0) {

                // Comprobamos si el servicio es con mesas o sin mesas
                if ($servicio['mesas'] == 1) {
                    $cadena_buscada        = 'mesa=';
                    $posicion_coincidencia = strrpos($param_mesa, $cadena_buscada);
                } else {
                    $posicion_coincidencia = true;
                }

                // Se puede hacer la comparacion con 'false' o 'true' y los comparadores '===' o '!=='
                if ($posicion_coincidencia === false) {
                    $tProductosAbierto = false;
                    $tProductosCerrado = false;
                    $tNoMesa           = true;
                } else {
                    $tNoMesa = false;

                    if ($servicio['mesas'] == 1) {
                        $mesa = explode("=", $param_mesa)[2];
                    } else {
                        $mesa = 0;
                    }

                    $MESA      = (int) $mesa;
                    $TEXTOMESA = $servicio['nombre'];
      
                    if ((int) $mesa == 0) {
                        $tGastroBar    = false;
                        $tPromociones  = false;
                        $TEXTOTUPEDIDO = 'Tu pedido';
                    } else {
                        // Comprobamos si esa mesa sigue existiendo
                        $sql_mesa_servicio = "SELECT *
                                              FROM mesas
                                              WHERE servicio_id = $servicio_id
                                              AND numero = $MESA";
                        
                        $result_mesa_servicio = $conexion->query($sql_mesa_servicio);

                        // Si no hay error en la consulta
                        if ($result_mesa_servicio != null && $result_mesa_servicio->rowCount() > 0) {
                            $tPromociones  = true;
                            $tGastroBar    = true;
                            $TEXTOTUPEDIDO = 'Tu pedido en la mesa ' . $mesa;
                            $continuar     = true;
                            $tNoMesa       = false;
                        }else{
                            $continuar = false;
                        }
                    }

                    if($continuar){
                        $sala_horario = $result_sala_horarios->fetch();
                        $CIERREGASTRO = date('H:i', strtotime($sala_horario['hora_fin']));

                        $tProductosAbierto = true;
                        $tProductosCerrado = false;

                        $tCarrito = true;

                        // Obtenemos todas las categorias
                        $sql_categorias = "SELECT *
                                        FROM categorias_productos
                                        WHERE activa = 1
                                        ORDER BY orden";

                        $result_categorias = $conexion->query($sql_categorias);

                        $array_categorias = array();
                        $array_productos  = array();
                        // Si no hay error en la consulta
                        if ($result_categorias->rowCount() > 0) {
                            foreach ($result_categorias->fetchAll() as $row_categoria) {
                                // TODOS LOS PRODUCTOS de la categoria
                                $sql_productos = "SELECT p.*, sp.precio as precio_real
                                                  FROM productos p
                                                  JOIN servicios_productos sp on p.id = sp.producto_id
                                                  WHERE p.categoria_id = $row_categoria[0]
                                                  AND sp.servicio_id = $servicio_id
                                                  AND p.cantidad_disponible > 0
                                                  AND p.activo = 1
                                                  AND p.publicado = 1
                                                  ORDER BY p.orden";

                                $result_productos = $conexion->query($sql_productos);

                                // Si no hay error en la consulta
                                if ($result_productos->rowCount() > 0) {

                                    $array_categorias[$row_categoria['id']]['categorias'] = $row_categoria['nombre'];

                                    foreach ($result_productos->fetchAll() as $row_producto) {
                                        $value_format = number_format($row_producto['precio_real'], 2);

                                        $array_categorias[$row_categoria['id']]['productos'][$row_producto[0]]['IDPRODUCTO']     = $row_producto[0];
                                        $array_categorias[$row_categoria['id']]['productos'][$row_producto[0]]['NOMBREPRODUCTO'] = $row_producto['nombre'];
                                        $array_categorias[$row_categoria['id']]['productos'][$row_producto[0]]['IMAGENPRODUCTO'] = $row_producto['imagen'];
                                        $array_categorias[$row_categoria['id']]['productos'][$row_producto[0]]['PRECIOPRODUCTO'] = $value_format;
                                    }
                                    $tProductos = true;
                                }
                            }
                            $tCategorias = true;

                            // Comprobamos si hay cupones disponibles para que salga o no la posibilidad de usarlo
                            $fecha_reserva = date('Y-m-d');

                            $sql_existen_cupones = "SELECT *
                                                    FROM bonos
                                                    WHERE servicio_id = " . $servicio_id . "
                                                    AND  desde_fecha <= '" . $fecha_reserva . "'
                                                    AND '" . $fecha_reserva . "' <= hasta_fecha
                                                    AND activo = 1
                                                    AND usos_restantes > 0";

                            $result_existen_cupones = $conexion->query($sql_existen_cupones);

                            if ($result_existen_cupones->rowCount() > 0) {
                                $tCuponGastro = true;
                            } else {
                                $tCuponGastro = false;
                            }

                            // Fcupones

                        } else {
                            $tCategorias = false;
                            $tProductos  = false;
                        }
                    }else{
                        // Cambiamos mensajes por los de la mesa
                        $tProductosAbierto = false;
                        $tProductosCerrado = false;
                        $tNoMesa           = true; 
                    }
                }
            } else {
                $tProductosAbierto = false;
                $tProductosCerrado = true;
                $tNoMesa           = false;
            }
        }else{
            $tProductosAbierto = false;
            $tProductosCerrado = true;
            $tNoMesa           = false;
        }
    } else {
        $tProductosAbierto = false;
        $tProductosCerrado = true;
        $tNoMesa           = false;
    }
      
} else {
    $tProductosAbierto = false;
    $tProductosCerrado = false;
    $tNoMesa           = true;
}

$protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];
$URLHOME    = $domainLink;

require_once DIRLANGUAGETEMPLATES . "reserva_web/formulario_productos.ctp";
