<?php
// header('Content-Type:text/html; charset=UTF-8');

/****************************************************************
Includes
 *****************************************************************/
require_once 'config.php';
require_once DIRLIB . 'SPDO.php';
require_once DIRLIB . 'funciones.php';
require_once DIRLIB . 'registro_logs.php';
require_once DIRLIB . 'KLogger.php';

/****************************************************************
Conectamos a la BD
 *****************************************************************/
global $conexion;
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*****************************************************************
 * Traducciones
 *****************************************************************/
require_once DIRLIBCLASS . 'lang.php';

//Para obtener la traducción
$language = new lang();

$lang = $language->getSessionLang();

$lang .= '.utf8';
putenv("LANG=" . $lang);
// IMPORTANTE: ESTABLECER SOLO LC_MESSAGES ¡MESSAGES! Que si no se lía con los decimales
setlocale(LC_MESSAGES, $lang);

$directory = dirname(__FILE__) . '/Locale';

// Establecemos los dominios
$domain = "messages";

//Vinculamos los dominios
bindtextdomain($domain, $directory);

// Vinculamos la codificacion de los dominios
bind_textdomain_codeset($domain, 'UTF-8');

//Establecemos el dominio a utilizar
textdomain($domain);

//Inicializamos el logger
$logger = new KLogger(DIRLOG . "klogger/log.txt", KLogger::DEBUG);

/*****************************************************************
 * Mensajes del sistema, Clases
 *****************************************************************/
require_once DIRLIBCLASS . 'messages.php';
$message = new messages();
require_once DIRLIBCLASS . 'Categoria.php';
$Categoria = new Categoria();

/****************************************************************
Inicializamos las plantillas
 *****************************************************************/

// require_once DIRLIB . 'Sigma.php';
// $tpl = new HTML_Template_Sigma(DIRTPL);
